/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.ws.rs.core.Response;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.shrinkwrap.api.Archive;
import org.jbpm.services.task.commands.CompleteTaskCommand;
import org.jbpm.services.task.commands.GetTasksByProcessInstanceIdCommand;
import org.jbpm.services.task.commands.GetTasksOwnedCommand;
import org.jbpm.services.task.commands.StartTaskCommand;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.services.client.api.RemoteConfiguration;
import org.kie.services.client.api.RemoteJmsRuntimeEngineFactory;
import org.kie.services.client.api.RemoteRestSessionFactory;
import org.kie.services.client.serialization.jaxb.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.JaxbSerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbLongListResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbTaskSummaryListResponse;
import org.kie.services.remote.IntegrationTestBase;
import org.kie.services.remote.setup.ArquillianJbossServerSetupTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunAsClient
@RunWith(value=Arquillian.class)
@ServerSetup(value={ArquillianJbossServerSetupTask.class})
public class RestAndJmsIntegrationTest
extends IntegrationTestBase {
    private static Logger logger = LoggerFactory.getLogger(RestAndJmsIntegrationTest.class);
    private static final String CONNECTION_FACTORY_NAME = "jms/RemoteConnectionFactory";
    private static final String TASK_QUEUE_NAME = "jms/queue/KIE.TASK";
    private static final String RESPONSE_QUEUE_NAME = "jms/queue/KIE.RESPONSE";
    private static final String DEPLOYMENT_ID = "test";
    private static final String USER_ID = "salaboy";
    @ArquillianResource
    URL deploymentUrl;
    private static final long QUALITY_OF_SERVICE_THRESHOLD_MS = 5000L;

    @Deployment(testable=false)
    public static Archive<?> createWar() {
        return RestAndJmsIntegrationTest.createWebArchive();
    }

    @AfterClass
    public static void waitForTxOnServer() throws InterruptedException {
        Thread.sleep(1000L);
    }

    @Test
    @InSequence(value=0)
    public void testJmsStartProcess() throws Exception {
        StartProcessCommand cmd = new StartProcessCommand("org.jbpm.humantask");
        JaxbCommandsRequest req = new JaxbCommandsRequest(DEPLOYMENT_ID, (Command)cmd);
        JaxbCommandsResponse response = this.sendJmsJaxbCommandsRequest(TASK_QUEUE_NAME, req);
        Assert.assertNotNull((String)"response was null.", (Object)response);
        Assert.assertTrue((String)"response did not contain any command responses", (response.getResponses() != null && response.getResponses().size() > 0 ? 1 : 0) != 0);
        JaxbCommandResponse cmdResponse = (JaxbCommandResponse)response.getResponses().get(0);
        Assert.assertTrue((String)("response is not the proper class type : " + cmdResponse.getClass().getSimpleName()), (boolean)(cmdResponse instanceof JaxbProcessInstanceResponse));
        ProcessInstance procInst = (ProcessInstance)cmdResponse;
        long procInstId = procInst.getId();
        cmd = new GetTasksByProcessInstanceIdCommand(procInstId);
        req = new JaxbCommandsRequest(DEPLOYMENT_ID, (Command)cmd);
        response = this.sendJmsJaxbCommandsRequest(TASK_QUEUE_NAME, req);
        Assert.assertNotNull((String)"response was null.", (Object)response);
        Assert.assertTrue((String)"response did not contain any command responses", (response.getResponses() != null && response.getResponses().size() > 0 ? 1 : 0) != 0);
        cmdResponse = (JaxbCommandResponse)response.getResponses().get(0);
        Assert.assertTrue((String)("response is not the proper class type : " + cmdResponse.getClass().getSimpleName()), (boolean)(cmdResponse instanceof JaxbLongListResponse));
        long taskId = (Long)((JaxbLongListResponse)cmdResponse).getResult().get(0);
        cmd = new StartTaskCommand(taskId, USER_ID);
        req = new JaxbCommandsRequest(DEPLOYMENT_ID, (Command)cmd);
        req.getCommands().add(new CompleteTaskCommand(taskId, USER_ID, null));
        response = this.sendJmsJaxbCommandsRequest(TASK_QUEUE_NAME, req);
        Assert.assertNotNull((String)"response was null.", (Object)response);
        Assert.assertTrue((String)"response list was not empty", (response.getResponses().size() == 0 ? 1 : 0) != 0);
        cmd = new GetTasksOwnedCommand(USER_ID, "en-UK");
        req = new JaxbCommandsRequest(DEPLOYMENT_ID, (Command)cmd);
        req.getCommands().add(new GetTasksOwnedCommand("bob", "fr-CA"));
        req.getCommands().add(new GetProcessInstanceCommand(Long.valueOf(procInstId)));
        response = this.sendJmsJaxbCommandsRequest(TASK_QUEUE_NAME, req);
        Assert.assertNotNull((String)"response was null.", (Object)response);
        Assert.assertTrue((String)"response did not contain any command responses", (response.getResponses() != null && response.getResponses().size() > 0 ? 1 : 0) != 0);
        cmdResponse = (JaxbCommandResponse)response.getResponses().get(0);
        Assert.assertTrue((String)("response is not the proper class type : " + cmdResponse.getClass().getSimpleName()), (boolean)(cmdResponse instanceof JaxbTaskSummaryListResponse));
        List taskSummaries = ((JaxbTaskSummaryListResponse)cmdResponse).getResult();
        Assert.assertTrue((String)"task summary list is empty", (taskSummaries.size() > 0 ? 1 : 0) != 0);
        for (TaskSummary taskSum : taskSummaries) {
            if (taskSum.getId() != taskId) continue;
            Assert.assertTrue((String)("Task " + taskId + " should have completed."), (boolean)taskSum.getStatus().equals((Object)Status.Completed));
        }
        cmdResponse = (JaxbCommandResponse)response.getResponses().get(1);
        Assert.assertTrue((String)("response is not the proper class type : " + cmdResponse.getClass().getSimpleName()), (boolean)(cmdResponse instanceof JaxbTaskSummaryListResponse));
        taskSummaries = ((JaxbTaskSummaryListResponse)cmdResponse).getResult();
        Assert.assertTrue((String)("task summary list should be empty, but has " + taskSummaries.size() + " elements"), (taskSummaries.size() == 0 ? 1 : 0) != 0);
        cmdResponse = (JaxbCommandResponse)response.getResponses().get(2);
        Assert.assertNotNull((Object)cmdResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaxbCommandsResponse sendJmsJaxbCommandsRequest(String sendQueueName, JaxbCommandsRequest req) throws Exception {
        InitialContext context = RestAndJmsIntegrationTest.getRemoteInitialContext();
        ConnectionFactory factory = (ConnectionFactory)context.lookup(CONNECTION_FACTORY_NAME);
        Queue jbpmQueue = (Queue)context.lookup(sendQueueName);
        Queue responseQueue = (Queue)context.lookup(RESPONSE_QUEUE_NAME);
        Connection connection = null;
        Session session = null;
        JaxbCommandsResponse cmdResponse = null;
        try {
            connection = factory.createConnection("guest", "1234");
            session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)jbpmQueue);
            String corrId = UUID.randomUUID().toString();
            String selector = "JMSCorrelationID = '" + corrId + "'";
            MessageConsumer consumer = session.createConsumer((Destination)responseQueue, selector);
            connection.start();
            BytesMessage msg = session.createBytesMessage();
            msg.setJMSCorrelationID(corrId);
            msg.setIntProperty("serialization", 1);
            String xmlStr = JaxbSerializationProvider.convertJaxbObjectToString((Object)req);
            msg.writeUTF(xmlStr);
            producer.send((Message)msg);
            Message response = consumer.receive(5000L);
            Assert.assertNotNull((String)"Response is empty.", (Object)response);
            Assert.assertEquals((String)"Correlation id not equal to request msg id.", (Object)corrId, (Object)response.getJMSCorrelationID());
            Assert.assertNotNull((String)"Response from MDB was null!", (Object)response);
            xmlStr = ((BytesMessage)response).readUTF();
            cmdResponse = (JaxbCommandsResponse)JaxbSerializationProvider.convertStringToJaxbObject((String)xmlStr);
            Assert.assertNotNull((String)"Jaxb Cmd Response was null!", (Object)cmdResponse);
        }
        finally {
            if (connection != null) {
                connection.close();
                session.close();
            }
        }
        return cmdResponse;
    }

    private long findTaskId(long procInstId, List<TaskSummary> taskSumList) {
        long taskId = -1L;
        for (TaskSummary task : taskSumList) {
            if (task.getProcessInstanceId() != procInstId) continue;
            taskId = task.getId();
        }
        Assert.assertNotEquals((String)"Could not determine taskId!", (long)-1L, (long)taskId);
        return taskId;
    }

    @Test
    @InSequence(value=1)
    public void testRestUrlStartHumanTaskProcess() throws Exception {
        String urlString = new URL(this.deploymentUrl, this.deploymentUrl.getPath() + "rest/runtime/test/process/org.jbpm.humantask/start").toExternalForm();
        ClientRequest restRequest = new ClientRequest(urlString);
        logger.debug(">> [org.jbpm.humantask/start]" + urlString);
        ClientResponse responseObj = restRequest.post();
        Assert.assertEquals((long)200L, (long)responseObj.getStatus());
        JaxbProcessInstanceResponse processInstance = (JaxbProcessInstanceResponse)responseObj.getEntity(JaxbProcessInstanceResponse.class);
        long procInstId = processInstance.getId();
        urlString = new URL(this.deploymentUrl, this.deploymentUrl.getPath() + "rest/task/query?taskOwner=" + USER_ID).toExternalForm();
        restRequest = new ClientRequest(urlString);
        logger.debug(">> [task/query]" + urlString);
        responseObj = restRequest.get();
        Assert.assertEquals((long)200L, (long)responseObj.getStatus());
        JaxbTaskSummaryListResponse taskSumlistResponse = (JaxbTaskSummaryListResponse)responseObj.getEntity(JaxbTaskSummaryListResponse.class);
        long taskId = this.findTaskId(procInstId, taskSumlistResponse.getResult());
        urlString = new URL(this.deploymentUrl, this.deploymentUrl.getPath() + "rest/task/" + taskId + "/start?userId=" + USER_ID).toExternalForm();
        restRequest = new ClientRequest(urlString);
        logger.debug(">> [task/?/start] " + urlString);
        responseObj = restRequest.post();
        this.checkResponse(responseObj);
    }

    @Test
    @InSequence(value=2)
    public void testRestExecuteStartProcess() throws Exception {
        String urlString = new URL(this.deploymentUrl, this.deploymentUrl.getPath() + "rest/runtime/test/execute").toExternalForm();
        ClientRequest restRequest = new ClientRequest(urlString);
        JaxbCommandsRequest commandMessage = new JaxbCommandsRequest(DEPLOYMENT_ID, (Command)new StartProcessCommand("org.jbpm.humantask"));
        String body = JaxbSerializationProvider.convertJaxbObjectToString((Object)commandMessage);
        restRequest.body("application/xml", (Object)body);
        logger.debug(">> [startProcess] " + urlString);
        ClientResponse responseObj = restRequest.post();
        Assert.assertEquals((long)200L, (long)responseObj.getStatus());
        JaxbCommandsResponse cmdsResp = (JaxbCommandsResponse)responseObj.getEntity(JaxbCommandsResponse.class);
        long procInstId = ((ProcessInstance)cmdsResp.getResponses().get(0)).getId();
        restRequest = new ClientRequest(urlString);
        commandMessage = new JaxbCommandsRequest(DEPLOYMENT_ID, (Command)new GetTasksByProcessInstanceIdCommand(procInstId));
        body = JaxbSerializationProvider.convertJaxbObjectToString((Object)commandMessage);
        restRequest.body("application/xml", (Object)body);
        logger.debug(">> [getTasksByProcessInstanceId] " + urlString);
        responseObj = restRequest.post();
        Assert.assertEquals((long)200L, (long)responseObj.getStatus());
        JaxbCommandsResponse cmdResponse = (JaxbCommandsResponse)responseObj.getEntity(JaxbCommandsResponse.class);
        List list = (List)((JaxbCommandResponse)cmdResponse.getResponses().get(0)).getResult();
        long taskId = (Long)list.get(0);
        logger.debug(">> [startTask] " + urlString);
        restRequest = new ClientRequest(urlString);
        commandMessage = new JaxbCommandsRequest((Command)new StartTaskCommand(taskId, USER_ID));
        body = JaxbSerializationProvider.convertJaxbObjectToString((Object)commandMessage);
        restRequest.body("application/xml", (Object)commandMessage);
        responseObj = restRequest.post();
        Assert.assertEquals((long)200L, (long)responseObj.getStatus());
        urlString = new URL(this.deploymentUrl, this.deploymentUrl.getPath() + "rest/task/execute").toExternalForm();
        restRequest = new ClientRequest(urlString);
        commandMessage = new JaxbCommandsRequest((Command)new CompleteTaskCommand(taskId, USER_ID, null));
        body = JaxbSerializationProvider.convertJaxbObjectToString((Object)commandMessage);
        restRequest.body("application/xml", (Object)commandMessage);
        logger.debug(">> [completeTask] " + urlString);
        responseObj = restRequest.post();
        logger.debug("response status: " + responseObj.getStatus());
    }

    @Test
    @InSequence(value=3)
    public void testRestRemoteApiHumanTaskProcess() throws Exception {
        RemoteRestSessionFactory restSessionFactory = new RemoteRestSessionFactory(DEPLOYMENT_ID, this.deploymentUrl.toExternalForm(), RemoteConfiguration.AuthenticationType.FORM, "guest", "1234");
        RuntimeEngine engine = restSessionFactory.newRuntimeEngine();
        KieSession ksession = engine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("org.jbpm.humantask");
        logger.debug("Started process instance: " + processInstance + " " + (processInstance == null ? "" : Long.valueOf(processInstance.getId())));
        TaskService taskService = engine.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner(USER_ID, "en-UK");
        long taskId = this.findTaskId(processInstance.getId(), tasks);
        logger.debug("Found task " + taskId);
        Task task = taskService.getTaskById(taskId);
        logger.debug("Got task " + taskId + ": " + task);
        taskService.start(taskId, USER_ID);
        taskService.complete(taskId, USER_ID, null);
        logger.debug("Now expecting failure");
        try {
            taskService.complete(taskId, USER_ID, null);
            Assert.fail((String)("Should not be able to complete task " + taskId + " a second time."));
        }
        catch (Throwable t) {
            // empty catch block
        }
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List taskIds = taskService.getTasksByStatusByProcessInstanceId(processInstance.getId(), statuses, "en-UK");
        Assert.assertEquals((String)"Expected 2 tasks.", (long)2L, (long)taskIds.size());
    }

    @Test
    @InSequence(value=4)
    public void testJmsRemoteApiHumanTaskProcess() throws Exception {
        RuntimeEngine engine = new RemoteJmsRuntimeEngineFactory(DEPLOYMENT_ID, RestAndJmsIntegrationTest.getRemoteInitialContext(), "guest", "1234").newRuntimeEngine();
        KieSession ksession = engine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("org.jbpm.humantask");
        logger.debug("Started process instance: " + processInstance + " " + (processInstance == null ? "" : Long.valueOf(processInstance.getId())));
        TaskService taskService = engine.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner(USER_ID, "en-UK");
        long taskId = this.findTaskId(processInstance.getId(), tasks);
        logger.debug("Found task " + taskId);
        Task task = taskService.getTaskById(taskId);
        logger.debug("Got task " + taskId + ": " + task);
        taskService.start(taskId, USER_ID);
        taskService.complete(taskId, USER_ID, null);
        logger.debug("Now expecting failure");
        try {
            taskService.complete(taskId, USER_ID, null);
            Assert.fail((String)("Should not have been able to complete task " + taskId + " a second time."));
        }
        catch (Throwable t) {
            // empty catch block
        }
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List taskIds = taskService.getTasksByStatusByProcessInstanceId(processInstance.getId(), statuses, "en-UK");
        Assert.assertEquals((String)"Expected 2 tasks.", (long)2L, (long)taskIds.size());
    }

    @Test
    public void testExecuteTaskCommands() throws Exception {
        RuntimeEngine engine = new RemoteRestSessionFactory(DEPLOYMENT_ID, this.deploymentUrl.toExternalForm()).newRuntimeEngine();
        KieSession ksession = engine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("org.jbpm.humantask");
        long processInstanceId = processInstance.getId();
        JaxbCommandResponse<?> response = this.executeTaskCommand(DEPLOYMENT_ID, (Command<?>)new GetTasksByProcessInstanceIdCommand(processInstanceId));
        long taskId = (Long)((JaxbLongListResponse)response).getResult().get(0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", USER_ID);
    }

    private JaxbCommandResponse<?> executeTaskCommand(String deploymentId, Command<?> command) throws Exception {
        ArrayList commands = new ArrayList();
        commands.add(command);
        String urlString = new URL(this.deploymentUrl, this.deploymentUrl.getPath() + "rest/runtime/" + DEPLOYMENT_ID + "/execute").toExternalForm();
        logger.info("Client request to: " + urlString);
        ClientRequest restRequest = new ClientRequest(urlString);
        JaxbCommandsRequest commandMessage = new JaxbCommandsRequest(commands);
        Assert.assertNotNull((String)"Commands are null!", (Object)commandMessage.getCommands());
        Assert.assertTrue((String)"Commands are empty!", (commandMessage.getCommands().size() > 0 ? 1 : 0) != 0);
        String body = JaxbSerializationProvider.convertJaxbObjectToString((Object)commandMessage);
        restRequest.body("application/xml", (Object)body);
        ClientResponse responseObj = restRequest.post(JaxbCommandsResponse.class);
        this.checkResponse(responseObj);
        JaxbCommandsResponse cmdsResp = (JaxbCommandsResponse)responseObj.getEntity();
        return (JaxbCommandResponse)cmdsResp.getResponses().get(0);
    }

    private void checkResponse(ClientResponse<?> responseObj) throws Exception {
        ClientResponse test = BaseClientResponse.copyFromError(responseObj);
        responseObj.resetStream();
        if (test.getResponseStatus() == Response.Status.BAD_REQUEST) {
            throw new BadRequestException((String)test.getEntity(String.class));
        }
        if (test.getResponseStatus() != Response.Status.OK) {
            throw new Exception("Request operation failed. Response status = " + test.getResponseStatus() + "\n\n" + (String)test.getEntity(String.class));
        }
        logger.debug("Response: " + (String)test.getEntity(String.class));
    }
}

