/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.drools.core.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.command.ClearHistoryLogsCommand;
import org.jbpm.process.audit.command.FindNodeInstancesCommand;
import org.jbpm.process.audit.command.FindProcessInstanceCommand;
import org.jbpm.process.audit.command.FindProcessInstancesCommand;
import org.jbpm.process.audit.command.FindSubProcessInstancesCommand;
import org.jbpm.process.audit.command.FindVariableInstancesCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.services.client.serialization.jaxb.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbExceptionResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbHistoryLogList;
import org.kie.services.client.serialization.jaxb.impl.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbProcessInstanceWithVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbVariablesResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.kie.services.remote.cdi.ProcessRequestBean;
import org.kie.services.remote.rest.ResourceBase;
import org.kie.services.remote.util.CommandsRequestUtil;
import org.kie.services.remote.util.Paginator;

@Path(value="/runtime/{id: [a-zA-Z0-9-:\\.]+}")
@RequestScoped
public class RuntimeResource
extends ResourceBase {
    @Inject
    private ProcessRequestBean processRequestBean;
    @PathParam(value="id")
    private String deploymentId;
    @Context
    private HttpServletRequest request;

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="/execute")
    public JaxbCommandsResponse execute(JaxbCommandsRequest cmdsRequest) {
        return CommandsRequestUtil.processJaxbCommandsRequest(cmdsRequest, this.processRequestBean);
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/start")
    public JaxbProcessInstanceResponse startNewProcess(@PathParam(value="processDefId") String processId) {
        Map<String, List<String>> formParams = RuntimeResource.getRequestParams(this.request);
        Map<String, Object> params = RuntimeResource.extractMapFromParams(formParams, "process/" + processId + "/start");
        StartProcessCommand cmd = new StartProcessCommand(processId, params);
        Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to start process with process definition id '" + processId + "'");
        return new JaxbProcessInstanceResponse((ProcessInstance)result, this.request);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/process/instance/{procInstId: [0-9]+}")
    public JaxbProcessInstanceResponse getProcessInstanceDetails(@PathParam(value="procInstId") Long procInstId) {
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand(procInstId);
        cmd.setReadOnly(true);
        Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to get process instance " + procInstId);
        if (result != null) {
            return new JaxbProcessInstanceResponse((ProcessInstance)result);
        }
        throw new BadRequestException("Unable to retrieve process instance " + procInstId + " which may have been completed. Please see the history operations.");
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/process/instance/{procInstId: [0-9]+}/abort")
    public JaxbGenericResponse abortProcessInstance(@PathParam(value="procInstId") Long procInstId) {
        AbortProcessInstanceCommand cmd = new AbortProcessInstanceCommand();
        cmd.setProcessInstanceId(procInstId);
        this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to abort process instance " + procInstId);
        return new JaxbGenericResponse(this.request);
    }

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="/process/instance/{procInstId: [0-9]+}/signal")
    public JaxbGenericResponse signalProcessInstance(@PathParam(value="procInstId") Long procInstId) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String eventType = RuntimeResource.getStringParam("eventType", true, params, "signal");
        Object event = RuntimeResource.getObjectParam("event", false, params, "signal");
        SignalEventCommand cmd = new SignalEventCommand(procInstId.longValue(), eventType, event);
        String errorMsg = "Unable to signal process instance";
        errorMsg = eventType == null ? errorMsg + " with empty signal" : errorMsg + " with signal type '" + eventType + "'";
        if (event != null) {
            errorMsg = errorMsg + " and event '" + event + "'";
        }
        this.internalDoKieSessionOperation((Command<?>)cmd, errorMsg);
        return new JaxbGenericResponse(this.request);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/process/instance/{procInstId: [0-9]+}/variables")
    public JaxbVariablesResponse getProcessInstanceVariables(@PathParam(value="procInstId") Long procInstId) {
        Map<String, String> vars = this.getVariables(procInstId);
        return new JaxbVariablesResponse(vars, this.request);
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/signal/{signal: [a-zA-Z0-9-]+}")
    public JaxbGenericResponse signalEvent(@PathParam(value="signal") String signal) {
        Map<String, List<String>> formParams = RuntimeResource.getRequestParams(this.request);
        Object event = RuntimeResource.getObjectParam("event", false, formParams, "signal/" + signal);
        SignalEventCommand cmd = new SignalEventCommand(signal, event);
        String errorMsg = "Unable to send signal '" + signal + "'";
        if (event != null) {
            errorMsg = errorMsg + " with event '" + event + "'";
        }
        this.internalDoKieSessionOperation((Command<?>)cmd, errorMsg);
        return new JaxbGenericResponse(this.request);
    }

    @POST
    @Path(value="/workitem/{workItemId: [0-9-]+}/{oper: [a-zA-Z]+}")
    public JaxbGenericResponse doWorkItemOperation(@PathParam(value="workItemId") Long workItemId, @PathParam(value="oper") String operation) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        CompleteWorkItemCommand cmd = null;
        if ("complete".equalsIgnoreCase(operation.trim())) {
            Map<String, Object> results = RuntimeResource.extractMapFromParams(params, operation);
            cmd = new CompleteWorkItemCommand(workItemId.longValue(), results);
        } else if ("abort".equalsIgnoreCase(operation.toLowerCase())) {
            cmd = new AbortWorkItemCommand(workItemId.longValue());
        } else {
            throw new BadRequestException("Unsupported operation: /process/instance/" + workItemId + "/" + operation);
        }
        this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to " + operation + " workitem " + workItemId);
        return new JaxbGenericResponse(this.request);
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/history/clear")
    public JaxbGenericResponse clearProcessInstanceLogs() {
        ClearHistoryLogsCommand cmd = new ClearHistoryLogsCommand();
        this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to clear process instance logs");
        return new JaxbGenericResponse(this.request);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/history/instance")
    public JaxbHistoryLogList getProcessInstanceLogs() {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params);
        FindProcessInstancesCommand cmd = new FindProcessInstancesCommand();
        Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to get process instance logs");
        List results = (List)result;
        results = new Paginator().paginate(pageInfo, results);
        return new JaxbHistoryLogList(results);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/history/instance/{procInstId: [0-9]+}")
    public JaxbHistoryLogList getSpecificProcessInstanceLogs(@PathParam(value="procInstId") long procInstId) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params);
        FindProcessInstanceCommand cmd = new FindProcessInstanceCommand(procInstId);
        Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to get process instance logs for process instance " + procInstId);
        ProcessInstanceLog procInstLog = (ProcessInstanceLog)result;
        List<Object> logList = new ArrayList<ProcessInstanceLog>();
        logList.add(procInstLog);
        logList = new Paginator<ProcessInstanceLog>().paginate(pageInfo, logList);
        return new JaxbHistoryLogList(logList);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/history/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}")
    public JaxbHistoryLogList getVariableOrNodeHistoryList(@PathParam(value="procInstId") Long procInstId, @PathParam(value="oper") String operation) {
        JaxbHistoryLogList resultList;
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params);
        if ("child".equalsIgnoreCase(operation)) {
            FindSubProcessInstancesCommand cmd = new FindSubProcessInstancesCommand(procInstId.longValue());
            Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to get child process instance logs for process instance " + procInstId);
            List procInstLogList = (List)result;
            procInstLogList = new Paginator().paginate(pageInfo, procInstLogList);
            resultList = new JaxbHistoryLogList(procInstLogList);
        } else if ("node".equalsIgnoreCase(operation)) {
            FindNodeInstancesCommand cmd = new FindNodeInstancesCommand(procInstId.longValue());
            Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to get node instance logs for process instance " + procInstId);
            List nodeInstLogList = (List)result;
            nodeInstLogList = new Paginator().paginate(pageInfo, nodeInstLogList);
            resultList = new JaxbHistoryLogList(nodeInstLogList);
        } else if ("variable".equalsIgnoreCase(operation)) {
            FindVariableInstancesCommand cmd = new FindVariableInstancesCommand(procInstId.longValue());
            Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to get variable instance logs for process instance " + procInstId);
            List varInstLogList = (List)result;
            varInstLogList = new Paginator().paginate(pageInfo, varInstLogList);
            resultList = new JaxbHistoryLogList(varInstLogList);
        } else {
            throw new BadRequestException("Unsupported operation: /history/instance/" + procInstId + "/" + operation);
        }
        return resultList;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/history/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}/{logId: [a-zA-Z0-9-:\\.]+}")
    public JaxbHistoryLogList getSpecificVariableOrNodeHistoryList(@PathParam(value="procInstId") Long procInstId, @PathParam(value="oper") String operation, @PathParam(value="logId") String logId) {
        JaxbHistoryLogList resultList;
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params);
        if ("node".equalsIgnoreCase(operation)) {
            FindNodeInstancesCommand cmd = new FindNodeInstancesCommand(procInstId.longValue(), logId);
            Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to get node instance logs for node '" + logId + "' in process instance " + procInstId);
            List nodeInstLogList = (List)result;
            nodeInstLogList = new Paginator().paginate(pageInfo, nodeInstLogList);
            resultList = new JaxbHistoryLogList(nodeInstLogList);
        } else if ("variable".equalsIgnoreCase(operation)) {
            FindVariableInstancesCommand cmd = new FindVariableInstancesCommand(procInstId.longValue(), logId);
            Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to get variable instance logs for variable '" + logId + "' in process instance " + procInstId);
            List varInstLogList = (List)result;
            varInstLogList = new Paginator().paginate(pageInfo, varInstLogList);
            resultList = new JaxbHistoryLogList(varInstLogList);
        } else {
            throw new BadRequestException("Unsupported operation: /history/instance/" + procInstId + "/" + operation + "/" + logId);
        }
        return resultList;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/history/process/{procId: [a-zA-Z0-9-:\\.]+}")
    public JaxbHistoryLogList getProcessInstanceLogs(@PathParam(value="procId") String processId) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params);
        FindProcessInstancesCommand cmd = new FindProcessInstancesCommand(processId);
        Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to get process instance logs for process '" + processId + "'");
        List procInstLogList = (List)result;
        procInstLogList = new Paginator().paginate(pageInfo, procInstLogList);
        return new JaxbHistoryLogList(procInstLogList);
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/withvars/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/start")
    public JaxbProcessInstanceWithVariablesResponse startNewProcessWithVars(@PathParam(value="processDefId") String processId) {
        Map<String, List<String>> formParams = RuntimeResource.getRequestParams(this.request);
        Map<String, Object> params = RuntimeResource.extractMapFromParams(formParams, "process/" + processId + "/start");
        StartProcessCommand cmd = new StartProcessCommand(processId, params);
        Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to get process instance logs for process '" + processId + "'");
        ProcessInstance procInst = (ProcessInstance)result;
        Map<String, String> vars = this.getVariables(procInst.getId());
        JaxbProcessInstanceWithVariablesResponse resp = new JaxbProcessInstanceWithVariablesResponse(procInst, vars, this.request);
        return resp;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}")
    public JaxbProcessInstanceWithVariablesResponse getProcessInstanceWithVars(@PathParam(value="procInstId") Long procInstId) {
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand(procInstId);
        cmd.setReadOnly(true);
        Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to get process instance " + procInstId);
        if (result != null) {
            ProcessInstance procInst = (ProcessInstance)result;
            Map<String, String> vars = this.getVariables(procInstId);
            return new JaxbProcessInstanceWithVariablesResponse(procInst, vars, this.request);
        }
        throw new BadRequestException("Unable to retrieve process instance " + procInstId + " since it has been completed. Please see the history operations.");
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}/signal")
    public JaxbProcessInstanceWithVariablesResponse signalProcessInstanceWithVars(@PathParam(value="procInstId") Long procInstId) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String eventType = RuntimeResource.getStringParam("eventType", true, params, "signal");
        Object event = RuntimeResource.getObjectParam("event", false, params, "signal");
        SignalEventCommand cmd = new SignalEventCommand(procInstId.longValue(), eventType, event);
        String errorMsg = "Unable to signal process instance " + procInstId;
        errorMsg = eventType == null ? errorMsg + " with empty signal" : errorMsg + " with signal type '" + eventType + "'";
        if (event != null) {
            errorMsg = errorMsg + " and event '" + event + "'";
        }
        this.internalDoKieSessionOperation((Command<?>)cmd, errorMsg);
        cmd = new GetProcessInstanceCommand(procInstId);
        ((GetProcessInstanceCommand)cmd).setReadOnly(true);
        Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to get process instance " + procInstId);
        ProcessInstance processInstance = (ProcessInstance)result;
        Map<String, String> vars = this.getVariables(processInstance.getId());
        return new JaxbProcessInstanceWithVariablesResponse(processInstance, vars);
    }

    private Object internalDoKieSessionOperation(Command<?> cmd, String errorMsg) {
        Object result = this.processRequestBean.doKieSessionOperation(cmd, this.deploymentId);
        if (result instanceof JaxbExceptionResponse) {
            throw new InternalServerErrorException(errorMsg, (Throwable)((JaxbExceptionResponse)result).getCause());
        }
        return result;
    }

    private Map<String, String> getVariables(long processInstanceId) {
        FindVariableInstancesCommand cmd = new FindVariableInstancesCommand(processInstanceId);
        Object result = this.internalDoKieSessionOperation((Command<?>)cmd, "Unable to retrieve process variables from process instance " + processInstanceId);
        List varInstLogList = (List)result;
        HashMap<String, String> vars = new HashMap<String, String>();
        if (varInstLogList.isEmpty()) {
            return vars;
        }
        HashMap<String, VariableInstanceLog> varLogMap = new HashMap<String, VariableInstanceLog>();
        for (VariableInstanceLog variableInstanceLog : varInstLogList) {
            String varId = variableInstanceLog.getVariableId();
            VariableInstanceLog prevVarLog = varLogMap.put(varId, variableInstanceLog);
            if (prevVarLog == null || !prevVarLog.getDate().after(variableInstanceLog.getDate())) continue;
            varLogMap.put(varId, prevVarLog);
        }
        for (Map.Entry entry : varLogMap.entrySet()) {
            vars.put((String)entry.getKey(), ((VariableInstanceLog)entry.getValue()).getValue());
        }
        return vars;
    }
}

