/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jbpm.kie.services.api.IdentityProvider;
import org.jbpm.services.task.commands.ActivateTaskCommand;
import org.jbpm.services.task.commands.ClaimNextAvailableTaskCommand;
import org.jbpm.services.task.commands.ClaimTaskCommand;
import org.jbpm.services.task.commands.CompleteTaskCommand;
import org.jbpm.services.task.commands.DelegateTaskCommand;
import org.jbpm.services.task.commands.ExitTaskCommand;
import org.jbpm.services.task.commands.FailTaskCommand;
import org.jbpm.services.task.commands.ForwardTaskCommand;
import org.jbpm.services.task.commands.GetContentCommand;
import org.jbpm.services.task.commands.GetTaskAssignedAsBusinessAdminCommand;
import org.jbpm.services.task.commands.GetTaskAssignedAsPotentialOwnerCommand;
import org.jbpm.services.task.commands.GetTaskByWorkItemIdCommand;
import org.jbpm.services.task.commands.GetTaskCommand;
import org.jbpm.services.task.commands.GetTasksByProcessInstanceIdCommand;
import org.jbpm.services.task.commands.GetTasksByStatusByProcessInstanceIdCommand;
import org.jbpm.services.task.commands.GetTasksOwnedCommand;
import org.jbpm.services.task.commands.NominateTaskCommand;
import org.jbpm.services.task.commands.ReleaseTaskCommand;
import org.jbpm.services.task.commands.ResumeTaskCommand;
import org.jbpm.services.task.commands.SkipTaskCommand;
import org.jbpm.services.task.commands.StartTaskCommand;
import org.jbpm.services.task.commands.StopTaskCommand;
import org.jbpm.services.task.commands.SuspendTaskCommand;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.xml.JaxbContent;
import org.jbpm.services.task.impl.model.xml.JaxbTask;
import org.jbpm.services.task.query.TaskSummaryImpl;
import org.kie.api.command.Command;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.services.client.serialization.jaxb.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbExceptionResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbTaskSummaryListResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.kie.services.remote.cdi.ProcessRequestBean;
import org.kie.services.remote.rest.ResourceBase;
import org.kie.services.remote.rest.RuntimeResource;
import org.kie.services.remote.util.CommandsRequestUtil;
import org.kie.services.remote.util.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/task")
@RequestScoped
public class TaskResource
extends ResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeResource.class);
    @Inject
    private ProcessRequestBean processRequestBean;
    @Context
    private HttpServletRequest request;
    @Inject
    private IdentityProvider identityProvider;
    private static String[] allowedOperations = new String[]{"activate", "claim", "claimnextavailable", "complete", "delegate", "exit", "fail", "forward", "release", "resume", "skip", "start", "stop", "suspend", "nominate"};
    private static String[] allowedQueryParams = new String[]{"workItemId", "taskId", "businessAdministrator", "potentialOwner", "status", "taskOwner", "processInstanceId", "language"};

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="/execute")
    public JaxbCommandsResponse execute(JaxbCommandsRequest cmdsRequest) {
        return CommandsRequestUtil.restProcessJaxbCommandsRequest(cmdsRequest, this.processRequestBean);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/query")
    public JaxbTaskSummaryListResponse query(@Context UriInfo uriInfo) {
        Map<String, List<String>> params = TaskResource.getRequestParams(this.request);
        List<Long> workItemIdList = TaskResource.getLongListParam(allowedQueryParams[0], false, params, "query", true);
        List<Long> taskIdList = TaskResource.getLongListParam(allowedQueryParams[1], false, params, "query", true);
        List<String> busAdminList = TaskResource.getStringListParam(allowedQueryParams[2], false, params, "query");
        List<String> potOwnList = TaskResource.getStringListParam(allowedQueryParams[3], false, params, "query");
        List<String> statusStrList = TaskResource.getStringListParam(allowedQueryParams[4], false, params, "query");
        List<String> taskOwnList = TaskResource.getStringListParam(allowedQueryParams[5], false, params, "query");
        List<Long> procInstIdList = TaskResource.getLongListParam(allowedQueryParams[6], false, params, "query", true);
        String language = TaskResource.getStringParam(allowedQueryParams[7], false, params, "query");
        for (String queryParam : params.keySet()) {
            boolean allowed = false;
            for (String allowedParam : allowedQueryParams) {
                if (!allowedParam.equalsIgnoreCase(queryParam)) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            throw new BadRequestException(queryParam + " is an unknown and unsupported query param for the task query operation.");
        }
        int[] pageInfo = TaskResource.getPageNumAndPageSize(params);
        Paginator<Object> paginator = new Paginator<Object>();
        if (language == null) {
            language = "en-UK";
        }
        List<Status> statusList = TaskResource.convertStringListToStatusList(statusStrList);
        LinkedList<Object> cmds = new LinkedList<Object>();
        if (!workItemIdList.isEmpty()) {
            for (Long workItemId : workItemIdList) {
                cmds.add(new GetTaskByWorkItemIdCommand(workItemId.longValue()));
            }
        }
        if (!taskIdList.isEmpty()) {
            for (Long taskId : taskIdList) {
                cmds.add(new GetTaskCommand(taskId.longValue()));
            }
        }
        HashSet<TaskSummaryImpl> alreadyRetrievedSet = new HashSet<TaskSummaryImpl>();
        List<Object> results = new ArrayList();
        Command cmd = null;
        while (!cmds.isEmpty()) {
            TaskSummaryImpl taskSum;
            cmd = (Command)cmds.poll();
            TaskImpl task = (TaskImpl)this.internalDoTaskOperation(cmd, "Unable to execute " + cmd.getClass().getSimpleName());
            if (task == null || !alreadyRetrievedSet.add(taskSum = TaskResource.convertTaskToTaskSummary(task))) continue;
            results.add(taskSum);
        }
        if (results.size() >= pageInfo[2]) {
            results = paginator.paginate(pageInfo, results);
            return new JaxbTaskSummaryListResponse(results);
        }
        int assignments = 0;
        assignments += potOwnList.isEmpty() ? 0 : 1;
        assignments += busAdminList.isEmpty() ? 0 : 1;
        if ((assignments += taskOwnList.isEmpty() ? 0 : 1) == 0) {
            if (!procInstIdList.isEmpty()) {
                if (!statusList.isEmpty()) {
                    for (Long procInstId : procInstIdList) {
                        cmds.add(new GetTasksByStatusByProcessInstanceIdCommand(procInstId.longValue(), language, statusList));
                    }
                } else {
                    for (Long procInstId : procInstIdList) {
                        cmd = new GetTasksByProcessInstanceIdCommand(procInstId.longValue());
                        List procInstTaskIdList = (List)this.internalDoTaskOperation(cmd, "Unable to execute " + cmd.getClass().getSimpleName());
                        for (Long taskId : procInstTaskIdList) {
                            TaskSummaryImpl taskSum;
                            cmd = new GetTaskCommand(taskId.longValue());
                            TaskImpl task = (TaskImpl)this.internalDoTaskOperation(cmd, "Unable to execute " + cmd.getClass().getSimpleName());
                            if (task == null || !alreadyRetrievedSet.add(taskSum = TaskResource.convertTaskToTaskSummary(task))) continue;
                            results.add(taskSum);
                        }
                        if (results.size() < pageInfo[2]) continue;
                        results = paginator.paginate(pageInfo, results);
                        return new JaxbTaskSummaryListResponse(results);
                    }
                }
            }
        } else {
            if (!busAdminList.isEmpty()) {
                for (String userId : busAdminList) {
                    cmds.add(new GetTaskAssignedAsBusinessAdminCommand(userId, language));
                }
            }
            if (!potOwnList.isEmpty()) {
                if (statusList.isEmpty()) {
                    for (String userId : potOwnList) {
                        cmds.add(new GetTaskAssignedAsPotentialOwnerCommand(userId, language));
                    }
                } else {
                    for (String userId : potOwnList) {
                        cmds.add(new GetTaskAssignedAsPotentialOwnerCommand(userId, language, statusList));
                    }
                }
            }
            if (!taskOwnList.isEmpty()) {
                if (statusList.isEmpty()) {
                    for (String userId : taskOwnList) {
                        cmds.add(new GetTasksOwnedCommand(userId, language));
                    }
                } else {
                    for (String userId : taskOwnList) {
                        cmds.add(new GetTasksOwnedCommand(userId, language, statusList));
                    }
                }
            }
        }
        while (!cmds.isEmpty()) {
            cmd = (Command)cmds.poll();
            List taskSummaryList = (List)this.internalDoTaskOperation(cmd, "Unable to execute " + cmd.getClass().getSimpleName());
            if (taskSummaryList != null && !taskSummaryList.isEmpty()) {
                for (TaskSummary taskSummary : taskSummaryList) {
                    TaskSummaryImpl taskSum = (TaskSummaryImpl)taskSummary;
                    if (!alreadyRetrievedSet.add(taskSum)) continue;
                    results.add(taskSum);
                }
            }
            if (results.size() < pageInfo[2]) continue;
            results = paginator.paginate(pageInfo, results);
            return new JaxbTaskSummaryListResponse(results);
        }
        results = paginator.paginate(pageInfo, results);
        return new JaxbTaskSummaryListResponse(results);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/{taskId: [0-9-]+}")
    public JaxbTask getTaskInstanceInfo(@PathParam(value="taskId") long taskId) {
        GetTaskCommand cmd = new GetTaskCommand(taskId);
        Task task = (Task)this.internalDoTaskOperation((Command<?>)cmd, "Unable to get task " + taskId);
        if (task == null) {
            throw new NotFoundException("Task " + taskId + " could not be found.");
        }
        return new JaxbTask(task);
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/{taskId: [0-9-]+}/{oper: [a-zA-Z]+}")
    public JaxbGenericResponse doTaskOperation(@PathParam(value="taskId") long taskId, @PathParam(value="oper") String operation) {
        Map<String, List<String>> params = TaskResource.getRequestParams(this.request);
        operation = TaskResource.checkThatOperationExists(operation, allowedOperations);
        String userId = this.identityProvider.getName();
        logger.debug("Executing " + operation + " on task " + taskId + " by user " + userId);
        GetTaskCommand cmd = null;
        cmd = new GetTaskCommand(taskId);
        if (this.internalDoTaskOperation((Command<?>)cmd, "Unable to check if task " + taskId + " exists") == null) {
            throw new NotFoundException("Task " + taskId + " could not be found.");
        }
        if ("activate".equalsIgnoreCase(operation)) {
            cmd = new ActivateTaskCommand(taskId, userId);
        } else if ("claim".equalsIgnoreCase(operation)) {
            cmd = new ClaimTaskCommand(taskId, userId);
        } else if ("claimnextavailable".equalsIgnoreCase(operation)) {
            String language = TaskResource.getStringParam("language", false, params, operation);
            if (language == null) {
                language = "en-UK";
            }
            cmd = new ClaimNextAvailableTaskCommand(userId, language);
        } else if ("complete".equalsIgnoreCase(operation)) {
            Map<String, Object> data = TaskResource.extractMapFromParams(params, operation);
            cmd = new CompleteTaskCommand(taskId, userId, data);
        } else if ("delegate".equalsIgnoreCase(operation)) {
            String targetEntityId = TaskResource.getStringParam("targetEntityId", true, params, operation);
            cmd = new DelegateTaskCommand(taskId, userId, targetEntityId);
        } else if ("exit".equalsIgnoreCase(operation)) {
            cmd = new ExitTaskCommand(taskId, userId);
        } else if ("fail".equalsIgnoreCase(operation)) {
            Map<String, Object> data = TaskResource.extractMapFromParams(params, operation);
            cmd = new FailTaskCommand(taskId, userId, data);
        } else if ("forward".equalsIgnoreCase(operation)) {
            String targetEntityId = TaskResource.getStringParam("targetEntityId", true, params, operation);
            cmd = new ForwardTaskCommand(taskId, userId, targetEntityId);
        } else if ("release".equalsIgnoreCase(operation)) {
            cmd = new ReleaseTaskCommand(taskId, userId);
        } else if ("resume".equalsIgnoreCase(operation)) {
            cmd = new ResumeTaskCommand(taskId, userId);
        } else if ("skip".equalsIgnoreCase(operation)) {
            cmd = new SkipTaskCommand(taskId, userId);
        } else if ("start".equalsIgnoreCase(operation)) {
            cmd = new StartTaskCommand(taskId, userId);
        } else if ("stop".equalsIgnoreCase(operation)) {
            cmd = new StopTaskCommand(taskId, userId);
        } else if ("suspend".equalsIgnoreCase(operation)) {
            cmd = new SuspendTaskCommand(taskId, userId);
        } else if ("nominate".equalsIgnoreCase(operation)) {
            List<OrganizationalEntity> potentialOwners = TaskResource.getOrganizationalEntityListFromParams(params);
            cmd = new NominateTaskCommand(taskId, userId, potentialOwners);
        } else {
            throw new BadRequestException("Unsupported operation: /task/" + taskId + "/" + operation);
        }
        this.internalDoTaskOperation((Command<?>)cmd, "Unable to " + operation + " task " + taskId);
        return new JaxbGenericResponse(this.request);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/{taskId: [0-9-]+}/content")
    public JaxbContent getTaskContent(@PathParam(value="taskId") long taskId) {
        GetTaskCommand cmd = new GetTaskCommand(taskId);
        Object result = this.internalDoTaskOperation((Command<?>)cmd, "Unable to get task " + taskId);
        if (result == null) {
            throw new NotFoundException("Task " + taskId + " could not be found.");
        }
        long contentId = ((Task)result).getTaskData().getDocumentContentId();
        Content content = null;
        if (contentId > -1L) {
            cmd = new GetContentCommand(contentId);
            result = this.internalDoTaskOperation((Command<?>)cmd, "Unable get content " + contentId + " (from task " + taskId + ")");
            content = (Content)result;
        }
        return new JaxbContent(content);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/content/{contentId: [0-9-]+}")
    public JaxbContent getContent(@PathParam(value="contentId") long contentId) {
        GetContentCommand cmd = new GetContentCommand(contentId);
        Content content = (Content)this.internalDoTaskOperation((Command<?>)cmd, "Unable to get task content " + contentId);
        if (content == null) {
            throw new NotFoundException("Content " + contentId + " could not be found.");
        }
        return new JaxbContent(content);
    }

    private Object internalDoTaskOperation(Command<?> cmd, String errorMsg) {
        Object result = this.processRequestBean.doTaskOperation(cmd);
        if (result instanceof JaxbExceptionResponse) {
            Exception cause = ((JaxbExceptionResponse)result).getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new InternalServerErrorException(errorMsg, (Throwable)cause);
        }
        return result;
    }
}

