/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.jms;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.bind.JAXBException;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.services.client.api.command.AcceptedCommands;
import org.kie.services.client.serialization.jaxb.JaxbSerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbExceptionResponse;
import org.kie.services.remote.cdi.RuntimeManagerManager;
import org.kie.services.remote.exception.DomainNotFoundBadRequestException;
import org.kie.services.remote.exception.KieRemoteServicesInternalError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMessageBean
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(RequestMessageBean.class);
    @Resource(mappedName="java:/ConnectionFactory")
    private ConnectionFactory connectionFactory;
    private String RESPONSE_QUEUE_NAME = null;
    private static String RESPONSE_QUEUE_NAME_PROPERTY = "kie.services.jms.queues.response";
    @Inject
    private RuntimeManagerManager runtimeMgrMgr;
    @Inject
    private TaskService taskService;

    @PostConstruct
    public void init() {
        this.RESPONSE_QUEUE_NAME = System.getProperty(RESPONSE_QUEUE_NAME_PROPERTY, "queue/KIE.RESPONSE.ALL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void onMessage(Message message) {
        Session session;
        Connection connection;
        JaxbCommandsResponse jaxbResponse;
        int[] serializationTypeHolder;
        String msgCorrId;
        boolean failure;
        block35: {
            JaxbCommandsRequest cmdsRequest;
            failure = false;
            msgCorrId = null;
            try {
                msgCorrId = message.getJMSCorrelationID();
            }
            catch (JMSException jmse) {
                logger.warn("Unable to retrieve JMS correlation id from message! This id is needed to be able to match a request to a response message.", (Throwable)jmse);
            }
            if (msgCorrId == null) {
                logger.warn("JMS correlation id is empty! This id is needed to be able to match a request to a response message.");
            }
            if ((cmdsRequest = this.deserializeRequest(message, msgCorrId, serializationTypeHolder = new int[1])) == null) {
                logger.error("Stopping processing of request message due to errors: see above.");
                return;
            }
            jaxbResponse = this.processJaxbCommandsRequest(cmdsRequest);
            connection = null;
            session = null;
            try {
                connection = this.connectionFactory.createConnection();
                connection.start();
                session = connection.createSession(false, 1);
            }
            catch (JMSException jmse) {
                logger.error("Unable to open new session to send response message to message " + msgCorrId, (Throwable)jmse);
                failure = true;
            }
            finally {
                if (!failure) break block35;
                if (connection != null) {
                    try {
                        connection.close();
                        connection = null;
                        session.close();
                        session = null;
                    }
                    catch (JMSException jmse) {
                        logger.warn("Unable to close connection or session after failing to create connection or session.", (Throwable)jmse);
                    }
                }
                return;
            }
        }
        Message msg = this.serializeResponse(session, msgCorrId, serializationTypeHolder[0], jaxbResponse);
        try {
            msg.setJMSCorrelationID(msgCorrId);
        }
        catch (JMSException jmse) {
            logger.warn("Unable to set correlation id of response to msg id " + msgCorrId, (Throwable)jmse);
        }
        if (!failure) {
            try {
                InitialContext context = new InitialContext();
                Queue responseQueue = (Queue)context.lookup(this.RESPONSE_QUEUE_NAME);
                MessageProducer producer = session.createProducer((Destination)responseQueue);
                producer.send(msg);
            }
            catch (NamingException ne) {
                logger.error("Unable to lookup response queue (" + this.RESPONSE_QUEUE_NAME + ") to send msg " + msgCorrId + " (Is " + RESPONSE_QUEUE_NAME_PROPERTY + " incorrect?).", (Throwable)ne);
            }
            catch (JMSException jmse) {
                logger.error("Unable to send msg " + msgCorrId + " to " + this.RESPONSE_QUEUE_NAME, (Throwable)jmse);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                        connection = null;
                        session.close();
                        session = null;
                    }
                    catch (JMSException jmse) {
                        logger.error("Unable to close connection or session.", (Throwable)jmse);
                    }
                }
            }
        }
    }

    private JaxbCommandsRequest deserializeRequest(Message message, String msgId, int[] serializationTypeHolder) {
        JaxbCommandsRequest cmdMsg = null;
        try {
            serializationTypeHolder[0] = message.getIntProperty("serialization");
            if (serializationTypeHolder[0] != 1) {
                throw new KieRemoteServicesInternalError("Unknown serialization type when deserializing message " + msgId + ":" + serializationTypeHolder[0]);
            }
            String msgStrContent = ((BytesMessage)message).readUTF();
            cmdMsg = (JaxbCommandsRequest)JaxbSerializationProvider.convertStringToJaxbObject((String)msgStrContent);
        }
        catch (JMSException jmse) {
            logger.error("Unable to read information from message " + msgId + ".", (Throwable)jmse);
        }
        catch (JAXBException jaxbe) {
            throw new KieRemoteServicesInternalError("Unable to convert String to " + JaxbCommandsRequest.class.getSimpleName() + " [msg id: " + msgId + "].", jaxbe);
        }
        return cmdMsg;
    }

    private Message serializeResponse(Session session, String msgId, int serializationType, JaxbCommandsResponse jaxbResponse) {
        BytesMessage byteMsg = null;
        try {
            byteMsg = session.createBytesMessage();
            byteMsg.setIntProperty("serialization", serializationType);
            if (serializationType != 1) {
                throw new KieRemoteServicesInternalError("Unknown serialization type when deserializing message " + msgId + ":" + serializationType);
            }
            String xmlStr = JaxbSerializationProvider.convertJaxbObjectToString((Object)jaxbResponse);
            byteMsg.writeUTF(xmlStr);
        }
        catch (JMSException jmse) {
            logger.error("Unable to create response message or write to it [msg id: " + msgId + "].", (Throwable)jmse);
        }
        catch (JAXBException jaxbe) {
            throw new KieRemoteServicesInternalError("Unable to serialize " + jaxbResponse.getClass().getSimpleName() + " to a String.", jaxbe);
        }
        return byteMsg;
    }

    public JaxbCommandsResponse processJaxbCommandsRequest(JaxbCommandsRequest request) {
        JaxbCommandsResponse jaxbResponse = new JaxbCommandsResponse(request);
        List commands = request.getCommands();
        if (commands != null) {
            for (int i = 0; i < commands.size(); ++i) {
                Command cmd = (Command)commands.get(i);
                if (!AcceptedCommands.getSet().contains(cmd.getClass())) {
                    UnsupportedOperationException uoe = new UnsupportedOperationException(cmd.getClass().getName() + " is not a supported command.");
                    jaxbResponse.addException((Exception)uoe, i, cmd);
                    continue;
                }
                Object cmdResult = null;
                cmdResult = cmd instanceof TaskCommand ? this.internalDoTaskOperation(cmd, jaxbResponse, i) : this.internalDoKieSessionOperation(cmd, request, jaxbResponse, i);
                if (cmdResult == null) continue;
                try {
                    jaxbResponse.addResult(cmdResult, i, cmd);
                    continue;
                }
                catch (Exception e) {
                    logger.error("Unable to add result from " + cmd.getClass().getSimpleName() + "/" + i + " because of " + e.getClass().getSimpleName(), (Throwable)e);
                    jaxbResponse.addException(e, i, cmd);
                }
            }
        }
        if (commands == null || commands.isEmpty()) {
            logger.info("Commands request object with no commands sent!");
        }
        return jaxbResponse;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public Object internalDoTaskOperation(Command<?> cmd, JaxbCommandsResponse jaxbResponse, int i) {
        Object cmdResult;
        try {
            cmdResult = this.doTaskOperation(cmd);
        }
        catch (UnauthorizedException ue) {
            Throwable cause = ue.getCause();
            if (cause instanceof PermissionDeniedException) {
                PermissionDeniedException pde = (PermissionDeniedException)cause;
                logger.warn(pde.getMessage());
                jaxbResponse.addException((Exception)((Object)pde), i, cmd);
                return null;
            }
            throw ue;
        }
        return cmdResult;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public Object internalDoKieSessionOperation(Command<?> cmd, JaxbCommandsRequest request, JaxbCommandsResponse jaxbResponse, int i) {
        Object cmdResult;
        try {
            cmdResult = this.doKieSessionOperation(cmd, request.getDeploymentId(), request.getProcessInstanceId());
        }
        catch (DomainNotFoundBadRequestException dnfbre) {
            logger.warn(dnfbre.getMessage());
            jaxbResponse.addException((Exception)((Object)dnfbre), i, cmd);
            return null;
        }
        return cmdResult;
    }

    private Object doKieSessionOperation(Command<?> cmd, String deploymentId, Long processInstanceId) {
        Object result = null;
        try {
            KieSession kieSession = this.getRuntimeEngine(deploymentId, processInstanceId).getKieSession();
            result = kieSession.execute(cmd);
        }
        catch (Exception e) {
            JaxbExceptionResponse exceptResp = new JaxbExceptionResponse(e, cmd);
            logger.warn("Unable to execute " + exceptResp.getCommandName() + " because of " + e.getClass().getSimpleName() + ": " + e.getMessage());
            logger.trace("Stack trace: \n", (Throwable)e);
            result = exceptResp;
        }
        return result;
    }

    private Object doTaskOperation(Command<?> cmd) {
        Object result = null;
        try {
            result = ((InternalTaskService)this.taskService).execute(cmd);
        }
        catch (PermissionDeniedException pde) {
            throw new UnauthorizedException(pde.getMessage(), (Throwable)pde);
        }
        catch (Exception e) {
            JaxbExceptionResponse exceptResp = new JaxbExceptionResponse(e, cmd);
            logger.warn("Unable to execute " + exceptResp.getCommandName() + " because of " + e.getClass().getSimpleName() + ": " + e.getMessage());
            logger.trace("Stack trace: \n", (Throwable)e);
            result = exceptResp;
        }
        return result;
    }

    protected RuntimeEngine getRuntimeEngine(String domainName, Long processInstanceId) {
        RuntimeManager runtimeManager = this.runtimeMgrMgr.getRuntimeManager(domainName);
        Object runtimeContext = processInstanceId != null ? new ProcessInstanceIdContext(processInstanceId) : EmptyContext.get();
        if (runtimeManager == null) {
            throw new DomainNotFoundBadRequestException("No runtime manager could be found for domain '" + domainName + "'.");
        }
        return runtimeManager.getRuntimeEngine(runtimeContext);
    }
}

