/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.persistence.SingleSessionCommandService;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.jboss.seam.transaction.DefaultTransaction;
import org.jboss.seam.transaction.SeamTransaction;
import org.jboss.solder.exception.control.ExceptionToCatch;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.services.remote.cdi.RuntimeManagerManager;
import org.kie.services.remote.exception.DomainNotFoundBadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class RestProcessRequestBean {
    private static final Logger logger = LoggerFactory.getLogger(RestProcessRequestBean.class);
    @Inject
    private RuntimeManagerManager runtimeMgrMgr;
    @Inject
    private TaskService taskService;
    @Inject
    @DefaultTransaction
    private SeamTransaction tx;
    @Inject
    Event<ExceptionToCatch> txExceptionEvent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doKieSessionOperation(Command<?> cmd, String deploymentId, Long processInstanceId, String errorMsg, boolean commit, boolean restartTx) {
        Object result = null;
        try {
            SingleSessionCommandService sscs;
            RuntimeEngine runtimeEngine = this.getRuntimeEngine(deploymentId, processInstanceId);
            KieSession kieSession = runtimeEngine.getKieSession();
            SingleSessionCommandService singleSessionCommandService = sscs = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)kieSession).getCommandService();
            synchronized (singleSessionCommandService) {
                try {
                    result = kieSession.execute(cmd);
                }
                finally {
                    if (commit) {
                        RestProcessRequestBean.commit(this.tx, this.txExceptionEvent, logger);
                    }
                    if (restartTx) {
                        RestProcessRequestBean.start(this.tx, this.txExceptionEvent, logger);
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new InternalServerErrorException(errorMsg, (Throwable)e);
        }
        return result;
    }

    public Object doKieSessionOperation(Command<?> cmd, String deploymentId, Long processInstanceId, String errorMsg) {
        return this.doKieSessionOperation(cmd, deploymentId, processInstanceId, errorMsg, true);
    }

    public Object doKieSessionOperation(Command<?> cmd, String deploymentId, Long processInstanceId, String errorMsg, boolean commit) {
        return this.doKieSessionOperation(cmd, deploymentId, processInstanceId, errorMsg, commit, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTaskOperationOnDeployment(TaskCommand<?> cmd, String errorMsg, String deploymentId, boolean restartTx) {
        Object result;
        block13: {
            result = null;
            try {
                if (deploymentId != null) {
                    SingleSessionCommandService sscs;
                    RuntimeEngine runtimeEngine = this.getRuntimeEngine(deploymentId, null);
                    KieSession kieSession = runtimeEngine.getKieSession();
                    SingleSessionCommandService singleSessionCommandService = sscs = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)kieSession).getCommandService();
                    synchronized (singleSessionCommandService) {
                        try {
                            ((InternalTaskService)this.taskService).execute(cmd);
                        }
                        finally {
                            RestProcessRequestBean.commit(this.tx, this.txExceptionEvent, logger);
                            if (restartTx) {
                                RestProcessRequestBean.start(this.tx, this.txExceptionEvent, logger);
                            }
                        }
                        break block13;
                    }
                }
                result = ((InternalTaskService)this.taskService).execute(cmd);
            }
            catch (PermissionDeniedException pde) {
                throw new UnauthorizedException(pde.getMessage(), (Throwable)pde);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new InternalServerErrorException(errorMsg, (Throwable)e);
            }
        }
        return result;
    }

    public Object doTaskOperationOnDeployment(TaskCommand<?> cmd, String errorMsg, String deploymentId) {
        return this.doTaskOperationOnDeployment(cmd, errorMsg, deploymentId, false);
    }

    public Object doTaskOperation(TaskCommand<?> cmd, String errorMsg) {
        return this.doTaskOperationOnDeployment(cmd, errorMsg, null);
    }

    private RuntimeEngine getRuntimeEngine(String deploymentId, Long processInstanceId) {
        RuntimeManager runtimeManager = this.runtimeMgrMgr.getRuntimeManager(deploymentId);
        Object runtimeContext = processInstanceId != null ? new ProcessInstanceIdContext(processInstanceId) : EmptyContext.get();
        if (runtimeManager == null) {
            throw new DomainNotFoundBadRequestException("No runtime manager could be found for deployment '" + deploymentId + "'.");
        }
        return runtimeManager.getRuntimeEngine(runtimeContext);
    }

    private static void commit(SeamTransaction tx, Event<ExceptionToCatch> txExceptionEvent, Logger logger) {
        try {
            switch (tx.getStatus()) {
                case 0: {
                    tx.commit();
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    tx.rollback();
                    break;
                }
            }
        }
        catch (SystemException se) {
            logger.warn("Error commiting/rolling back the transaction", (Throwable)se);
            txExceptionEvent.fire((Object)new ExceptionToCatch((Throwable)se));
        }
        catch (HeuristicRollbackException hre) {
            logger.warn("Error committing the transaction", (Throwable)hre);
            txExceptionEvent.fire((Object)new ExceptionToCatch((Throwable)hre));
        }
        catch (RollbackException re) {
            logger.warn("Error committing the transaction", (Throwable)re);
            txExceptionEvent.fire((Object)new ExceptionToCatch((Throwable)re));
        }
        catch (HeuristicMixedException hme) {
            logger.warn("Error committing the transaction", (Throwable)hme);
            txExceptionEvent.fire((Object)new ExceptionToCatch((Throwable)hme));
        }
    }

    private static void start(SeamTransaction tx, Event<ExceptionToCatch> txExceptionEvent, Logger logger) {
        try {
            if (tx.getStatus() == 0) {
                logger.warn("Transaction was already started before the listener");
            } else {
                logger.debug("Beginning transaction");
                tx.begin();
            }
        }
        catch (SystemException se) {
            logger.warn("Error starting the transaction, or checking status", (Throwable)se);
            txExceptionEvent.fire((Object)new ExceptionToCatch((Throwable)se));
        }
        catch (NotSupportedException e) {
            logger.warn("Error starting the transaction", (Throwable)e);
            txExceptionEvent.fire((Object)new ExceptionToCatch((Throwable)e));
        }
    }
}

