/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.drools.core.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.GetWorkItemCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.process.instance.WorkItem;
import org.jboss.resteasy.spi.BadRequestException;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.command.ClearHistoryLogsCommand;
import org.jbpm.process.audit.command.FindNodeInstancesCommand;
import org.jbpm.process.audit.command.FindProcessInstanceCommand;
import org.jbpm.process.audit.command.FindProcessInstancesCommand;
import org.jbpm.process.audit.command.FindSubProcessInstancesCommand;
import org.jbpm.process.audit.command.FindVariableInstancesCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbHistoryLogList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceWithVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbWorkItem;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.kie.services.remote.exception.KieRemoteServicesPreConditionException;
import org.kie.services.remote.rest.ResourceBase;
import org.kie.services.remote.rest.RestProcessRequestBean;
import org.kie.services.remote.util.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/runtime/{id: [a-zA-Z0-9-:\\.]+}")
@RequestScoped
public class RuntimeResource
extends ResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeResource.class);
    @Context
    private HttpServletRequest request;
    @Context
    private Request restRequest;
    @Inject
    private RestProcessRequestBean processRequestBean;
    @PathParam(value="id")
    private String deploymentId;

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="/execute")
    public JaxbCommandsResponse execute(JaxbCommandsRequest cmdsRequest) {
        return RuntimeResource.restProcessJaxbCommandsRequest(cmdsRequest, this.processRequestBean);
    }

    @POST
    @Path(value="/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/start")
    public Response startNewProcess(@PathParam(value="processDefId") String processId) {
        Map<String, List<String>> formParams = RuntimeResource.getRequestParams(this.request);
        Map<String, Object> params = RuntimeResource.extractMapFromParams(formParams, "process/" + processId + "/start");
        StartProcessCommand cmd = new StartProcessCommand(processId, params);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, (Long)RuntimeResource.getNumberParam("processInstanceId", false, formParams, "process/" + processId + "/start", true), "Unable to start process with process definition id '" + processId + "'", true);
        JaxbProcessInstanceResponse responseObj = new JaxbProcessInstanceResponse((ProcessInstance)result, this.request);
        return RuntimeResource.createCorrectVariant(responseObj, this.restRequest);
    }

    @GET
    @Path(value="/process/instance/{procInstId: [0-9]+}")
    public Response getProcessInstanceDetails(@PathParam(value="procInstId") Long procInstId) {
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand(procInstId);
        cmd.setReadOnly(true);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, "Unable to get process instance " + procInstId, true);
        JaxbProcessInstanceResponse responseObj = null;
        if (result != null) {
            responseObj = new JaxbProcessInstanceResponse((ProcessInstance)result);
            return RuntimeResource.createCorrectVariant(responseObj, this.restRequest);
        }
        throw new BadRequestException("Unable to retrieve process instance " + procInstId + " which may have been completed. Please see the history operations.");
    }

    @POST
    @Path(value="/process/instance/{procInstId: [0-9]+}/abort")
    public Response abortProcessInstance(@PathParam(value="procInstId") Long procInstId) {
        AbortProcessInstanceCommand cmd = new AbortProcessInstanceCommand();
        cmd.setProcessInstanceId(procInstId);
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, "Unable to abort process instance " + procInstId, true);
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.request), this.restRequest);
    }

    @POST
    @Path(value="/process/instance/{procInstId: [0-9]+}/signal")
    public Response signalProcessInstance(@PathParam(value="procInstId") Long procInstId) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String eventType = RuntimeResource.getStringParam("signal", true, params, "signal");
        Object event = RuntimeResource.getObjectParam("event", false, params, "signal");
        SignalEventCommand cmd = new SignalEventCommand(procInstId.longValue(), eventType, event);
        String errorMsg = "Unable to signal process instance";
        errorMsg = eventType == null ? errorMsg + " with empty signal" : errorMsg + " with signal type '" + eventType + "'";
        if (event != null) {
            errorMsg = errorMsg + " and event '" + event + "'";
        }
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, errorMsg, true);
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.request), this.restRequest);
    }

    @GET
    @Path(value="/process/instance/{procInstId: [0-9]+}/variables")
    public Response getProcessInstanceVariables(@PathParam(value="procInstId") Long procInstId) {
        Map<String, String> vars = this.getVariables(procInstId, true);
        return RuntimeResource.createCorrectVariant(new JaxbVariablesResponse(vars, this.request), this.restRequest);
    }

    @POST
    @Path(value="/signal")
    public Response signalEvent() {
        Map<String, List<String>> formParams = RuntimeResource.getRequestParams(this.request);
        String eventType = RuntimeResource.getStringParam("signal", true, formParams, "signal");
        Object event = RuntimeResource.getObjectParam("event", false, formParams, "signal");
        String errorMsg = "Unable to send signal '" + eventType + "'";
        if (event != null) {
            errorMsg = errorMsg + " with event '" + event + "'";
        }
        this.processRequestBean.doKieSessionOperation((Command<?>)new SignalEventCommand(eventType, event), this.deploymentId, (Long)RuntimeResource.getNumberParam("processInstanceId", false, formParams, "signal", true), errorMsg, true);
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.request), this.restRequest);
    }

    @GET
    @Path(value="/workitem/{workItemId: [0-9-]+}")
    public Response getWorkItem(@PathParam(value="workItemId") Long workItemId) {
        WorkItem workItem = (WorkItem)this.processRequestBean.doKieSessionOperation((Command<?>)new GetWorkItemCommand(workItemId.longValue()), this.deploymentId, (Long)RuntimeResource.getNumberParam("processInstanceId", false, RuntimeResource.getRequestParams(this.request), "workitem/" + workItemId, true), "Unable to get work item " + workItemId, true);
        return RuntimeResource.createCorrectVariant(new JaxbWorkItem((org.kie.api.runtime.process.WorkItem)workItem), this.restRequest);
    }

    @POST
    @Path(value="/workitem/{workItemId: [0-9-]+}/{oper: [a-zA-Z]+}")
    public Response doWorkItemOperation(@PathParam(value="workItemId") Long workItemId, @PathParam(value="oper") String operation) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        CompleteWorkItemCommand cmd = null;
        if ("complete".equalsIgnoreCase(operation.trim())) {
            Map<String, Object> results = RuntimeResource.extractMapFromParams(params, operation);
            cmd = new CompleteWorkItemCommand(workItemId.longValue(), results);
        } else if ("abort".equalsIgnoreCase(operation.toLowerCase())) {
            cmd = new AbortWorkItemCommand(workItemId.longValue());
        } else {
            throw new BadRequestException("Unsupported operation: /process/instance/" + workItemId + "/" + operation);
        }
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, (Long)RuntimeResource.getNumberParam("processInstanceId", false, params, "workitem/" + workItemId + "/" + operation, true), "Unable to " + operation + " work item " + workItemId, true);
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.request), this.restRequest);
    }

    @POST
    @Path(value="/history/clear")
    public Response clearProcessInstanceLogs() {
        this.processRequestBean.doKieSessionOperation((Command<?>)new ClearHistoryLogsCommand(), this.deploymentId, (Long)RuntimeResource.getNumberParam("processInstanceId", false, RuntimeResource.getRequestParams(this.request), "history/clear", true), "Unable to clear process instance logs", true);
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.request), this.restRequest);
    }

    @GET
    @Path(value="/history/instance")
    public Response getProcessInstanceLogs() {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)new FindProcessInstancesCommand(), this.deploymentId, (Long)RuntimeResource.getNumberParam("processInstanceId", false, params, "history/clear", true), "Unable to get process instance logs", true);
        List results = (List)result;
        results = new Paginator().paginate(pageInfo, results);
        return RuntimeResource.createCorrectVariant(new JaxbHistoryLogList(results), this.restRequest);
    }

    @GET
    @Path(value="/history/instance/{procInstId: [0-9]+}")
    public Response getSpecificProcessInstanceLogs(@PathParam(value="procInstId") long procInstId) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)new FindProcessInstanceCommand(procInstId), this.deploymentId, procInstId, "Unable to get process instance logs for process instance " + procInstId, true);
        ProcessInstanceLog procInstLog = (ProcessInstanceLog)result;
        List<Object> logList = new ArrayList<ProcessInstanceLog>();
        logList.add(procInstLog);
        logList = new Paginator<ProcessInstanceLog>().paginate(pageInfo, logList);
        return RuntimeResource.createCorrectVariant(new JaxbHistoryLogList(logList), this.restRequest);
    }

    @GET
    @Path(value="/history/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}")
    public Response getVariableOrNodeHistoryList(@PathParam(value="procInstId") Long procInstId, @PathParam(value="oper") String operation) {
        String errorMsg;
        FindSubProcessInstancesCommand cmd;
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params);
        if ("child".equalsIgnoreCase(operation)) {
            cmd = new FindSubProcessInstancesCommand(procInstId.longValue());
            errorMsg = "Unable to get child process instance logs for process instance " + procInstId;
        } else if ("node".equalsIgnoreCase(operation)) {
            cmd = new FindNodeInstancesCommand(procInstId.longValue());
            errorMsg = "Unable to get node instance logs for process instance " + procInstId;
        } else if ("variable".equalsIgnoreCase(operation)) {
            cmd = new FindVariableInstancesCommand(procInstId.longValue());
            errorMsg = "Unable to get variable instance logs for process instance " + procInstId;
        } else {
            throw new BadRequestException("Unsupported operation: /history/instance/" + procInstId + "/" + operation);
        }
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, errorMsg, true);
        List varInstLogList = (List)result;
        varInstLogList = new Paginator().paginate(pageInfo, varInstLogList);
        JaxbHistoryLogList resultList = new JaxbHistoryLogList(varInstLogList);
        return RuntimeResource.createCorrectVariant(resultList, this.restRequest);
    }

    @GET
    @Path(value="/history/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}/{logId: [a-zA-Z0-9-:\\.]+}")
    public Response getSpecificVariableOrNodeHistoryList(@PathParam(value="procInstId") Long procInstId, @PathParam(value="oper") String operation, @PathParam(value="logId") String logId) {
        String errorMsg;
        FindNodeInstancesCommand cmd;
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params);
        if ("node".equalsIgnoreCase(operation)) {
            cmd = new FindNodeInstancesCommand(procInstId.longValue(), logId);
            errorMsg = "Unable to get node instance logs for node '" + logId + "' in process instance " + procInstId;
        } else if ("variable".equalsIgnoreCase(operation)) {
            cmd = new FindVariableInstancesCommand(procInstId.longValue(), logId);
            errorMsg = "Unable to get variable instance logs for variable '" + logId + "' in process instance " + procInstId;
        } else {
            throw new BadRequestException("Unsupported operation: /history/instance/" + procInstId + "/" + operation + "/" + logId);
        }
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, errorMsg, true);
        List varInstLogList = (List)result;
        varInstLogList = new Paginator().paginate(pageInfo, varInstLogList);
        JaxbHistoryLogList resultList = new JaxbHistoryLogList(varInstLogList);
        return RuntimeResource.createCorrectVariant(resultList, this.restRequest);
    }

    @GET
    @Path(value="/history/process/{procId: [a-zA-Z0-9-:\\.]+}")
    public Response getProcessInstanceLogs(@PathParam(value="procId") String processId) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        int[] pageInfo = RuntimeResource.getPageNumAndPageSize(params);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)new FindProcessInstancesCommand(processId), this.deploymentId, (Long)RuntimeResource.getNumberParam("processInstanceId", false, params, "history/process/" + processId, true), "Unable to get process instance logs for process '" + processId + "'", true);
        List procInstLogList = (List)result;
        procInstLogList = new Paginator().paginate(pageInfo, procInstLogList);
        return RuntimeResource.createCorrectVariant(new JaxbHistoryLogList(procInstLogList), this.restRequest);
    }

    @POST
    @Path(value="/withvars/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/start")
    public Response startNewProcessWithVars(@PathParam(value="processDefId") String processId) {
        Map<String, List<String>> formParams = RuntimeResource.getRequestParams(this.request);
        Map<String, Object> params = RuntimeResource.extractMapFromParams(formParams, "process/" + processId + "/start");
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)new StartProcessCommand(processId, params), this.deploymentId, (Long)RuntimeResource.getNumberParam("processInstanceId", false, formParams, "withvars/process/" + processId + "/start", true), "Unable to get process instance logs for process '" + processId + "'", false);
        ProcessInstance procInst = (ProcessInstance)result;
        Map<String, String> vars = this.getVariables(procInst.getId(), true);
        JaxbProcessInstanceWithVariablesResponse resp = new JaxbProcessInstanceWithVariablesResponse(procInst, vars, this.request);
        return RuntimeResource.createCorrectVariant(resp, this.restRequest);
    }

    @GET
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}")
    public Response getProcessInstanceWithVars(@PathParam(value="procInstId") Long procInstId) {
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand(procInstId);
        cmd.setReadOnly(true);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, "Unable to get process instance " + procInstId, false);
        JaxbProcessInstanceWithVariablesResponse responseObj = null;
        if (result == null) {
            throw new BadRequestException("Unable to retrieve process instance " + procInstId + " since it has been completed. Please see the history operations.");
        }
        ProcessInstance procInst = (ProcessInstance)result;
        Map<String, String> vars = this.getVariables(procInstId, true);
        responseObj = new JaxbProcessInstanceWithVariablesResponse(procInst, vars, this.request);
        return RuntimeResource.createCorrectVariant(responseObj, this.restRequest);
    }

    @POST
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}/signal")
    public Response signalProcessInstanceWithVars(@PathParam(value="procInstId") Long procInstId) {
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.request);
        String eventType = RuntimeResource.getStringParam("eventType", true, params, "signal");
        Object event = RuntimeResource.getObjectParam("event", false, params, "signal");
        String errorMsg = "Unable to signal process instance " + procInstId;
        errorMsg = eventType == null ? errorMsg + " with empty signal" : errorMsg + " with signal type '" + eventType + "'";
        if (event != null) {
            errorMsg = errorMsg + " and event '" + event + "'";
        }
        this.processRequestBean.doKieSessionOperation((Command<?>)new SignalEventCommand(procInstId.longValue(), eventType, event), this.deploymentId, procInstId, errorMsg, false);
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand(procInstId);
        cmd.setReadOnly(true);
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId, "Unable to get process instance " + procInstId, false);
        ProcessInstance processInstance = (ProcessInstance)result;
        if (processInstance == null) {
            throw new KieRemoteServicesPreConditionException("This method can only be used on processes that will not complete after a signal.");
        }
        Map<String, String> vars = this.getVariables(processInstance.getId(), true);
        return RuntimeResource.createCorrectVariant(new JaxbProcessInstanceWithVariablesResponse(processInstance, vars), this.restRequest);
    }

    private Map<String, String> getVariables(long processInstanceId, boolean lastOperation) {
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)new FindVariableInstancesCommand(processInstanceId), this.deploymentId, processInstanceId, "Unable to retrieve process variables from process instance " + processInstanceId, lastOperation);
        List varInstLogList = (List)result;
        HashMap<String, String> vars = new HashMap<String, String>();
        if (varInstLogList.isEmpty()) {
            return vars;
        }
        HashMap<String, VariableInstanceLog> varLogMap = new HashMap<String, VariableInstanceLog>();
        for (VariableInstanceLog variableInstanceLog : varInstLogList) {
            String varId = variableInstanceLog.getVariableId();
            VariableInstanceLog prevVarLog = varLogMap.put(varId, variableInstanceLog);
            if (prevVarLog == null || !prevVarLog.getDate().after(variableInstanceLog.getDate())) continue;
            varLogMap.put(varId, prevVarLog);
        }
        for (Map.Entry entry : varLogMap.entrySet()) {
            vars.put((String)entry.getKey(), ((VariableInstanceLog)entry.getValue()).getValue());
        }
        return vars;
    }
}

