/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.regex.Pattern;
import javax.ws.rs.Path;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.deployment.DeploymentUnit;
import org.kie.services.remote.rest.DeploymentResource;
import org.kie.services.remote.rest.RuntimeResource;

public class DeploymentIdTest
extends DeploymentResource {
    @Test
    public void sameRegexUsedEverywhereTest() {
        Path pathAnno = RuntimeResource.class.getAnnotation(Path.class);
        String path = pathAnno.value();
        path = path.replace("/runtime/{deploymentId: ", "");
        String runRegex = path.substring(0, path.length() - 1);
        pathAnno = DeploymentResource.class.getAnnotation(Path.class);
        path = pathAnno.value();
        path = path.replace("/deployment/{deploymentId: ", "");
        String depRegex = path.substring(0, path.length() - 1);
        Assert.assertEquals((String)"DeploymentResource deploymentId regex does not match RuntimeResource's", (Object)depRegex, (Object)runRegex);
    }

    @Test
    public void deploymentIdRegexTest() {
        Path pathAnno = DeploymentResource.class.getAnnotation(Path.class);
        String path = pathAnno.value();
        path = path.replace("/deployment/{deploymentId: ", "");
        String regex = path.substring(0, path.length() - 1);
        String test = "a:b:c";
        Assert.assertTrue((String)test, (boolean)Pattern.matches(regex, test));
        test = "a:b:c:d";
        Assert.assertTrue((String)test, (boolean)Pattern.matches(regex, test));
        test = "g:a:v:kbase:ksess:";
        Assert.assertFalse((String)test, (boolean)Pattern.matches(regex, test));
        test = "g:a:v:kbase:ksess:a:";
        Assert.assertFalse((String)test, (boolean)Pattern.matches(regex, test));
        test = "g:a:v:kbase:kse ss";
        Assert.assertFalse((String)test, (boolean)Pattern.matches(regex, test));
        test = "g:a :v:kbase:kse ss";
        Assert.assertFalse((String)test, (boolean)Pattern.matches(regex, test));
        test = "g:a:v:kbase";
        Assert.assertTrue((String)test, (boolean)Pattern.matches(regex, test));
        test = "g:a:v:kbase:";
        Assert.assertTrue((String)test, (boolean)Pattern.matches(regex, test));
        test = "g:a:v::ksess";
        Assert.assertTrue((String)test, (boolean)Pattern.matches(regex, test));
        test = "g:a:v::";
        Assert.assertTrue((String)test, (boolean)Pattern.matches(regex, test));
        String all = "g:a:v:kbase:ksess";
        Assert.assertTrue((String)test, (boolean)Pattern.matches(regex, all));
        String[] groups = all.split(":");
        Assert.assertEquals((long)5L, (long)groups.length);
        test = "group.subgroup:artifact-id:1.0";
        Assert.assertTrue((String)test, (boolean)Pattern.matches(regex, test));
        test = "group.sub_group:artifact_id:1.0.0.Final";
        Assert.assertTrue((String)test, (boolean)Pattern.matches(regex, test));
        test = "group.subgroup:artifact-id:1.0";
        Assert.assertTrue((String)test, (boolean)Pattern.matches(regex, test));
        test = "group.sub_group:artifact_id:v1.0.0.Final";
        Assert.assertTrue((String)test, (boolean)Pattern.matches(regex, test));
        test = "::v:kbase";
        Assert.assertFalse((String)test, (boolean)Pattern.matches(regex, test));
        test = "::v";
        Assert.assertFalse((String)test, (boolean)Pattern.matches(regex, test));
        test = "$:#:v";
        Assert.assertFalse((String)test, (boolean)Pattern.matches(regex, test));
    }

    @Test
    public void parseDeploymentIdTest() {
        String[] test = new String[]{"a", "b", "c"};
        KModuleDeploymentUnit depUnit = this.createDeploymentUnit(this.join(test, ":"));
        this.checkDepUnit((DeploymentUnit)depUnit, test);
        test = new String[]{"g", "a", "v", "kbase", "ksess"};
        depUnit = this.createDeploymentUnit(this.join(test, ":"));
        this.checkDepUnit((DeploymentUnit)depUnit, test);
        test = new String[]{"g", "a", "v", "kbase"};
        depUnit = this.createDeploymentUnit(this.join(test, ":"));
        this.checkDepUnit((DeploymentUnit)depUnit, test);
        test = new String[]{"group.sub_group", "artifact_id", "1.0.0.Final"};
        depUnit = this.createDeploymentUnit(this.join(test, ":"));
        this.checkDepUnit((DeploymentUnit)depUnit, test);
    }

    private String join(String[] strArr, String sep) {
        StringBuilder builder = new StringBuilder();
        if (strArr.length > 0) {
            builder.append(strArr[0]);
            for (int i = 1; i < strArr.length; ++i) {
                builder.append(sep + strArr[i]);
            }
        }
        return builder.toString();
    }

    private void checkDepUnit(DeploymentUnit depUnit, String[] test) {
        String[] depUnitArr = depUnit.getIdentifier().split(":");
        Assert.assertEquals((String)"size/# components", (long)test.length, (long)depUnitArr.length);
        for (int i = 0; i < depUnitArr.length; ++i) {
            Assert.assertEquals((Object)test[i], (Object)depUnitArr[i]);
        }
    }
}

