/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.services.remote.rest.ResourceBase;

public class PaginatorTest
extends ResourceBase {
    @Test
    public void testPaginate() {
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (int i = 0; i < 100; ++i) {
            results.add(i);
        }
        String oper = "/test/paginate";
        HashMap params = new HashMap();
        int[] pageInfo = PaginatorTest.getPageNumAndPageSize(params, (String)oper);
        List pagedList = PaginatorTest.paginate((int[])pageInfo, results);
        Assert.assertEquals(results, (Object)pagedList);
        ArrayList<String> pageValues = new ArrayList<String>();
        pageValues.add("2");
        ArrayList<String> sizeValues = new ArrayList<String>();
        sizeValues.add("3");
        params.put("page", pageValues);
        params.put("pageSize", sizeValues);
        pageInfo = PaginatorTest.getPageNumAndPageSize(params, (String)oper);
        pagedList = PaginatorTest.paginate((int[])pageInfo, results);
        Assert.assertEquals((Object)new Integer(3), pagedList.get(0));
        Assert.assertEquals((long)3L, (long)pagedList.size());
        pageValues.clear();
        pageValues.add("4");
        sizeValues.clear();
        sizeValues.add("5");
        params.put("p", pageValues);
        params.put("s", sizeValues);
        pageInfo = PaginatorTest.getPageNumAndPageSize(params, (String)oper);
        pagedList = PaginatorTest.paginate((int[])pageInfo, results);
        Assert.assertEquals((Object)new Integer(15), pagedList.get(0));
        Assert.assertEquals((long)5L, (long)pagedList.size());
        pageInfo[PaginatorTest.PAGE_NUM] = 0;
        pagedList = PaginatorTest.paginate((int[])pageInfo, results);
        Assert.assertEquals((long)pagedList.size(), (long)results.size());
    }
}

