/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest.async;

import java.lang.reflect.Field;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.junit.Before;
import org.junit.BeforeClass;
import org.kie.internal.deployment.DeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.remote.rest.async.AsyncDeploymentJobExecutor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAsyncDeploymentJobExecutorTest {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractAsyncDeploymentJobExecutorTest.class);
    protected AsyncDeploymentJobExecutor asyncDeploymentJobExecutor = null;
    protected KModuleDeploymentService deploymentService = null;
    protected final Semaphore jobCompletionSemaphore = new Semaphore(0, true);
    protected Queue<String> submittedPendingJobsTrackerList = new ConcurrentLinkedQueue<String>();
    protected static final int testJobQueueSize = 3;
    protected static final int maxWaitTries = 5;

    @BeforeClass
    public static void beforeClass() throws Exception {
        try {
            Field queueSizePropField = AsyncDeploymentJobExecutor.class.getDeclaredField("MAX_JOB_QUEUE_SIZE_PROP");
            queueSizePropField.setAccessible(true);
            String propName = (String)queueSizePropField.get(null);
            System.setProperty(propName, String.valueOf(3));
        }
        catch (NoSuchFieldException nsfe) {
            Field queueSizeField = AsyncDeploymentJobExecutor.class.getDeclaredField("maxQueueSize");
            queueSizeField.setAccessible(true);
            queueSizeField.set(null, 3);
        }
    }

    @Before
    public void before() {
        this.asyncDeploymentJobExecutor = new AsyncDeploymentJobExecutor();
        this.deploymentService = (KModuleDeploymentService)Mockito.mock(KModuleDeploymentService.class);
        Answer<Void> semaphoreAnswer = new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                AbstractAsyncDeploymentJobExecutorTest.this.jobCompletionSemaphore.acquire();
                KModuleDeploymentUnit depUnit = (KModuleDeploymentUnit)invocation.getArguments()[0];
                String op = invocation.getMethod().getName();
                logger.debug("(Finished mock " + op + " of [" + depUnit.getIdentifier() + "])");
                String ver = depUnit.getVersion();
                AbstractAsyncDeploymentJobExecutorTest.this.submittedPendingJobsTrackerList.remove(ver);
                return null;
            }
        };
        ((KModuleDeploymentService)Mockito.doAnswer((Answer)semaphoreAnswer).when((Object)this.deploymentService)).deploy((DeploymentUnit)Matchers.any(DeploymentUnit.class));
        ((KModuleDeploymentService)Mockito.doAnswer((Answer)semaphoreAnswer).when((Object)this.deploymentService)).undeploy((DeploymentUnit)Matchers.any(DeploymentUnit.class));
    }

    protected JaxbDeploymentJobResult submitJob(KModuleDeploymentUnit depUnit) {
        this.submittedPendingJobsTrackerList.add(depUnit.getVersion().intern());
        return this.asyncDeploymentJobExecutor.submitJob(this.deploymentService, depUnit, AsyncDeploymentJobExecutor.JobType.DEPLOY);
    }

    protected KModuleDeploymentUnit createDeploymentUnit(String groupId, String artifactId, String version) {
        KModuleDeploymentUnit depUnit = new KModuleDeploymentUnit(groupId, artifactId, version);
        return depUnit;
    }

    protected class TestSubmitCallable
    implements Callable<JaxbDeploymentJobResult> {
        private final KModuleDeploymentUnit depUnit;

        public TestSubmitCallable(KModuleDeploymentUnit depUnit) {
            this.depUnit = depUnit;
        }

        @Override
        public JaxbDeploymentJobResult call() throws Exception {
            AbstractAsyncDeploymentJobExecutorTest.this.submittedPendingJobsTrackerList.add(this.depUnit.getVersion().intern());
            return AbstractAsyncDeploymentJobExecutorTest.this.asyncDeploymentJobExecutor.submitJob(AbstractAsyncDeploymentJobExecutorTest.this.deploymentService, this.depUnit, AsyncDeploymentJobExecutor.JobType.DEPLOY);
        }
    }

    protected class TestSemaphoreCallable
    implements Callable<Boolean> {
        public Semaphore jobSemaphore;
        private final int id;

        public TestSemaphoreCallable(int i, Semaphore newSemaphore) {
            this.jobSemaphore = AbstractAsyncDeploymentJobExecutorTest.this.jobCompletionSemaphore;
            this.id = i;
            if (newSemaphore != null) {
                this.jobSemaphore = newSemaphore;
            }
        }

        public TestSemaphoreCallable(int i) {
            this(i, null);
        }

        @Override
        public Boolean call() throws Exception {
            this.jobSemaphore.acquire();
            logger.debug(this.id + " completed");
            AbstractAsyncDeploymentJobExecutorTest.this.submittedPendingJobsTrackerList.remove(String.valueOf(this.id).intern());
            return true;
        }
    }
}

