/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest.async;

import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.services.remote.rest.async.AbstractAsyncDeploymentJobExecutorTest;

@RunWith(value=BMUnitRunner.class)
public class AsyncDeploymentJobExecutorInjectionTest
extends AbstractAsyncDeploymentJobExecutorTest {
    final ExecutorService executor = Executors.newCachedThreadPool();

    @Test
    @BMScript(value="cancel-job", dir="byteman")
    public void staggeredDuplicateSubmission() throws Exception {
        int i;
        LinkedList<KModuleDeploymentUnit> testDepUnits = new LinkedList<KModuleDeploymentUnit>();
        float verIndex = 1.0f;
        for (int i2 = 0; i2 < 3; ++i2) {
            float f = verIndex;
            verIndex = f + 1.0f;
            String ver = new Float(f).toString().intern();
            testDepUnits.add(this.createDeploymentUnit("org", "art", ver));
        }
        int submittedPendingJobs = 0;
        for (i = 0; i < 3; ++i) {
            KModuleDeploymentUnit depUnit = (KModuleDeploymentUnit)testDepUnits.poll();
            this.executor.submit(new AbstractAsyncDeploymentJobExecutorTest.TestSubmitCallable(this, depUnit));
            ++submittedPendingJobs;
        }
        for (i = 0; i < 3; ++i) {
            this.jobCompletionSemaphore.release();
            Thread.yield();
            --submittedPendingJobs;
        }
        int tries = 0;
        while (this.submittedPendingJobsTrackerList.size() > submittedPendingJobs && tries++ < 5) {
            logger.debug(this.submittedPendingJobsTrackerList.size() - submittedPendingJobs + " deployments more to process.");
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"Not enough jobs completed.", (long)submittedPendingJobs, (long)this.submittedPendingJobsTrackerList.size());
    }
}

