/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest.async;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Future;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.remote.rest.async.AbstractAsyncDeploymentJobExecutorTest;
import org.kie.services.remote.rest.async.AsyncDeploymentJobExecutor;

public class AsyncDeploymentJobExecutorTest
extends AbstractAsyncDeploymentJobExecutorTest {
    @After
    public void after() throws Exception {
        Thread.sleep(1000L);
    }

    private void addJob(int id, Map<String, Future<Boolean>> jobs) {
        AbstractAsyncDeploymentJobExecutorTest.TestSemaphoreCallable testCallable = new AbstractAsyncDeploymentJobExecutorTest.TestSemaphoreCallable(this, id);
        Future<Boolean> job = this.asyncDeploymentJobExecutor.executor.submit(testCallable);
        jobs.put(String.valueOf(id), job);
        this.submittedPendingJobsTrackerList.add(String.valueOf(id).intern());
    }

    @Test
    public void tooManyJobsTest() throws Exception {
        int i;
        Assert.assertEquals((String)"Job queue size has not been correctly set", (long)3L, (long)this.asyncDeploymentJobExecutor.getMaxJobQueueSize());
        LinkedList<KModuleDeploymentUnit> testDepUnits = new LinkedList<KModuleDeploymentUnit>();
        float verIndex = 1.0f;
        for (int i2 = 0; i2 < 9; ++i2) {
            float f = verIndex;
            verIndex = f + 1.0f;
            String ver = new Float(f).toString().intern();
            testDepUnits.add(this.createDeploymentUnit("org", "art", ver));
        }
        int submittedPendingJobs = 0;
        for (i = 0; i < 3; ++i) {
            this.submitJob((KModuleDeploymentUnit)testDepUnits.poll());
            ++submittedPendingJobs;
        }
        logger.debug(this.submittedPendingJobsTrackerList.size() + " deployments waiting in a queue of " + 3);
        this.jobCompletionSemaphore.release();
        --submittedPendingJobs;
        this.submitJob((KModuleDeploymentUnit)testDepUnits.poll());
        ++submittedPendingJobs;
        this.submitJob((KModuleDeploymentUnit)testDepUnits.poll());
        ++submittedPendingJobs;
        for (i = 0; i < 3; ++i) {
            this.jobCompletionSemaphore.release();
            Thread.yield();
            --submittedPendingJobs;
        }
        int tries = 0;
        while (this.submittedPendingJobsTrackerList.size() > submittedPendingJobs && tries++ < 5) {
            logger.debug(this.submittedPendingJobsTrackerList.size() - submittedPendingJobs + " deployments more to process.");
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"Not enough jobs completed.", (long)submittedPendingJobs, (long)this.submittedPendingJobsTrackerList.size());
    }

    @Test
    public void duplicateJobAfterJobIsCompletedTest() throws Exception {
        int i;
        LinkedList<KModuleDeploymentUnit> testDepUnits = new LinkedList<KModuleDeploymentUnit>();
        float verIndex = 1.0f;
        for (int i2 = 0; i2 < 9; ++i2) {
            float f = verIndex;
            verIndex = f + 1.0f;
            String ver = new Float(f).toString().intern();
            testDepUnits.add(this.createDeploymentUnit("org", "test", ver));
        }
        int leftOverJobs = 0;
        KModuleDeploymentUnit firstDepUnit = (KModuleDeploymentUnit)testDepUnits.peek();
        for (i = 0; i < 3; ++i) {
            this.submitJob((KModuleDeploymentUnit)testDepUnits.poll());
        }
        this.submitJob(firstDepUnit);
        ++leftOverJobs;
        for (i = 0; i < 3; ++i) {
            this.jobCompletionSemaphore.release();
            Thread.yield();
        }
        int waitTries = 0;
        while (this.submittedPendingJobsTrackerList.size() != leftOverJobs && waitTries++ < 5) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"Too many or not enough jobs have completed", (long)leftOverJobs, (long)this.submittedPendingJobsTrackerList.size());
        this.submitJob(firstDepUnit);
        this.submitJob(firstDepUnit);
        ++leftOverJobs;
        this.jobCompletionSemaphore.release();
        waitTries = 0;
        while (this.submittedPendingJobsTrackerList.size() != leftOverJobs && waitTries++ < 5) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"Duplicate of completed job should have succeeded (but duplicate of pending should have failed).", (long)leftOverJobs, (long)this.submittedPendingJobsTrackerList.size());
    }

    @Test
    public void jobQueueEvictionTest() throws Exception {
        int i;
        Map jobs = this.asyncDeploymentJobExecutor.jobs;
        Assert.assertEquals((long)0L, (long)jobs.size());
        int unfinishedJobs = 0;
        for (i = 0; i < 3; ++i) {
            this.addJob(i, jobs);
            ++unfinishedJobs;
        }
        Assert.assertEquals((String)"Jobs cache should be full.", (long)3L, (long)jobs.size());
        this.addJob(4, jobs);
        ++unfinishedJobs;
        this.addJob(5, jobs);
        ++unfinishedJobs;
        Assert.assertEquals((String)"Jobs cache should NOT evict unfinished jobs.", (long)5L, (long)jobs.size());
        for (i = 0; i < 2; ++i) {
            this.jobCompletionSemaphore.release();
            --unfinishedJobs;
            Thread.yield();
        }
        int testTries = 0;
        while (this.submittedPendingJobsTrackerList.size() > 2 && testTries++ < 5) {
            Thread.sleep(100L);
        }
        this.addJob(6, jobs);
        ++unfinishedJobs;
        int jobsWaiting = 0;
        for (Map.Entry jobsEntry : jobs.entrySet()) {
            if (((Future)jobsEntry.getValue()).isDone()) continue;
            ++jobsWaiting;
            logger.debug("NOT DONE: " + (String)jobsEntry.getKey());
        }
        Assert.assertEquals((String)"Jobs cache should only evict finished jobs.", (long)unfinishedJobs, (long)jobsWaiting);
    }

    @Test
    public void duplicateRequestsOfFinishedOrCancelledRequestsAreAcceptedTest() throws Exception {
        int i;
        KModuleDeploymentUnit depUnit;
        int i2;
        LinkedList<KModuleDeploymentUnit> testDepUnits = new LinkedList<KModuleDeploymentUnit>();
        float verIndex = 1.0f;
        for (int i3 = 0; i3 < 4; ++i3) {
            float f = verIndex;
            verIndex = f + 1.0f;
            String ver = new Float(f).toString().intern();
            testDepUnits.add(this.createDeploymentUnit("org", "art", ver));
        }
        Iterator iter = testDepUnits.iterator();
        for (i2 = 0; i2 < 3; ++i2) {
            depUnit = (KModuleDeploymentUnit)iter.next();
            logger.debug("[" + depUnit.getIdentifier() + "] job submitted.");
            this.submitJob(depUnit);
        }
        Assert.assertEquals((String)"Submitted jobs: ", (long)this.asyncDeploymentJobExecutor.jobs.size(), (long)3L);
        iter = testDepUnits.iterator();
        for (i2 = 0; i2 < 3; ++i2) {
            depUnit = (KModuleDeploymentUnit)iter.next();
            logger.debug("[" + depUnit.getIdentifier() + "] job submitted.");
            JaxbDeploymentJobResult result = this.asyncDeploymentJobExecutor.submitJob(this.deploymentService, depUnit, AsyncDeploymentJobExecutor.JobType.DEPLOY);
            Assert.assertFalse((String)"Duplicate job should not have been accepted.", (boolean)result.isSuccess());
        }
        for (i2 = 0; i2 < 3; ++i2) {
            this.jobCompletionSemaphore.release();
            Thread.yield();
        }
        int testTries = 0;
        while (this.submittedPendingJobsTrackerList.size() > 0 && testTries++ < 5) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)("Still " + this.submittedPendingJobsTrackerList.size() + " jobs incomplete."), (boolean)this.submittedPendingJobsTrackerList.isEmpty());
        iter = testDepUnits.iterator();
        for (i = 0; i < 3; ++i) {
            KModuleDeploymentUnit depUnit2 = (KModuleDeploymentUnit)iter.next();
            logger.debug("[" + depUnit2.getIdentifier() + "] job submitted.");
            this.submitJob(depUnit2);
        }
        Assert.assertEquals((String)"Jobs submitted: ", (long)this.submittedPendingJobsTrackerList.size(), (long)3L);
        for (i = 0; i < 3; ++i) {
            this.jobCompletionSemaphore.release();
            Thread.yield();
        }
        testTries = 0;
        while (this.submittedPendingJobsTrackerList.size() > 0 && testTries++ < 5) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)("Still " + this.submittedPendingJobsTrackerList.size() + " jobs incomplete."), (boolean)this.submittedPendingJobsTrackerList.isEmpty());
    }
}

