/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jbpm.kie.services.api.Kjar;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.kie.internal.deployment.DeployedUnit;
import org.kie.internal.deployment.DeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.remote.exception.DeploymentNotFoundException;
import org.kie.services.remote.exception.KieRemoteServicesInternalError;
import org.kie.services.remote.rest.ResourceBase;
import org.kie.services.remote.rest.async.AsyncDeploymentJobExecutor;
import org.kie.services.remote.rest.exception.RestOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/deployment/{deploymentId: [\\w\\.-]+(:[\\w\\.-]+){2,2}(:[\\w\\.-]*){0,2}}")
@RequestScoped
public class DeploymentResource
extends ResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentResource.class);
    @Context
    private HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private Request restRequest;
    @PathParam(value="deploymentId")
    private String deploymentId;
    @Inject
    @Kjar
    private KModuleDeploymentService deploymentService;
    @Inject
    private AsyncDeploymentJobExecutor jobExecutor;

    protected KModuleDeploymentUnit createDeploymentUnit(String deploymentId) {
        String[] gavKK = deploymentId.split(":");
        KModuleDeploymentUnit deployUnit = new KModuleDeploymentUnit(gavKK[0], gavKK[1], gavKK[2]);
        if (gavKK.length > 3) {
            deployUnit.setKbaseName(gavKK[3]);
        }
        if (gavKK.length > 4) {
            deployUnit.setKsessionName(gavKK[4]);
        }
        return deployUnit;
    }

    public static JaxbDeploymentUnit convertKModuleDepUnitToJaxbDepUnit(KModuleDeploymentUnit kDepUnit) {
        JaxbDeploymentUnit jDepUnit = new JaxbDeploymentUnit(kDepUnit.getGroupId(), kDepUnit.getArtifactId(), kDepUnit.getVersion(), kDepUnit.getKbaseName(), kDepUnit.getKsessionName());
        jDepUnit.setStrategy(kDepUnit.getStrategy());
        return jDepUnit;
    }

    @GET
    @Path(value="/")
    public Response getConfig() {
        JaxbDeploymentUnit jaxbDepUnit;
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(this.deploymentId);
        if (deployedUnit == null) {
            logger.debug("No deployment unit found, getting status");
            JaxbDeploymentUnit.JaxbDeploymentStatus status = this.jobExecutor.getStatus(this.deploymentId);
            switch (status) {
                case DEPLOYING: 
                case UNDEPLOYING: 
                case DEPLOY_FAILED: 
                case UNDEPLOY_FAILED: 
                case UNDEPLOYED: {
                    String[] gavKK = this.deploymentId.split(":");
                    jaxbDepUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2]);
                    jaxbDepUnit.setStatus(status);
                    break;
                }
                case DEPLOYED: {
                    deployedUnit = this.deploymentService.getDeployedUnit(this.deploymentId);
                    if (deployedUnit == null) {
                        throw new KieRemoteServicesInternalError("Impossible error: the job executor says that this has been deployed but it can't be located via the deployment service.");
                    }
                    jaxbDepUnit = this.extractDeploymentUnit(deployedUnit);
                    jaxbDepUnit.setStatus(status);
                    break;
                }
                case NONEXISTENT: {
                    throw new DeploymentNotFoundException("Deployment " + this.deploymentId + " does not exist");
                }
                default: {
                    throw new KieRemoteServicesInternalError("Unknown deployment status (" + status.toString() + "), contact the developers.");
                }
            }
        } else {
            jaxbDepUnit = this.extractDeploymentUnit(deployedUnit);
            jaxbDepUnit.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED);
        }
        logger.debug("Returning deployment unit information for " + this.deploymentId);
        return DeploymentResource.createCorrectVariant(jaxbDepUnit, this.headers);
    }

    private JaxbDeploymentUnit extractDeploymentUnit(DeployedUnit deployedUnit) {
        KModuleDeploymentUnit depUnit = (KModuleDeploymentUnit)deployedUnit.getDeploymentUnit();
        return DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(depUnit);
    }

    @POST
    @Path(value="/deploy")
    public Response deploy() {
        Map<String, List<String>> params = DeploymentResource.getRequestParams(this.uriInfo);
        String oper = DeploymentResource.getRelativePath(this.uriInfo);
        String strategy = DeploymentResource.getStringParam("strategy", false, params, oper);
        KModuleDeploymentUnit deploymentUnit = this.createDeploymentUnit(this.deploymentId);
        if (strategy != null) {
            DeploymentUnit.RuntimeStrategy runtimeStrategy;
            strategy = strategy.toUpperCase();
            try {
                runtimeStrategy = DeploymentUnit.RuntimeStrategy.valueOf((String)strategy);
            }
            catch (IllegalArgumentException iae) {
                throw RestOperationException.badRequest("Runtime strategy '" + strategy + "' does not exist.");
            }
            deploymentUnit.setStrategy(runtimeStrategy);
        }
        JaxbDeploymentJobResult jobResult = this.jobExecutor.submitDeployJob(this.deploymentService, deploymentUnit);
        jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYING);
        return DeploymentResource.createCorrectVariant(jobResult, this.headers, Response.Status.ACCEPTED);
    }

    @POST
    @Path(value="/undeploy")
    public Response undeploy() {
        JaxbDeploymentJobResult jobResult;
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(this.deploymentId);
        if (deployedUnit != null) {
            KModuleDeploymentUnit deploymentUnit = (KModuleDeploymentUnit)deployedUnit.getDeploymentUnit();
            jobResult = this.jobExecutor.submitUndeployJob(this.deploymentService, deploymentUnit);
            jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYING);
        } else {
            JaxbDeploymentUnit depUnit;
            String[] gavKK = this.deploymentId.split(":");
            switch (gavKK.length) {
                case 3: {
                    depUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2]);
                    break;
                }
                case 4: {
                    depUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2], gavKK[3], null);
                    break;
                }
                case 5: {
                    depUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2], gavKK[3], gavKK[4]);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid deployment id: " + this.deploymentId);
                }
            }
            jobResult = new JaxbDeploymentJobResult("Deployment unit has already been undeployed.", true, depUnit, "UNDEPLOY");
        }
        return DeploymentResource.createCorrectVariant(jobResult, this.headers, Response.Status.ACCEPTED);
    }
}

