/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.Collection;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jbpm.kie.services.api.Kjar;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.kie.internal.deployment.DeployedUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnitList;
import org.kie.services.remote.cdi.DeploymentInfoBean;
import org.kie.services.remote.rest.DeploymentResource;
import org.kie.services.remote.rest.ResourceBase;

@Path(value="/deployment")
@RequestScoped
public class DeploymentsResource
extends ResourceBase {
    @Context
    private HttpHeaders headers;
    @Inject
    @Kjar
    private KModuleDeploymentService deploymentService;
    @Inject
    private DeploymentInfoBean deploymentInfoBean;

    @GET
    @Path(value="/")
    public Response listDeployments() {
        Collection<String> deploymentIds = this.deploymentInfoBean.getDeploymentIds();
        JaxbDeploymentUnitList jaxbDepUnitList = new JaxbDeploymentUnitList();
        List depUnitList = jaxbDepUnitList.getDeploymentUnitList();
        for (String deploymentId : deploymentIds) {
            DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
            JaxbDeploymentUnit jaxbDepUnit = DeploymentResource.convertKModuleDepUnitToJaxbDepUnit((KModuleDeploymentUnit)deployedUnit.getDeploymentUnit());
            jaxbDepUnit.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED);
            depUnitList.add(jaxbDepUnit);
        }
        return DeploymentsResource.createCorrectVariant(new JaxbDeploymentUnitList(depUnitList), this.headers);
    }
}

