/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest.async;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.kie.internal.deployment.DeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.remote.exception.KieRemoteServicesInternalError;
import org.kie.services.remote.rest.DeploymentResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class AsyncDeploymentJobExecutor {
    private static final Logger logger = LoggerFactory.getLogger(AsyncDeploymentJobExecutor.class);
    final ExecutorService executor;
    final Map<String, Future<Boolean>> jobs;
    private static int maxQueueSize = 100;
    public static final String MAX_JOB_QUEUE_SIZE_PROP = "org.kie.remote.rest.deployment.job.queue.size";

    public AsyncDeploymentJobExecutor() {
        String maxCacheSizePropStr = System.getProperty(MAX_JOB_QUEUE_SIZE_PROP, String.valueOf(maxQueueSize));
        try {
            maxQueueSize = Integer.valueOf(maxCacheSizePropStr);
        }
        catch (NumberFormatException nfe) {
            logger.error("Unable to format org.kie.remote.rest.deployment.job.queue.size value: '" + maxCacheSizePropStr + "', " + "using " + maxQueueSize + " for job cache size");
        }
        Cache cache = new Cache(maxQueueSize);
        this.jobs = Collections.synchronizedMap(cache);
        this.executor = Executors.newSingleThreadExecutor();
    }

    public JaxbDeploymentJobResult submitDeployJob(KModuleDeploymentService deploymentService, KModuleDeploymentUnit depUnit) {
        return this.submitJob(deploymentService, depUnit, JobType.DEPLOY);
    }

    public JaxbDeploymentJobResult submitUndeployJob(KModuleDeploymentService deploymentService, KModuleDeploymentUnit depUnit) {
        return this.submitJob(deploymentService, depUnit, JobType.UNDEPLOY);
    }

    JaxbDeploymentJobResult submitJob(KModuleDeploymentService deploymentService, KModuleDeploymentUnit depUnit, JobType type) {
        String loggerJobId = type.toString() + " job for [" + depUnit.getIdentifier() + "]";
        if (this.jobs.size() > maxQueueSize) {
            String msg = "Queue is full with existing incomplete un/deploy jobs";
            logger.info(loggerJobId + " NOT submitted: " + msg);
            return new JaxbDeploymentJobResult(msg, false, DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(depUnit), type.toString());
        }
        String jobId = depUnit.getIdentifier() + "-" + type.toString();
        Future<Boolean> previousJob = this.jobs.get(jobId);
        String JOB_ALREADY_EXISTS_MSG = "A job already exists to " + type.toString().toLowerCase() + " deployment [" + depUnit.getIdentifier() + "]";
        if (this.jobIsPending(previousJob)) {
            logger.info(type.toString() + " job NOT submitted: " + JOB_ALREADY_EXISTS_MSG);
            return new JaxbDeploymentJobResult(JOB_ALREADY_EXISTS_MSG, false, DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(depUnit), type.toString());
        }
        DeploymentJobCallable jobCallable = new DeploymentJobCallable(depUnit, type, deploymentService);
        Future<Boolean> newJob = this.executor.submit(jobCallable);
        previousJob = this.putIfAbsent(jobId, newJob, this.jobs);
        String JOB_SUBMITTED_MSG = "Deployment (" + type.toString().toLowerCase() + ") job submitted";
        if (this.jobIsPending(previousJob)) {
            if (newJob.cancel(false)) {
                logger.info(type.toString() + " job submitted but cancelled: " + JOB_ALREADY_EXISTS_MSG);
                return new JaxbDeploymentJobResult(JOB_ALREADY_EXISTS_MSG, false, DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(depUnit), type.toString());
            }
            String msg = JOB_SUBMITTED_MSG + " but was unable to cancel a previous identical job: this job may fail";
            logger.info(loggerJobId + " submitted: " + msg);
            return new JaxbDeploymentJobResult(msg, false, DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(depUnit), type.toString());
        }
        logger.info(loggerJobId + " submitted succesfully");
        return new JaxbDeploymentJobResult(JOB_SUBMITTED_MSG + " successfully.", true, DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(depUnit), type.toString());
    }

    private boolean jobIsPending(Future<Boolean> job) {
        if (job == null) {
            return false;
        }
        return !job.isDone() && !job.isCancelled();
    }

    public JaxbDeploymentUnit.JaxbDeploymentStatus getStatus(String deploymentUnitId) {
        Future<Boolean> deployJob = this.jobs.get(deploymentUnitId + "-" + (Object)((Object)JobType.DEPLOY));
        Future<Boolean> undeployJob = this.jobs.get(deploymentUnitId + "-" + (Object)((Object)JobType.UNDEPLOY));
        if (deployJob == null && undeployJob == null) {
            return JaxbDeploymentUnit.JaxbDeploymentStatus.NONEXISTENT;
        }
        if (deployJob != null && !deployJob.isDone()) {
            return JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYING;
        }
        if (undeployJob != null && !undeployJob.isDone()) {
            return JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYING;
        }
        if (deployJob != null) {
            this.jobs.values().remove(deployJob);
            Boolean success = false;
            try {
                success = deployJob.get(1L, TimeUnit.MILLISECONDS);
                if (success == null) {
                    throw new KieRemoteServicesInternalError("Impossible error: deployment job did not return a boolean. Contact the developers");
                }
            }
            catch (Exception e) {
                return JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOY_FAILED;
            }
            if (success.booleanValue()) {
                return JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED;
            }
            return JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOY_FAILED;
        }
        this.jobs.values().remove(undeployJob);
        Boolean success = false;
        try {
            success = undeployJob.get(1L, TimeUnit.MILLISECONDS);
            if (success == null) {
                throw new KieRemoteServicesInternalError("Impossible error: deployment job did not return a boolean. Contact the developers");
            }
        }
        catch (Exception e) {
            return JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOY_FAILED;
        }
        if (success.booleanValue()) {
            return JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYED;
        }
        return JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOY_FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Boolean> putIfAbsent(String jobId, Future<Boolean> newJob, Map<String, Future<Boolean>> jobs) {
        Map<String, Future<Boolean>> map = jobs;
        synchronized (map) {
            if (!jobs.containsKey(jobId)) {
                return jobs.put(jobId, newJob);
            }
            return jobs.get(jobId);
        }
    }

    int getMaxJobQueueSize() {
        return maxQueueSize;
    }

    private static class DeploymentJobCallable
    implements Callable<Boolean> {
        private KModuleDeploymentUnit deploymentUnit;
        private JobType type;
        private KModuleDeploymentService deploymentService;

        public DeploymentJobCallable(KModuleDeploymentUnit depUnit, JobType type, KModuleDeploymentService deploymentService) {
            this.deploymentUnit = depUnit;
            this.type = type;
            this.deploymentService = deploymentService;
        }

        private void makeGarbageCollectionEasy() {
            this.type = null;
            this.deploymentService = null;
            this.deploymentUnit = null;
        }

        @Override
        public Boolean call() throws Exception {
            boolean success = false;
            switch (this.type) {
                case DEPLOY: {
                    try {
                        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
                        logger.debug("Deployment unit [" + this.deploymentUnit.getIdentifier() + "] deployed");
                        success = true;
                    }
                    catch (Exception e) {
                        logger.error("Unable to deploy [" + this.deploymentUnit.getIdentifier() + "]", (Throwable)e);
                        success = false;
                    }
                    break;
                }
                case UNDEPLOY: {
                    try {
                        this.deploymentService.undeploy((DeploymentUnit)this.deploymentUnit);
                        logger.debug("Deployment unit [" + this.deploymentUnit.getIdentifier() + "] undeployed");
                        success = true;
                    }
                    catch (Exception e) {
                        logger.error("Unable to undeploy [" + this.deploymentUnit.getIdentifier() + "]", (Throwable)e);
                        success = false;
                    }
                    break;
                }
                default: {
                    throw new KieRemoteServicesInternalError("Unknown " + JobType.class.getSimpleName() + " type (" + this.type.toString() + "), not taking any action");
                }
            }
            this.makeGarbageCollectionEasy();
            return success;
        }
    }

    private static class Cache<Boolean>
    extends LinkedHashMap<String, Future<Boolean>> {
        private int maxSize = 100;

        public Cache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Future<Boolean>> stringFutureEntry) {
            return stringFutureEntry.getValue().isDone() && this.size() > this.maxSize;
        }
    }

    static enum JobType {
        DEPLOY,
        UNDEPLOY;

    }
}

