/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest.async;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.kie.internal.deployment.DeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.remote.rest.DeploymentResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class AsyncDeploymentJobExecutor {
    private static final Logger logger = LoggerFactory.getLogger(AsyncDeploymentJobExecutor.class);
    final ExecutorService executor;
    final Map<JobId, Future<Boolean>> jobs;
    private static int maxQueueSize = 100;
    public static final String MAX_JOB_QUEUE_SIZE_PROP = "org.kie.remote.rest.deployment.job.queue.size";

    public AsyncDeploymentJobExecutor() {
        String maxCacheSizePropStr = System.getProperty(MAX_JOB_QUEUE_SIZE_PROP, String.valueOf(maxQueueSize));
        try {
            maxQueueSize = Integer.valueOf(maxCacheSizePropStr);
        }
        catch (NumberFormatException nfe) {
            logger.error("Unable to format org.kie.remote.rest.deployment.job.queue.size value: '" + maxCacheSizePropStr + "', " + "using " + maxQueueSize + " for job cache size");
        }
        Cache cache = new Cache(maxQueueSize);
        this.jobs = Collections.synchronizedMap(cache);
        this.executor = Executors.newSingleThreadExecutor();
    }

    public JaxbDeploymentJobResult submitDeployJob(KModuleDeploymentService deploymentService, KModuleDeploymentUnit depUnit) {
        return this.submitJob(deploymentService, depUnit, JobType.DEPLOY);
    }

    public JaxbDeploymentJobResult submitUndeployJob(KModuleDeploymentService deploymentService, KModuleDeploymentUnit depUnit) {
        return this.submitJob(deploymentService, depUnit, JobType.UNDEPLOY);
    }

    JaxbDeploymentJobResult submitJob(KModuleDeploymentService deploymentService, KModuleDeploymentUnit depUnit, JobType type) {
        String typeName = type.toString();
        String typeNameLower = typeName.toLowerCase();
        String loggerJobId = typeName + " job for [" + depUnit.getIdentifier() + "]";
        if (this.jobs.size() > maxQueueSize) {
            String msg = "Queue is full with existing incomplete un/deploy jobs";
            logger.info(loggerJobId + " NOT submitted: " + msg);
            return new JaxbDeploymentJobResult(msg, false, DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(depUnit), typeName);
        }
        JobId jobId = new JobId(depUnit.getIdentifier(), type);
        DeploymentJobCallable jobCallable = new DeploymentJobCallable(depUnit, type, deploymentService);
        Future<Boolean> newJob = this.executor.submit(jobCallable);
        this.jobs.put(jobId, newJob);
        logger.info(loggerJobId + " submitted succesfully");
        return new JaxbDeploymentJobResult("Deployment (" + typeNameLower + ") job submitted successfully.", true, DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(depUnit), typeName);
    }

    public JaxbDeploymentUnit.JaxbDeploymentStatus getStatus(String deploymentUnitId) {
        JobId jobId;
        Future job;
        Map.Entry<JobId, Future<Boolean>> currentJobEntry = null;
        Map.Entry<JobId, Future<Boolean>> nextWaitingJobEntry = null;
        for (Map.Entry<JobId, Future<Boolean>> entry : this.jobs.entrySet()) {
            if (!entry.getKey().matches(deploymentUnitId)) continue;
            job = entry.getValue();
            Boolean thisJobSuccess = null;
            try {
                thisJobSuccess = (Boolean)job.get(1L, TimeUnit.NANOSECONDS);
            }
            catch (Exception e) {
                logger.warn("Unable to retrieve status of job {}", (Object)entry.getKey(), (Object)e);
            }
            if (job.isDone() && thisJobSuccess != null) {
                currentJobEntry = entry;
                continue;
            }
            nextWaitingJobEntry = entry;
            break;
        }
        if (currentJobEntry == null && nextWaitingJobEntry == null) {
            return JaxbDeploymentUnit.JaxbDeploymentStatus.NONEXISTENT;
        }
        if (currentJobEntry == null) {
            jobId = (JobId)nextWaitingJobEntry.getKey();
            if (jobId.matches(JobType.DEPLOY)) {
                return JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYING;
            }
            return JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYING;
        }
        jobId = (JobId)currentJobEntry.getKey();
        job = (Future)currentJobEntry.getValue();
        if (nextWaitingJobEntry != null) {
            job = (Future)nextWaitingJobEntry.getValue();
        }
        Boolean jobSuccess = null;
        try {
            jobSuccess = (Boolean)job.get(1L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn("Unable to retrieve status of job {}", (Object)jobId, (Object)e);
        }
        if (jobId.matches(JobType.DEPLOY)) {
            if (job.isDone()) {
                if (jobSuccess == null) {
                    return JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYING;
                }
                if (jobSuccess.booleanValue()) {
                    return JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED;
                }
                return JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOY_FAILED;
            }
            return JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYING;
        }
        if (job.isDone()) {
            if (jobSuccess == null) {
                return JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYING;
            }
            if (jobSuccess.booleanValue()) {
                return JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYED;
            }
            return JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOY_FAILED;
        }
        return JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYING;
    }

    int getMaxJobQueueSize() {
        return maxQueueSize;
    }

    private static class DeploymentJobCallable
    implements Callable<Boolean> {
        private KModuleDeploymentUnit deploymentUnit;
        private JobType type;
        private KModuleDeploymentService deploymentService;

        public DeploymentJobCallable(KModuleDeploymentUnit depUnit, JobType type, KModuleDeploymentService deploymentService) {
            this.deploymentUnit = depUnit;
            this.type = type;
            this.deploymentService = deploymentService;
        }

        private void makeGarbageCollectionEasy() {
            this.type = null;
            this.deploymentService = null;
            this.deploymentUnit = null;
        }

        @Override
        public Boolean call() throws Exception {
            boolean success = false;
            switch (this.type) {
                case DEPLOY: {
                    try {
                        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
                        logger.debug("Deployment unit [" + this.deploymentUnit.getIdentifier() + "] deployed");
                        success = true;
                    }
                    catch (Exception e) {
                        logger.error("Unable to deploy [" + this.deploymentUnit.getIdentifier() + "]", (Throwable)e);
                    }
                    break;
                }
                case UNDEPLOY: {
                    try {
                        this.deploymentService.undeploy((DeploymentUnit)this.deploymentUnit);
                        logger.debug("Deployment unit [" + this.deploymentUnit.getIdentifier() + "] undeployed");
                        success = true;
                    }
                    catch (Exception e) {
                        logger.error("Unable to undeploy [" + this.deploymentUnit.getIdentifier() + "]", (Throwable)e);
                    }
                    break;
                }
                default: {
                    logger.error("Unknown " + JobType.class.getSimpleName() + " type (" + this.type.toString() + "), not taking any action");
                }
            }
            this.makeGarbageCollectionEasy();
            return success;
        }
    }

    static class JobId {
        private final String deploymentId;
        private final JobType type;

        public JobId(String deploymentId, JobType type) {
            this.deploymentId = deploymentId;
            this.type = type;
        }

        public boolean matches(String deploymentId) {
            if (deploymentId == null) {
                return false;
            }
            return this.deploymentId.equals(deploymentId);
        }

        public boolean matches(JobType type) {
            if (type == null) {
                return false;
            }
            return this.type.equals((Object)type);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public String toString() {
            return this.deploymentId + "/" + (Object)((Object)this.type);
        }
    }

    private static class Cache<Boolean>
    extends LinkedHashMap<JobId, Future<Boolean>> {
        private static final long serialVersionUID = 1L;
        private int maxSize = 100;

        public Cache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<JobId, Future<Boolean>> stringFutureEntry) {
            Future<Boolean> future = stringFutureEntry.getValue();
            Object success = null;
            try {
                success = future.get(1L, TimeUnit.NANOSECONDS);
            }
            catch (Exception e) {
                // empty catch block
            }
            return stringFutureEntry.getValue().isDone() && success != null && this.size() > this.maxSize;
        }
    }

    static enum JobType {
        DEPLOY,
        UNDEPLOY;

    }
}

