/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.jaxb;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.jbpm.kie.services.impl.event.Deploy;
import org.jbpm.kie.services.impl.event.DeploymentEvent;
import org.jbpm.kie.services.impl.event.Undeploy;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.kie.remote.services.cdi.DeploymentInfoBean;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JaxbContextManager {
    private static final Logger logger = LoggerFactory.getLogger(JaxbContextManager.class);
    private ConcurrentHashMap<String, JAXBContext> contextsCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Object> locks = new ConcurrentHashMap();
    @Inject
    DeploymentInfoBean deploymentClassNameBean;

    public void createDeploymentLockObjectOnDeploy(@Observes @Deploy DeploymentEvent event) {
        String deploymentId = event.getDeploymentId();
        this.locks.putIfAbsent(deploymentId, new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpOnUndeploy(@Observes @Undeploy DeploymentEvent event) {
        String deploymentId = event.getDeploymentId();
        Object deploymentLockObject = this.locks.get(deploymentId);
        if (deploymentLockObject != null) {
            Object object = deploymentLockObject;
            synchronized (object) {
                this.contextsCache.remove(deploymentId);
                this.locks.remove(event.getDeploymentId());
            }
        } else {
            this.contextsCache.remove(deploymentId);
            logger.error("Lock object no available for JAXBContexts cache for deployment '" + deploymentId + "'!", new Throwable("Stack trace:"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getJaxbContext(Class<?> type, UriInfo uriInfo) {
        String deploymentId = this.getDeploymentId(uriInfo);
        if (deploymentId == null) {
            logger.warn("No deployment id present in URL: default JAXBContext will be used");
            try {
                int kieJaxbClassSetLength = JaxbSerializationProvider.KIE_JAXB_CLASS_SET.size();
                Class[] types = new Class[kieJaxbClassSetLength + JaxbSerializationProvider.PRIMITIVE_ARRAY_CLASS_SET.size()];
                System.arraycopy(JaxbSerializationProvider.KIE_JAXB_CLASS_SET.toArray(new Class[kieJaxbClassSetLength]), 0, types, 0, kieJaxbClassSetLength);
                int primArrClassSetLength = JaxbSerializationProvider.PRIMITIVE_ARRAY_CLASS_SET.size();
                System.arraycopy(JaxbSerializationProvider.PRIMITIVE_ARRAY_CLASS_SET.toArray(new Class[primArrClassSetLength]), 0, types, kieJaxbClassSetLength, primArrClassSetLength);
                return JAXBContext.newInstance((Class[])types);
            }
            catch (JAXBException e) {
                throw new IllegalStateException("Unable to create new " + JAXBContext.class.getSimpleName() + " instance.", e);
            }
        }
        Object deploymentLockObject = this.locks.get(deploymentId);
        if (deploymentLockObject == null) {
            this.locks.putIfAbsent(deploymentId, new Object());
            deploymentLockObject = this.locks.get(deploymentId);
        }
        Object types = deploymentLockObject;
        synchronized (types) {
            if (this.contextsCache.containsKey(deploymentId)) {
                return this.contextsCache.get(deploymentId);
            }
        }
        Collection<Class<?>> depClasses = this.deploymentClassNameBean.getDeploymentClasses(deploymentId);
        if (logger.isDebugEnabled()) {
            boolean found = false;
            for (Class<?> clazz : depClasses) {
                if (clazz.getName().equals(type)) {
                    found = true;
                }
                logger.debug("Adding {} to JAXBContext instance.", (Object)clazz.getName());
            }
            if (!found) {
                logger.debug("Class '{}' is not known to the deployment!", (Object)type.getCanonicalName());
            }
        }
        HashSet allClasses = new HashSet(JaxbSerializationProvider.KIE_JAXB_CLASS_SET);
        allClasses.addAll(JaxbSerializationProvider.PRIMITIVE_ARRAY_CLASS_SET);
        allClasses.addAll(depClasses);
        allClasses.add(DeploymentDescriptorImpl.class);
        Class[] allClassesArr = allClasses.toArray(new Class[allClasses.size()]);
        JAXBContext jaxbContext = null;
        try {
            Object object = deploymentLockObject;
            synchronized (object) {
                if (this.contextsCache.containsKey(deploymentId)) {
                    jaxbContext = this.contextsCache.get(deploymentId);
                } else {
                    jaxbContext = JAXBContext.newInstance((Class[])allClassesArr);
                    this.contextsCache.put(deploymentId, jaxbContext);
                }
            }
            return jaxbContext;
        }
        catch (JAXBException jaxbe) {
            String errMsg = "Unable to instantiate JAXBContext for deployment '" + deploymentId + "'.";
            logger.error(errMsg, (Throwable)jaxbe);
            throw new IllegalStateException(errMsg, jaxbe);
        }
    }

    private String getDeploymentId(UriInfo uriInfo) {
        String deploymentId = null;
        List deploymentIdParams = (List)uriInfo.getPathParameters().get((Object)"deploymentId");
        if (deploymentIdParams != null && !deploymentIdParams.isEmpty()) {
            deploymentId = (String)deploymentIdParams.get(0);
        } else {
            deploymentIdParams = (List)uriInfo.getQueryParameters().get((Object)"deploymentId");
            if (deploymentIdParams != null && !deploymentIdParams.isEmpty()) {
                deploymentId = (String)deploymentIdParams.get(0);
            }
        }
        return deploymentId;
    }
}

