/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.jaxb;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.kie.remote.services.rest.jaxb.DynamicJaxbContext;

public class DynamicJaxbContextFilter
implements Filter {
    private FilterConfig _filterConfig;
    public static final String DEFAULT_JAXB_CONTEXT_ID = "**DEFAULT";

    public void init(FilterConfig filterConfig) throws ServletException {
        this._filterConfig = filterConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String deploymentId = DynamicJaxbContextFilter.getDeploymentId(httpRequest);
        DynamicJaxbContext.setDeploymentJaxbContext(deploymentId);
        try {
            chain.doFilter(request, response);
        }
        finally {
            DynamicJaxbContext.clearDeploymentJaxbContext();
        }
    }

    public void destroy() {
        this._filterConfig = null;
    }

    static String getDeploymentId(HttpServletRequest request) {
        String deploymentId = null;
        String requestUri = request.getRequestURI();
        String[] urlParts = requestUri.split("/");
        for (int i = 0; i < urlParts.length; ++i) {
            if (!urlParts[i].equals("deployment") && !urlParts[i].equals("runtime") || i + 1 >= urlParts.length) continue;
            deploymentId = urlParts[i + 1];
            break;
        }
        if (deploymentId == null) {
            deploymentId = request.getParameter("deploymentId");
        }
        if (deploymentId == null) {
            return DEFAULT_JAXB_CONTEXT_ID;
        }
        return deploymentId;
    }
}

