/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.services.task.query.TaskSummaryImpl;
import org.kie.api.command.Command;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.remote.services.cdi.ProcessRequestBean;
import org.kie.remote.services.rest.variant.ServerDrivenNegotiation;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbPaginatedList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinition;
import org.kie.services.shared.AcceptedCommands;
import org.kie.workbench.common.services.rest.RestOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBase {
    protected static final Logger logger = LoggerFactory.getLogger(ResourceBase.class);
    protected static final String PROC_INST_ID_PARAM_NAME = "runtimeProcInstId";
    @Inject
    protected ProcessRequestBean processRequestBean;
    private static List<Variant> variants = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_JSON_TYPE}).add().build();
    private static Variant defaultVariant = (Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_XML_TYPE}).add().build().get(0);
    private static final String ACCEPT = "Accept";
    private static final String ACCEPT_CHARSET = "Accept-Charset";
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ACCEPT_LANGUAGE = "Accept-Language";
    static int PAGE_NUM = 0;
    static int PAGE_SIZE = 1;
    static String PAGE_LONG_PARAM = "page";
    static String PAGE_SHORT_PARAM = "p";
    static String SIZE_LONG_PARAM = "pageSize";
    static String SIZE_SHORT_PARAM = "s";
    static Set<String> paginationParams = new HashSet<String>();

    protected JaxbCommandsResponse restProcessJaxbCommandsRequest(JaxbCommandsRequest request) {
        JaxbCommandsResponse jaxbResponse = new JaxbCommandsResponse(request);
        List commands = request.getCommands();
        if (commands != null) {
            Command cmd;
            int i;
            int cmdListSize = commands.size();
            for (i = 0; i < cmdListSize; ++i) {
                cmd = (Command)commands.get(i);
                if (AcceptedCommands.getSet().contains(cmd.getClass())) continue;
                throw RestOperationException.forbidden((String)("The execute REST operation does not accept " + cmd.getClass().getName() + " instances."));
            }
            for (i = 0; i < cmdListSize; ++i) {
                cmd = (Command)commands.get(i);
                this.processRequestBean.processCommand(cmd, request, i, jaxbResponse);
            }
        }
        if (commands == null || commands.isEmpty()) {
            logger.info("Commands request object with no commands sent!");
        }
        return jaxbResponse;
    }

    public static Variant getVariant(HttpHeaders headers) {
        ServerDrivenNegotiation negotiation = new ServerDrivenNegotiation();
        MultivaluedMap requestHeaders = headers.getRequestHeaders();
        ArrayList<String> acceptHeaders = (ArrayList<String>)requestHeaders.get((Object)ACCEPT);
        if (acceptHeaders != null && !acceptHeaders.isEmpty()) {
            ArrayList<String> fixedAcceptHeaders = new ArrayList<String>();
            for (String header : acceptHeaders) {
                fixedAcceptHeaders.add(header.replaceAll("q=\\.", "q=0."));
            }
            acceptHeaders = fixedAcceptHeaders;
        }
        negotiation.setAcceptHeaders((List<String>)acceptHeaders);
        negotiation.setAcceptCharsetHeaders((List)requestHeaders.get((Object)ACCEPT_CHARSET));
        negotiation.setAcceptEncodingHeaders((List)requestHeaders.get((Object)ACCEPT_ENCODING));
        negotiation.setAcceptLanguageHeaders((List)requestHeaders.get((Object)ACCEPT_LANGUAGE));
        return negotiation.getBestMatch(variants);
    }

    protected static Response createCorrectVariant(Object responseObj, HttpHeaders headers) {
        return ResourceBase.createCorrectVariant(responseObj, headers, null);
    }

    protected static Response createCorrectVariant(Object responseObj, HttpHeaders headers, Response.Status status) {
        Response.ResponseBuilder responseBuilder = null;
        Variant v = ResourceBase.getVariant(headers);
        if (v == null) {
            v = defaultVariant;
        }
        responseBuilder = status != null ? Response.status((Response.Status)status).entity(responseObj).variant(v) : Response.ok((Object)responseObj, (Variant)v);
        return responseBuilder.build();
    }

    protected static Map<String, List<String>> getRequestParams(UriInfo uriInfo) {
        return uriInfo.getQueryParameters();
    }

    protected static String getStringParam(String paramName, boolean required, Map<String, List<String>> params, String operation) {
        List<String> paramValues = ResourceBase.getStringListParam(paramName, required, params, operation);
        if (!required && paramValues.isEmpty()) {
            return null;
        }
        if (paramValues.size() != 1) {
            throw RestOperationException.badRequest((String)("One and only one '" + paramName + "' query parameter required for '" + operation + "' operation (" + paramValues.size() + " passed)."));
        }
        return paramValues.get(0);
    }

    protected static List<String> getStringListParam(String paramName, boolean required, Map<String, List<String>> params, String operation) {
        List<String> paramValues = null;
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(paramName)) continue;
            paramValues = entry.getValue();
            break;
        }
        if (paramValues == null) {
            if (required) {
                throw RestOperationException.badRequest((String)("Query parameter '" + paramName + "' required for '" + operation + "' operation."));
            }
            return new ArrayList<String>();
        }
        return paramValues;
    }

    protected static Object getObjectParam(String paramName, boolean required, Map<String, List<String>> params, String operation) {
        String paramVal = ResourceBase.getStringParam(paramName, required, params, operation);
        if (!required && paramVal == null) {
            return null;
        }
        return ResourceBase.getObjectFromString(paramName, paramVal);
    }

    protected static List<Long> getLongListParam(String paramName, boolean required, Map<String, List<String>> params, String operation, boolean mustBeLong) {
        List<String> paramValues = ResourceBase.getStringListParam(paramName, required, params, operation);
        ArrayList<Long> longValues = new ArrayList<Long>();
        for (String strVal : paramValues) {
            longValues.add((Long)ResourceBase.getNumberFromString(paramName, strVal, mustBeLong));
        }
        return longValues;
    }

    protected static Number getNumberParam(String paramName, boolean required, Map<String, List<String>> params, String operation, boolean mustBeLong) {
        String paramVal = ResourceBase.getStringParam(paramName, required, params, operation);
        if (!required && paramVal == null) {
            return null;
        }
        return ResourceBase.getNumberFromString(paramName, paramVal, mustBeLong);
    }

    private static Object getObjectFromString(String key, String mapVal) {
        if (mapVal.matches("^\".*\"$")) {
            return mapVal.substring(1, mapVal.length() - 1);
        }
        if (!mapVal.matches("^\\d+[li]?$")) {
            return mapVal;
        }
        return ResourceBase.getNumberFromString(key, mapVal, false);
    }

    private static Number getNumberFromString(String paramName, String paramVal, boolean mustBeLong) {
        if (paramVal.matches("^\\d+[li]?$")) {
            if (paramVal.matches(".*i$")) {
                if (mustBeLong) {
                    throw RestOperationException.badRequest((String)(paramName + " parameter is numerical but contains the \"Integer\" suffix 'i' and must have no suffix or \"Long\" suffix 'l' (" + paramVal + ")"));
                }
                if ((paramVal = paramVal.substring(0, paramVal.length() - 1)).length() > 9) {
                    throw RestOperationException.badRequest((String)(paramName + " parameter is numerical but too large to be an integer (" + paramVal + "i)"));
                }
                return Integer.parseInt(paramVal);
            }
            if (paramVal.length() > 18) {
                throw RestOperationException.badRequest((String)(paramName + " parameter is numerical but too large to be a long (" + paramVal + ")"));
            }
            if (paramVal.matches(".*l$")) {
                paramVal = paramVal.substring(0, paramVal.length() - 1);
            }
            return Long.parseLong(paramVal);
        }
        throw RestOperationException.badRequest((String)(paramName + " parameter does not have a numerical format (" + paramVal + ")"));
    }

    protected static Map<String, Object> extractMapFromParams(Map<String, List<String>> params, String operation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            if (!entry.getKey().startsWith("map_")) continue;
            String key = entry.getKey();
            List<String> paramValues = entry.getValue();
            if (paramValues.size() != 1) {
                throw RestOperationException.badRequest((String)("Only one map_* (" + key + ") query parameter allowed for '" + operation + "' operation (" + paramValues.size() + " passed)."));
            }
            String mapKey = key.substring("map_".length());
            String mapVal = paramValues.get(0).trim();
            map.put(mapKey, ResourceBase.getObjectFromString(key, mapVal));
        }
        return map;
    }

    protected static List<OrganizationalEntity> getOrganizationalEntityListFromParams(Map<String, List<String>> params, boolean required, String operation) {
        User newuser;
        ArrayList<OrganizationalEntity> orgEntList = new ArrayList<OrganizationalEntity>();
        List<String> users = ResourceBase.getStringListParam("user", false, params, operation);
        List<String> groups = ResourceBase.getStringListParam("group", false, params, operation);
        if (required && users.isEmpty() && groups.isEmpty()) {
            throw RestOperationException.badRequest((String)("At least 1 query parameter (either 'user' or 'group') is required for the '" + operation + "' operation."));
        }
        for (String user : users) {
            newuser = TaskModelProvider.getFactory().newUser();
            ((InternalOrganizationalEntity)newuser).setId(user);
            orgEntList.add((OrganizationalEntity)newuser);
        }
        for (String group : groups) {
            newuser = TaskModelProvider.getFactory().newGroup();
            ((InternalOrganizationalEntity)newuser).setId(group);
            orgEntList.add((OrganizationalEntity)newuser);
        }
        return orgEntList;
    }

    protected static TaskSummaryImpl convertTaskToTaskSummary(InternalTask task) {
        TaskSummaryImpl taskSummary = new TaskSummaryImpl(task.getId().longValue(), ((I18NText)task.getNames().get(0)).getText(), ((I18NText)task.getSubjects().get(0)).getText(), ((I18NText)task.getDescriptions().get(0)).getText(), task.getTaskData().getStatus(), task.getPriority(), task.getTaskData().isSkipable(), task.getTaskData().getActualOwner(), task.getTaskData().getCreatedBy(), task.getTaskData().getCreatedOn(), task.getTaskData().getActivationTime(), task.getTaskData().getExpirationTime(), task.getTaskData().getProcessId(), task.getTaskData().getProcessSessionId(), task.getTaskData().getProcessInstanceId(), task.getTaskData().getDeploymentId(), task.getSubTaskStrategy(), task.getTaskData().getParentId());
        return taskSummary;
    }

    protected static List<Status> convertStringListToStatusList(List<String> statusStrList) {
        ArrayList<Status> statuses = null;
        if (statusStrList != null && !statusStrList.isEmpty()) {
            statuses = new ArrayList<Status>();
            for (String statusStr : statusStrList) {
                try {
                    statuses.add(ResourceBase.getEnum(statusStr));
                }
                catch (IllegalArgumentException iae) {
                    throw RestOperationException.badRequest((String)(statusStr + " is not a valid status type for a task."));
                }
            }
        }
        return statuses;
    }

    protected static int[] getPageNumAndPageSize(Map<String, List<String>> params, String oper) {
        int[] pageInfo = new int[2];
        int p = 0;
        Number page = ResourceBase.getNumberParam(PAGE_LONG_PARAM, false, params, oper, false);
        if (page != null) {
            p = page.intValue();
        } else {
            Number pageShort = ResourceBase.getNumberParam(PAGE_SHORT_PARAM, false, params, oper, false);
            if (pageShort != null) {
                p = pageShort.intValue();
            }
        }
        if (p < 0) {
            p = 0;
        }
        int s = 0;
        Number pageSize = ResourceBase.getNumberParam(SIZE_LONG_PARAM, false, params, oper, false);
        if (pageSize != null) {
            s = pageSize.intValue();
        } else {
            Number pageSizeShort = ResourceBase.getNumberParam(SIZE_SHORT_PARAM, false, params, oper, false);
            if (pageSizeShort != null) {
                s = pageSizeShort.intValue();
            }
        }
        if (s < 0) {
            s = 0;
        }
        pageInfo[ResourceBase.PAGE_NUM] = p;
        pageInfo[ResourceBase.PAGE_SIZE] = s;
        return pageInfo;
    }

    protected static <T> List<T> paginate(int[] pageInfo, List<T> results) {
        ArrayList<T> pagedResults = new ArrayList<T>();
        assert (pageInfo[0] >= 0);
        if (pageInfo[1] > 0 && pageInfo[0] == 0) {
            pageInfo[0] = 1;
        }
        if (pageInfo[0] == 0 && pageInfo[1] == 0) {
            return results;
        }
        if (pageInfo[0] > 0) {
            for (int i = (pageInfo[0] - 1) * pageInfo[1]; i < pageInfo[0] * pageInfo[1] && i < results.size(); ++i) {
                pagedResults.add(results.get(i));
            }
        }
        return pagedResults;
    }

    protected static int getMaxNumResultsNeeded(int[] pageInfo) {
        int numResults = pageInfo[PAGE_NUM] * pageInfo[PAGE_SIZE];
        if (pageInfo[PAGE_NUM] == 0) {
            numResults = 1000;
        }
        return numResults;
    }

    protected static <T, R extends JaxbPaginatedList<T>> R paginateAndCreateResult(Map<String, List<String>> params, String oper, List<T> results, R resultList) {
        int[] pageInfo = ResourceBase.getPageNumAndPageSize(params, oper);
        return ResourceBase.paginateAndCreateResult(pageInfo, results, resultList);
    }

    protected static <T, R extends JaxbPaginatedList<T>> R paginateAndCreateResult(int[] pageInfo, List<T> results, R resultList) {
        if (pageInfo[0] == 0 && pageInfo[1] == 0) {
            resultList.addContents(results);
            return resultList;
        }
        results = ResourceBase.paginate(pageInfo, results);
        resultList.addContents(results);
        resultList.setPageNumber(Integer.valueOf(pageInfo[PAGE_NUM]));
        resultList.setPageSize(Integer.valueOf(pageInfo[PAGE_SIZE]));
        return resultList;
    }

    public static String getRelativePath(UriInfo uriInfo) {
        return uriInfo.getRequestUri().toString().replaceAll(".*/rest", "");
    }

    protected static Status getEnum(String value) {
        value = value.substring(0, 1).toUpperCase() + value.substring(1).toLowerCase();
        try {
            return Status.valueOf((String)value);
        }
        catch (IllegalArgumentException iae) {
            if (value.equalsIgnoreCase("inprogress")) {
                return Status.InProgress;
            }
            throw iae;
        }
    }

    protected JaxbProcessDefinition convertProcAssetDescToJaxbProcDef(ProcessAssetDesc procAssetDesc) {
        JaxbProcessDefinition jaxbProcDef = new JaxbProcessDefinition();
        jaxbProcDef.setDeploymentId(procAssetDesc.getDeploymentId());
        jaxbProcDef.setForms(procAssetDesc.getForms());
        jaxbProcDef.setId(procAssetDesc.getId());
        jaxbProcDef.setName(procAssetDesc.getName());
        jaxbProcDef.setPackageName(procAssetDesc.getPackageName());
        jaxbProcDef.setVersion(procAssetDesc.getVersion());
        return jaxbProcDef;
    }

    static {
        paginationParams.add(PAGE_LONG_PARAM);
        paginationParams.add(PAGE_SHORT_PARAM);
        paginationParams.add(SIZE_LONG_PARAM);
        paginationParams.add(SIZE_SHORT_PARAM);
    }
}

