/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.core.runtime.help.impl.XStreamXML;
import org.kie.server.api.commands.CallContainerCommand;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.CreateContainerCommand;
import org.kie.server.api.commands.DisposeContainerCommand;
import org.kie.server.api.commands.GetContainerInfoCommand;
import org.kie.server.api.commands.GetReleaseIdCommand;
import org.kie.server.api.commands.GetScannerInfoCommand;
import org.kie.server.api.commands.GetServerInfoCommand;
import org.kie.server.api.commands.ListContainersCommand;
import org.kie.server.api.commands.UpdateReleaseIdCommand;
import org.kie.server.api.commands.UpdateScannerCommand;
import org.kie.server.api.commands.optaplanner.CreateSolverCommand;
import org.kie.server.api.commands.optaplanner.DisposeSolverCommand;
import org.kie.server.api.commands.optaplanner.GetBestSolutionCommand;
import org.kie.server.api.commands.optaplanner.GetSolverStateCommand;
import org.kie.server.api.commands.optaplanner.GetSolversCommand;
import org.kie.server.api.commands.optaplanner.UpdateSolverStateCommand;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieContainerStatusFilter;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ReleaseIdFilter;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.api.model.dmn.DMNContextKS;
import org.kie.server.api.model.dmn.DMNNodeStub;
import org.kie.server.api.model.dmn.DMNResultKS;
import org.kie.server.api.model.instance.SolverInstance;
import org.optaplanner.persistence.xstream.api.score.AbstractScoreXStreamConverter;

public class XStreamMarshaller
implements Marshaller {
    protected XStream xstream;
    protected ClassLoader classLoader;
    protected Map<String, Class> classNames = new HashMap<String, Class>();

    public XStreamMarshaller(Set<Class<?>> classes, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.buildMarshaller(classes, classLoader);
        this.configureMarshaller(classes, classLoader);
    }

    protected void buildMarshaller(Set<Class<?>> classes, ClassLoader classLoader) {
        this.xstream = XStreamXML.newXStreamMarshaller((XStream)new XStream((ReflectionProvider)new PureJavaReflectionProvider()){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public Class realClass(String elementName) {
                        Class customClass = XStreamMarshaller.this.classNames.get(elementName);
                        if (customClass != null) {
                            return customClass;
                        }
                        return super.realClass(elementName);
                    }
                };
            }
        });
    }

    protected void configureMarshaller(Set<Class<?>> classes, ClassLoader classLoader) {
        this.xstream.setClassLoader(classLoader);
        AbstractScoreXStreamConverter.registerScoreConverters((XStream)this.xstream);
        this.xstream.processAnnotations(CommandScript.class);
        this.xstream.processAnnotations(CallContainerCommand.class);
        this.xstream.processAnnotations(CreateContainerCommand.class);
        this.xstream.processAnnotations(DisposeContainerCommand.class);
        this.xstream.processAnnotations(GetContainerInfoCommand.class);
        this.xstream.processAnnotations(GetScannerInfoCommand.class);
        this.xstream.processAnnotations(UpdateScannerCommand.class);
        this.xstream.processAnnotations(GetReleaseIdCommand.class);
        this.xstream.processAnnotations(UpdateReleaseIdCommand.class);
        this.xstream.processAnnotations(GetServerInfoCommand.class);
        this.xstream.processAnnotations(ListContainersCommand.class);
        this.xstream.processAnnotations(ServiceResponsesList.class);
        this.xstream.processAnnotations(ServiceResponse.class);
        this.xstream.processAnnotations(KieContainerResourceList.class);
        this.xstream.processAnnotations(KieContainerResource.class);
        this.xstream.processAnnotations(ReleaseId.class);
        this.xstream.processAnnotations(KieContainerStatus.class);
        this.xstream.processAnnotations(KieScannerResource.class);
        this.xstream.processAnnotations(KieServerInfo.class);
        this.xstream.processAnnotations(ReleaseIdFilter.class);
        this.xstream.processAnnotations(KieContainerStatusFilter.class);
        this.xstream.processAnnotations(KieContainerResourceFilter.class);
        this.xstream.processAnnotations(SolverInstance.class);
        this.xstream.processAnnotations(CreateSolverCommand.class);
        this.xstream.processAnnotations(DisposeSolverCommand.class);
        this.xstream.processAnnotations(GetBestSolutionCommand.class);
        this.xstream.processAnnotations(GetSolversCommand.class);
        this.xstream.processAnnotations(GetSolverStateCommand.class);
        this.xstream.processAnnotations(UpdateSolverStateCommand.class);
        this.xstream.processAnnotations(DMNContextKS.class);
        this.xstream.processAnnotations(DMNResultKS.class);
        this.xstream.processAnnotations(DMNNodeStub.class);
        if (classes != null) {
            for (Class<?> clazz : classes) {
                this.xstream.processAnnotations(clazz);
                this.classNames.put(clazz.getName(), clazz);
            }
        }
    }

    @Override
    public String marshall(Object objectInput) {
        return this.xstream.toXML(objectInput);
    }

    @Override
    public <T> T unmarshall(String input, Class<T> type) {
        return (T)this.xstream.fromXML(input);
    }

    @Override
    public void dispose() {
    }

    @Override
    public MarshallingFormat getFormat() {
        return MarshallingFormat.XSTREAM;
    }

    public String toString() {
        return "Marshaller{ XSTREAM }";
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.xstream.setClassLoader(classLoader);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

