/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.dmn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.server.api.model.dmn.DMNDecisionResultKS;
import org.kie.server.api.model.dmn.DMNMessageKS;
import org.kie.server.api.model.dmn.DMNNodeStub;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="dmn-evaluation-result")
public class DMNResultKS
implements DMNResult {
    @XmlElement(name="model-namespace")
    private String namespace;
    @XmlElement(name="model-name")
    private String modelName;
    @XmlElement(name="decision-name")
    private String decisionName;
    @XmlElement(name="dmn-context")
    @XmlJavaTypeAdapter(value=JaxbUnknownAdapter.class)
    private Map<String, Object> dmnContext = new HashMap<String, Object>();
    @XmlElementWrapper(name="messages")
    private List<DMNMessageKS> messages = new ArrayList<DMNMessageKS>();
    @XmlElementWrapper(name="decision-results")
    private Map<String, DMNDecisionResultKS> decisionResults = new HashMap<String, DMNDecisionResultKS>();

    public DMNResultKS() {
    }

    public DMNResultKS(DMNResult dmnResult) {
        this.setDmnContext(dmnResult.getContext().getAll());
        this.setMessages(dmnResult.getMessages());
        this.setDecisionResults(dmnResult.getDecisionResults());
    }

    public DMNResultKS(String namespace, String modelName, DMNResult dmnResult) {
        this(dmnResult);
        this.namespace = namespace;
        this.modelName = modelName;
    }

    public DMNResultKS(String namespace, String modelName, String decisionName, DMNResult dmnResult) {
        this(namespace, modelName, dmnResult);
        this.decisionName = decisionName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getDecisionName() {
        return this.decisionName;
    }

    public void setDecisionName(String decisionName) {
        this.decisionName = decisionName;
    }

    public Map<String, Object> getDmnContext() {
        return this.dmnContext;
    }

    public void setDmnContext(Map<String, Object> dmnContext) {
        dmnContext.replaceAll((k, v) -> DMNResultKS.stubDMNResult(v));
        this.dmnContext = dmnContext;
    }

    public void setMessages(List<DMNMessage> messages) {
        for (DMNMessage m : messages) {
            this.messages.add(DMNMessageKS.of(m));
        }
    }

    public void setDecisionResults(List<DMNDecisionResult> decisionResults) {
        for (DMNDecisionResult dr : decisionResults) {
            this.decisionResults.put(dr.getDecisionId(), DMNDecisionResultKS.of(dr));
        }
    }

    public DMNContext getContext() {
        return MapBackedDMNContext.of(this.dmnContext);
    }

    public List<DMNMessage> getMessages() {
        ArrayList<DMNMessage> res = new ArrayList<DMNMessage>();
        this.messages.forEach(x -> res.add((DMNMessage)x));
        return res;
    }

    public List<DMNMessage> getMessages(DMNMessage.Severity ... sevs) {
        return this.messages.stream().filter(m -> Arrays.asList(sevs).stream().anyMatch(f -> f.equals((Object)m.getSeverity()))).collect(Collectors.toList());
    }

    public boolean hasErrors() {
        return this.messages.stream().anyMatch(m -> DMNMessage.Severity.ERROR.equals((Object)m.getSeverity()));
    }

    public List<DMNDecisionResult> getDecisionResults() {
        return new ArrayList<DMNDecisionResult>(this.decisionResults.values());
    }

    public DMNDecisionResult getDecisionResultByName(String name) {
        return this.decisionResults.values().stream().filter(dr -> dr.getDecisionName().equals(name)).findFirst().get();
    }

    public DMNDecisionResult getDecisionResultById(String id) {
        return this.decisionResults.get(id);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DMNResultKS [namespace=").append(this.namespace).append(", modelName=").append(this.modelName).append(", decisionName=").append(this.decisionName).append(", dmnContext=").append(this.dmnContext).append(", messages=").append(this.messages).append(", decisionResults=").append(this.decisionResults).append("]");
        return builder.toString();
    }

    public static Object stubDMNResult(Object result) {
        if (result instanceof DMNContext) {
            ((DMNContext)result).getAll().replaceAll((k, v) -> DMNResultKS.stubDMNResult(v));
            return MapBackedDMNContext.of(((DMNContext)result).getAll());
        }
        if (result instanceof Map) {
            ((Map)result).replaceAll((k, v) -> DMNResultKS.stubDMNResult(v));
        } else {
            if (result instanceof List) {
                ((List)result).replaceAll(DMNResultKS::stubDMNResult);
                return result;
            }
            if (result instanceof Set) {
                Set originalSet = (Set)result;
                Collection mappedSet = originalSet.stream().map(DMNResultKS::stubDMNResult).collect(Collectors.toSet());
                originalSet.clear();
                originalSet.addAll(mappedSet);
                return result;
            }
            if (result.getClass().getPackage().getName().startsWith("org.kie.dmn")) {
                return DMNNodeStub.of(result);
            }
        }
        return result;
    }

    private static class MapBackedDMNContext
    implements DMNContext {
        private Map<String, Object> ctx = new HashMap<String, Object>();

        private MapBackedDMNContext() {
        }

        static MapBackedDMNContext of(Map<String, Object> ctx) {
            MapBackedDMNContext result = new MapBackedDMNContext();
            result.ctx = ctx;
            return result;
        }

        public Object set(String name, Object value) {
            return this.ctx.put(name, value);
        }

        public Object get(String name) {
            return this.ctx.get(name);
        }

        public Map<String, Object> getAll() {
            return this.ctx;
        }

        public boolean isDefined(String name) {
            return this.ctx.containsKey(name);
        }

        public DMNContext clone() {
            return MapBackedDMNContext.of(this.ctx);
        }
    }
}

