/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import org.kie.server.api.marshalling.BaseMarshallerBuilder;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerBuilder;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarshallerFactory {
    private static final Logger logger = LoggerFactory.getLogger(MarshallerFactory.class);
    private static MarshallerBuilder builder = MarshallerFactory.getMarshallerBuilder();

    public static Marshaller getMarshaller(MarshallingFormat format, ClassLoader classLoader) {
        return MarshallerFactory.getMarshaller(null, format, classLoader);
    }

    public static Marshaller getMarshaller(Set<Class<?>> classes, MarshallingFormat format, ClassLoader classLoader) {
        return builder.build(classes, format, classLoader);
    }

    private static synchronized MarshallerBuilder getMarshallerBuilder() {
        ServiceLoader<MarshallerBuilder> builders = ServiceLoader.load(MarshallerBuilder.class);
        Iterator<MarshallerBuilder> it = builders.iterator();
        if (it.hasNext()) {
            MarshallerBuilder marshallerBuilder = it.next();
            logger.debug("Found custom marshaller builder {} that is going to be used instead of the default", (Object)marshallerBuilder);
            return marshallerBuilder;
        }
        return new BaseMarshallerBuilder();
    }
}

