/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum MarshallingFormat {
    XSTREAM(0, "xstream"),
    JAXB(1, "xml"),
    JSON(2, "json");

    private final int id;
    private final String type;

    private MarshallingFormat(int id, String type) {
        this.id = id;
        this.type = type;
    }

    public int getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public static MarshallingFormat fromId(int id) {
        switch (id) {
            case 0: {
                return XSTREAM;
            }
            case 1: {
                return JAXB;
            }
            case 2: {
                return JSON;
            }
        }
        return null;
    }

    public static boolean isStrictType(String type) {
        int idx = type.indexOf(59);
        if (idx < 0 || idx + 1 == type.length()) {
            return false;
        }
        Map<String, String> parameters = Arrays.asList(type.substring(idx + 1).split(",")).stream().filter(e -> e.split("=").length > 1).map(e -> e.split("=")).collect(Collectors.toMap(e -> e[0].trim(), e -> e[1]));
        return Boolean.parseBoolean(parameters.get("strict"));
    }

    public static MarshallingFormat fromType(String type) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)type, (CharSequence)"xstream") || StringUtils.startsWithIgnoreCase((CharSequence)type, (CharSequence)"application/xstream")) {
            return XSTREAM;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)type, (CharSequence)"xml") || StringUtils.startsWithIgnoreCase((CharSequence)type, (CharSequence)"application/xml")) {
            return JAXB;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)type, (CharSequence)"json") || StringUtils.startsWithIgnoreCase((CharSequence)type, (CharSequence)"application/json")) {
            return JSON;
        }
        try {
            return MarshallingFormat.valueOf(StringUtils.upperCase((String)type));
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid marshalling format [" + type + "]");
        }
    }
}

