/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.api.model.KieContainerStatus;

@XmlRootElement(name="kie-container-status-filter")
@XStreamAlias(value="kie-container-status-filter")
@XmlAccessorType(value=XmlAccessType.NONE)
public class KieContainerStatusFilter {
    public static final KieContainerStatusFilter ACCEPT_ALL = new KieContainerStatusFilter();
    @XmlElement(name="accepted-status")
    @XStreamAlias(value="accepted-status")
    private final List<KieContainerStatus> acceptedStatuses;

    public static KieContainerStatusFilter parseFromNullableString(String inputStr) {
        String[] strStatuses;
        if (inputStr == null || inputStr.isEmpty()) {
            return ACCEPT_ALL;
        }
        ArrayList<KieContainerStatus> statuses = new ArrayList<KieContainerStatus>();
        for (String strStatus : strStatuses = inputStr.split(",")) {
            statuses.add(KieContainerStatus.valueOf(strStatus.toUpperCase()));
        }
        return new KieContainerStatusFilter(statuses);
    }

    public KieContainerStatusFilter() {
        this.acceptedStatuses = new ArrayList<KieContainerStatus>(Arrays.asList(KieContainerStatus.values()));
    }

    public KieContainerStatusFilter(List<KieContainerStatus> acceptedStatuses) {
        this.acceptedStatuses = acceptedStatuses;
    }

    public KieContainerStatusFilter(KieContainerStatus ... acceptedStatuses) {
        this.acceptedStatuses = Arrays.asList(acceptedStatuses);
    }

    public List<KieContainerStatus> getAcceptedStatuses() {
        return this.acceptedStatuses;
    }

    public boolean accept(KieContainerStatus status) {
        return this.acceptedStatuses.contains((Object)status);
    }

    public String toString() {
        return "KieContainerStatusFilter{acceptedStatuses=" + this.acceptedStatuses + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KieContainerStatusFilter that = (KieContainerStatusFilter)o;
        return this.acceptedStatuses != null ? this.acceptedStatuses.equals(that.acceptedStatuses) : that.acceptedStatuses == null;
    }

    public int hashCode() {
        return this.acceptedStatuses != null ? this.acceptedStatuses.hashCode() : 0;
    }
}

