/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

package org.kie.server.api.model.cases;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "case-adhoc-fragment")
public class CaseAdHocFragment {

    @XmlElement(name="name")
    private String name;
    @XmlElement(name="type")
    private String type;

    public CaseAdHocFragment() {

    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {

        private CaseAdHocFragment adHocFragment = new CaseAdHocFragment();

        public CaseAdHocFragment build() {
            return adHocFragment;
        }

        public Builder type(String type) {
            adHocFragment.setType(type);
            return this;
        }

        public Builder name(String name) {
            adHocFragment.setName(name);
            return this;
        }
    }

    @Override
    public String toString() {
        return "CaseAdHocFragment{" +
                "name='" + name + '\'' +
                ", type= '" + type + '\'' +
                '}';
    }
}
