/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;

@RunWith(value=Parameterized.class)
public class KieContainerResourceFilterMatchTest {
    private static final ReleaseId MATCHING_RELEASE_ID = new ReleaseId("org.example", "test-artifact", "2.0.0.Final");
    private static final ReleaseId NON_MATCHING_RELEASE_ID = new ReleaseId("foo", "bar", "baz");
    private static final KieContainerResourceFilter RELEASE_ID_FILTER = new KieContainerResourceFilter.Builder().releaseId(MATCHING_RELEASE_ID).build();
    private static final KieContainerResourceFilter STATUS_FILTER = new KieContainerResourceFilter.Builder().status(KieContainerStatus.CREATING).build();
    private static final KieContainerResource MATCHING_CONTAINER = new KieContainerResource("id1", MATCHING_RELEASE_ID, KieContainerStatus.CREATING);
    private static final KieContainerResource NON_MATCHING_CONTAINER = new KieContainerResource("id2", NON_MATCHING_RELEASE_ID, KieContainerStatus.STOPPED);
    @Parameterized.Parameter(value=0)
    public KieContainerResourceFilter filter;
    @Parameterized.Parameter(value=1)
    public KieContainerResource containerResource;
    @Parameterized.Parameter(value=2)
    public boolean expectedResult;

    @Parameterized.Parameters(name="{index}: filter={0}; MATCHING_RELEASE_ID={1}; expecting to match={2}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>(Arrays.asList({RELEASE_ID_FILTER, MATCHING_CONTAINER, true}, {RELEASE_ID_FILTER, NON_MATCHING_CONTAINER, false}, {STATUS_FILTER, MATCHING_CONTAINER, true}, {STATUS_FILTER, NON_MATCHING_CONTAINER, false}));
        return data;
    }

    @Test
    public void testAccept() {
        boolean result = this.filter.accept(this.containerResource);
        Assertions.assertThat((boolean)result).isEqualTo(this.expectedResult);
    }
}

