/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieContainerStatusFilter;

public class KieContainerStatusFilterTest {
    @Test
    public void parseFromNullableStringWithNull() {
        KieContainerStatusFilter filter = KieContainerStatusFilter.parseFromNullableString(null);
        Assertions.assertThat((Object)filter).isEqualTo((Object)KieContainerStatusFilter.ACCEPT_ALL);
    }

    @Test
    public void parseFromNullableStringWithEmptyString() {
        KieContainerStatusFilter filter = KieContainerStatusFilter.parseFromNullableString((String)"");
        Assertions.assertThat((Object)filter).isEqualTo((Object)KieContainerStatusFilter.ACCEPT_ALL);
    }

    @Test
    public void parseFromNullableStringWithSingleStatus() {
        KieContainerStatusFilter filter = KieContainerStatusFilter.parseFromNullableString((String)"started");
        Assertions.assertThat((Object)filter).isEqualTo((Object)new KieContainerStatusFilter(new KieContainerStatus[]{KieContainerStatus.STARTED}));
    }

    @Test
    public void parseFromNullableStringWithSingleStatusUppercase() {
        KieContainerStatusFilter filter = KieContainerStatusFilter.parseFromNullableString((String)"STARTED");
        Assertions.assertThat((Object)filter).isEqualTo((Object)new KieContainerStatusFilter(new KieContainerStatus[]{KieContainerStatus.STARTED}));
    }

    @Test
    public void parseFromNullableStringWithMultipleStatuses() {
        KieContainerStatusFilter filter = KieContainerStatusFilter.parseFromNullableString((String)"creating,started,failed");
        Assertions.assertThat((Object)filter).isEqualTo((Object)new KieContainerStatusFilter(new KieContainerStatus[]{KieContainerStatus.CREATING, KieContainerStatus.STARTED, KieContainerStatus.FAILED}));
    }
}

