/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.dmn;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.core.impl.DMNContextImpl;
import org.kie.dmn.core.impl.DMNDecisionResultImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.server.api.model.dmn.DMNResultKS;

public class DMNResultKSStubTest {
    @Test
    public void testDMNContextContainingListAndSublist() {
        DMNContextImpl ctx = new DMNContextImpl();
        List list = IntStream.range(1, 11).boxed().collect(Collectors.toList());
        List sublist = list.subList(1, 3);
        ctx.set("list", list);
        ctx.set("sublist", sublist);
        DMNResultImpl dmnResults = new DMNResultImpl(null);
        dmnResults.setContext((DMNContext)ctx);
        dmnResults.addDecisionResult((DMNDecisionResult)new DMNDecisionResultImpl("list", "list", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, list, Collections.emptyList()));
        dmnResults.addDecisionResult((DMNDecisionResult)new DMNDecisionResultImpl("sublist", "sublist", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, sublist, Collections.emptyList()));
        DMNResultKS results = new DMNResultKS((DMNResult)dmnResults);
        Assertions.assertThat((Object)results.getContext().get("list")).isEqualTo(list);
        Assertions.assertThat((Object)results.getContext().get("sublist")).isEqualTo(sublist);
        Assertions.assertThat((Object)results.getDecisionResultByName("list").getResult()).isEqualTo(list);
        Assertions.assertThat((Object)results.getDecisionResultByName("sublist").getResult()).isEqualTo(sublist);
    }
}

