/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.internal.utils.KieHelper;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.dmn.DMNContextKS;
import org.kie.server.api.model.dmn.DMNResultKS;

@RunWith(value=Parameterized.class)
public class DecisionMarshallingTest {
    @Parameterized.Parameter(value=0)
    public MarshallingFormat marshallingFormat;
    private Marshaller marshaller;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameterData = new ArrayList<Object[]>(Arrays.asList({MarshallingFormat.JAXB}, {MarshallingFormat.JSON}, {MarshallingFormat.XSTREAM}));
        return parameterData;
    }

    @Before
    public void setUp() {
        this.marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)this.marshallingFormat, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    @Test
    public void testMarshalling() {
        KieSession kieSession = new KieHelper().addFromClassPath("/FunctionDefinition.dmn").build(new KieBaseOption[0]).newKieSession();
        DMNRuntime dmnRuntime = (DMNRuntime)kieSession.getKieRuntime(DMNRuntime.class);
        DMNModel model = (DMNModel)dmnRuntime.getModels().get(0);
        DMNContext realCtx = dmnRuntime.newContext();
        realCtx.set("a", (Object)10);
        realCtx.set("b", (Object)5);
        DMNContextKS dmnClientRequest = new DMNContextKS(realCtx.getAll());
        DMNContextKS mu_dmnClientRequest = this.marshallUnmarshall(dmnClientRequest);
        Assert.assertEquals((Object)dmnClientRequest.getNamespace(), (Object)mu_dmnClientRequest.getNamespace());
        Assert.assertEquals((Object)dmnClientRequest.getModelName(), (Object)mu_dmnClientRequest.getModelName());
        MatcherAssert.assertThat((Object)dmnClientRequest.getDecisionNames(), (Matcher)Is.is((Object)mu_dmnClientRequest.getDecisionNames()));
        Assert.assertEquals((long)dmnClientRequest.getDmnContext().size(), (long)mu_dmnClientRequest.getDmnContext().size());
        Assert.assertEquals(dmnClientRequest.getDmnContext().keySet(), mu_dmnClientRequest.getDmnContext().keySet());
        DMNResult evaluateAll = dmnRuntime.evaluateAll(model, realCtx);
        ServiceResponse dmnClientResponse = new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Test case", (Object)new DMNResultKS(model.getNamespace(), model.getName(), dmnClientRequest.getDecisionNames(), evaluateAll));
        ServiceResponse mu_dmnClientResponse = this.marshallUnmarshall(dmnClientResponse);
        Assert.assertEquals((Object)((DMNResultKS)dmnClientResponse.getResult()).getNamespace(), (Object)((DMNResultKS)mu_dmnClientResponse.getResult()).getNamespace());
        Assert.assertEquals((Object)((DMNResultKS)dmnClientResponse.getResult()).getModelName(), (Object)((DMNResultKS)mu_dmnClientResponse.getResult()).getModelName());
        MatcherAssert.assertThat((Object)((DMNResultKS)dmnClientResponse.getResult()).getDecisionNames(), (Matcher)Is.is((Object)((DMNResultKS)mu_dmnClientResponse.getResult()).getDecisionNames()));
        Assert.assertEquals((long)((DMNResultKS)dmnClientResponse.getResult()).getDmnContext().size(), (long)((DMNResultKS)mu_dmnClientResponse.getResult()).getDmnContext().size());
        Assert.assertEquals(((DMNResultKS)dmnClientResponse.getResult()).getDmnContext().keySet(), ((DMNResultKS)mu_dmnClientResponse.getResult()).getDmnContext().keySet());
    }

    private <V> V marshallUnmarshall(V input) {
        try {
            String marshall = this.marshaller.marshall(input);
            System.out.println(marshall);
            Object unmarshall = this.marshaller.unmarshall(marshall, input.getClass());
            return (V)unmarshall;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

