/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.instance.ScoreWrapper;
import org.kie.server.api.model.instance.SolverInstance;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;

@RunWith(value=Parameterized.class)
public class ScoresMarshallingTest {
    @Parameterized.Parameter(value=0)
    public MarshallingFormat marshallingFormat;
    private Marshaller marshaller;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameterData = new ArrayList<Object[]>(Arrays.asList({MarshallingFormat.JAXB}, {MarshallingFormat.JSON}, {MarshallingFormat.XSTREAM}));
        return parameterData;
    }

    @Before
    public void setUp() {
        this.marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)this.marshallingFormat, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    @Test
    public void testMarshallHardSoftScore() {
        HardSoftScore score = HardSoftScore.valueOf((int)10, (int)20);
        HardSoftScore result = this.marshallUnmarshallScore(score);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)10L, (long)result.getHardScore());
        Assert.assertEquals((long)20L, (long)result.getSoftScore());
    }

    private <S extends Score<?>> S marshallUnmarshallScore(S toBeMarshalled) {
        ScoreWrapper wrapper = new ScoreWrapper(toBeMarshalled);
        SolverInstance instance = new SolverInstance();
        instance.setScoreWrapper(wrapper);
        String marshalledSolver = this.marshaller.marshall((Object)instance);
        SolverInstance result = (SolverInstance)this.marshaller.unmarshall(marshalledSolver, SolverInstance.class);
        return (S)result.getScoreWrapper().toScore();
    }
}

