/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.dmn;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMetadata;
import org.kie.server.api.model.dmn.DMNResultKS;

public class DMNResultKSContextTest {
    protected static final Map<String, Object> DEFAULT_ENTRIES = ImmutableMap.of((Object)"s_entr1", (Object)"value1", (Object)"i_entr2", (Object)2, (Object)"f_entr3", (Object)3.0, (Object)"s_entr4", (Object)"4");
    protected static final String DEFAULT_SCOPE_NAME = "theName";
    protected static final String DEFAULT_SCOPE_NAMESPACE = "theNamespace";
    protected static final Map<String, Object> DEFAULT_SCOPE_ENTRIES = ImmutableMap.of((Object)"s_scEn1", (Object)"scopeValue1", (Object)"i_scEn2", (Object)2, (Object)"f_scEn3", (Object)3.0, (Object)"s_scEn4", (Object)"4");
    protected static final Map<String, Object> DEFAULT_METADATA = ImmutableMap.of((Object)"s_meta1", (Object)"value1", (Object)"i_meta2", (Object)2, (Object)"f_meta3", (Object)3.0, (Object)"s_meta4", (Object)"4");

    @Test
    public void testEmptyContext() {
        DMNResultKS.MapBackedDMNContext ctx1 = DMNResultKS.MapBackedDMNContext.of(new HashMap(Collections.emptyMap()));
        this.testCloneAndAlter((DMNContext)ctx1, Collections.emptyMap(), Collections.emptyMap());
        DMNResultKS.MapBackedDMNContext ctx2 = DMNResultKS.MapBackedDMNContext.of(new HashMap(Collections.emptyMap()));
        this.testPushAndPopScope((DMNContext)ctx2, Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void testContextWithEntries() {
        DMNResultKS.MapBackedDMNContext ctx1 = DMNResultKS.MapBackedDMNContext.of(new HashMap<String, Object>(DEFAULT_ENTRIES));
        this.testCloneAndAlter((DMNContext)ctx1, DEFAULT_ENTRIES, Collections.emptyMap());
        DMNResultKS.MapBackedDMNContext ctx2 = DMNResultKS.MapBackedDMNContext.of(new HashMap<String, Object>(DEFAULT_ENTRIES));
        this.testPushAndPopScope((DMNContext)ctx2, DEFAULT_ENTRIES, Collections.emptyMap());
    }

    @Test
    public void testContextWithEntriesAndMetadata() {
        DMNResultKS.MapBackedDMNContext ctx1 = DMNResultKS.MapBackedDMNContext.of(new HashMap<String, Object>(DEFAULT_ENTRIES), new HashMap<String, Object>(DEFAULT_METADATA));
        this.testCloneAndAlter((DMNContext)ctx1, DEFAULT_ENTRIES, DEFAULT_METADATA);
        DMNResultKS.MapBackedDMNContext ctx2 = DMNResultKS.MapBackedDMNContext.of(new HashMap<String, Object>(DEFAULT_ENTRIES), new HashMap<String, Object>(DEFAULT_METADATA));
        this.testPushAndPopScope((DMNContext)ctx2, DEFAULT_ENTRIES, DEFAULT_METADATA);
    }

    public void testEquals(DMNContext ctx, Map<String, Object> expectedEntries, Map<String, Object> expectedMetadata) {
        this.testEntries(ctx, expectedEntries);
        this.testEntries(ctx.getMetadata(), expectedMetadata);
    }

    public void testCloneAndAlter(DMNContext ctx, Map<String, Object> expectedEntries, Map<String, Object> expectedMetadata) {
        this.testEquals(ctx, expectedEntries, expectedMetadata);
        DMNContext cloned = ctx.clone();
        this.testEquals(cloned, expectedEntries, expectedMetadata);
        Map<String, Object> alteredEntries = DMNResultKSContextTest.alter((arg_0, arg_1) -> ((DMNContext)ctx).set(arg_0, arg_1), expectedEntries, ImmutableMap.of((Object)"f_entr3", (Object)6.0, (Object)"s_entr5", (Object)"five"));
        Map<String, Object> alteredMetadata = DMNResultKSContextTest.alter((arg_0, arg_1) -> ((DMNMetadata)ctx.getMetadata()).set(arg_0, arg_1), expectedMetadata, ImmutableMap.of((Object)"i_meta2", (Object)20, (Object)"s_meta5", (Object)"FIVE"));
        this.testEquals(ctx, alteredEntries, alteredMetadata);
        this.testEquals(cloned, expectedEntries, expectedMetadata);
        Map<String, Object> alteredClonedEntries = DMNResultKSContextTest.alter((arg_0, arg_1) -> ((DMNContext)cloned).set(arg_0, arg_1), expectedEntries, ImmutableMap.of((Object)"f_entr3", (Object)9.0, (Object)"s_entr6", (Object)"six"));
        Map<String, Object> alteredClonedMetadata = DMNResultKSContextTest.alter((arg_0, arg_1) -> ((DMNMetadata)cloned.getMetadata()).set(arg_0, arg_1), expectedMetadata, ImmutableMap.of((Object)"i_meta2", (Object)200, (Object)"s_meta6", (Object)"SIX"));
        this.testEquals(ctx, alteredEntries, alteredMetadata);
        this.testEquals(cloned, alteredClonedEntries, alteredClonedMetadata);
    }

    public void testPushAndPopScope(DMNContext ctx, Map<String, Object> expectedEntries, Map<String, Object> expectedMetadata) {
        this.testEquals(ctx, expectedEntries, expectedMetadata);
        DMNResultKSContextTest.assertNamespaceIsAbsent(ctx);
        ctx.pushScope(DEFAULT_SCOPE_NAME, DEFAULT_SCOPE_NAMESPACE);
        for (Map.Entry<String, Object> entry : DEFAULT_SCOPE_ENTRIES.entrySet()) {
            ctx.set(entry.getKey(), entry.getValue());
        }
        DMNResultKSContextTest.assertNamespaceEquals(DEFAULT_SCOPE_NAMESPACE, ctx);
        this.testEquals(ctx, DEFAULT_SCOPE_ENTRIES, expectedMetadata);
        ctx.popScope();
        DMNResultKSContextTest.assertNamespaceIsAbsent(ctx);
        HashMap<String, Object> alteredEntries = new HashMap<String, Object>(expectedEntries);
        alteredEntries.put(DEFAULT_SCOPE_NAME, DEFAULT_SCOPE_ENTRIES);
        this.testEquals(ctx, alteredEntries, expectedMetadata);
    }

    public void testEntries(DMNContext context, Map<String, Object> expectedEntries) {
        this.testEntries(DMNResultKSContextTest.containerFor(context), expectedEntries);
    }

    public void testEntries(DMNMetadata metadata, Map<String, Object> expectedEntries) {
        this.testEntries(DMNResultKSContextTest.containerFor(metadata), expectedEntries);
    }

    private void testEntries(EntryContainerFacade container, Map<String, Object> expectedEntries) {
        Map<String, Object> currentEntries = container.getAll();
        Assert.assertNotNull(currentEntries);
        Assert.assertEquals((long)expectedEntries.size(), (long)currentEntries.size());
        for (Map.Entry<String, Object> entry : expectedEntries.entrySet()) {
            Assert.assertTrue((boolean)currentEntries.containsKey(entry.getKey()));
            Assert.assertEquals((Object)entry.getValue(), (Object)currentEntries.get(entry.getKey()));
            Assert.assertTrue((boolean)container.isDefined(entry.getKey()));
            Assert.assertEquals((Object)entry.getValue(), (Object)container.get(entry.getKey()));
        }
    }

    public static <K, V> Map<K, V> alter(BiConsumer<K, V> setter, Map<K, V> original, Map<K, V> additions) {
        HashMap<K, V> altered = new HashMap<K, V>(original);
        for (Map.Entry<K, V> entry : additions.entrySet()) {
            altered.put(entry.getKey(), entry.getValue());
            setter.accept(entry.getKey(), entry.getValue());
        }
        return altered;
    }

    public static void assertNamespaceIsAbsent(DMNContext ctx) {
        Optional optNamespace = ctx.scopeNamespace();
        Assert.assertNotNull((Object)optNamespace);
        Assert.assertFalse((boolean)optNamespace.isPresent());
    }

    public static void assertNamespaceEquals(String expectedName, DMNContext ctx) {
        Optional optNamespace = ctx.scopeNamespace();
        Assert.assertNotNull((Object)optNamespace);
        Assert.assertTrue((boolean)optNamespace.isPresent());
        Assert.assertEquals((Object)expectedName, optNamespace.get());
    }

    public static void assertNamespaceEquals(DMNContext expectedCtx, DMNContext testCtx) {
        Optional optExpectedNamespace = expectedCtx.scopeNamespace();
        Assert.assertNotNull((Object)optExpectedNamespace);
        Optional optTestNamespace = testCtx.scopeNamespace();
        Assert.assertNotNull((Object)optTestNamespace);
        if (optExpectedNamespace.isPresent()) {
            Assert.assertTrue((boolean)optTestNamespace.isPresent());
            Assert.assertEquals(optExpectedNamespace.get(), optTestNamespace.get());
        } else {
            Assert.assertFalse((boolean)optTestNamespace.isPresent());
        }
    }

    private static EntryContainerFacade containerFor(final DMNContext context) {
        return new EntryContainerFacade(){

            @Override
            public Object set(String name, Object value) {
                return context.set(name, value);
            }

            @Override
            public Object get(String name) {
                return context.get(name);
            }

            @Override
            public Map<String, Object> getAll() {
                return context.getAll();
            }

            @Override
            public boolean isDefined(String name) {
                return context.isDefined(name);
            }
        };
    }

    private static EntryContainerFacade containerFor(final DMNMetadata metadata) {
        return new EntryContainerFacade(){

            @Override
            public Object set(String name, Object value) {
                return metadata.set(name, value);
            }

            @Override
            public Object get(String name) {
                return metadata.get(name);
            }

            @Override
            public Map<String, Object> getAll() {
                return metadata.asMap();
            }

            @Override
            public boolean isDefined(String name) {
                return metadata.get(name) != null;
            }
        };
    }

    private static interface EntryContainerFacade {
        public Object set(String var1, Object var2);

        public Object get(String var1);

        public Map<String, Object> getAll();

        public boolean isDefined(String var1);
    }
}

