/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.io.IOUtils;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Files;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.Person;
import org.kie.server.api.marshalling.SupportedlDate;
import org.kie.server.api.marshalling.json.JSONMarshaller;
import org.kie.server.api.marshalling.objects.DateObject;
import org.kie.server.api.marshalling.objects.DateObjectUnannotated;
import org.kie.server.api.model.definition.QueryParam;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class JSONMarshallerTest {
    @After
    public void cleanup() {
        System.clearProperty("org.kie.server.json.format.date");
    }

    @Test
    public void testMarshallDateObject() {
        String expectedString = String.format("{%n  \"localDate\" : \"2017-01-01\",%n  \"localDateTime\" : \"2017-01-01T10:10:10\",%n  \"localTime\" : \"10:10:10\",%n  \"offsetDateTime\" : \"2017-01-01T10:10:10+01:00\"%n}", new Object[0]);
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        DateObject dateObject = new DateObject();
        dateObject.setLocalDate(LocalDate.of(2017, 1, 1));
        dateObject.setLocalDateTime(LocalDateTime.of(2017, 1, 1, 10, 10, 10));
        dateObject.setLocalTime(LocalTime.of(10, 10, 10));
        dateObject.setOffsetDateTime(OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 10, 10), ZoneOffset.ofHours(1)));
        String dateObjectString = marshaller.marshall((Object)dateObject);
        Assert.assertNotNull((Object)dateObjectString);
        Assert.assertEquals((Object)expectedString, (Object)dateObjectString);
    }

    @Test
    public void testUnmarshallDateObject() {
        String expectedString = "{\n  \"localDate\" : \"2017-01-01\",\n  \"localDateTime\" : \"2017-01-01T10:10:10\",\n  \"localTime\" : \"10:10:10\",\n  \"offsetDateTime\" : \"2017-01-01T10:10:10+01:00\"\n}";
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        DateObject dateObject = (DateObject)marshaller.unmarshall(expectedString, DateObject.class);
        Assert.assertNotNull((Object)dateObject);
        Assert.assertEquals((Object)LocalDate.of(2017, 1, 1), (Object)dateObject.getLocalDate());
        Assert.assertEquals((Object)LocalDateTime.of(2017, 1, 1, 10, 10, 10), (Object)dateObject.getLocalDateTime());
        Assert.assertEquals((Object)LocalTime.of(10, 10, 10), (Object)dateObject.getLocalTime());
        Assert.assertEquals((Object)OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 10, 10), ZoneOffset.ofHours(1)), (Object)dateObject.getOffsetDateTime());
    }

    @Test
    public void testMarshallDateObjectUnannotated() {
        String expectedString = String.format("{%n  \"localDate\" : \"2017-01-01\",%n  \"localDateTime\" : \"2017-01-01T10:10:10\",%n  \"localTime\" : \"10:10:10\",%n  \"offsetDateTime\" : \"2017-01-01T10:10:10+0100\"%n}", new Object[0]);
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        DateObjectUnannotated dateObject = new DateObjectUnannotated();
        dateObject.setLocalDate(LocalDate.of(2017, 1, 1));
        dateObject.setLocalDateTime(LocalDateTime.of(2017, 1, 1, 10, 10, 10));
        dateObject.setLocalTime(LocalTime.of(10, 10, 10));
        dateObject.setOffsetDateTime(OffsetDateTime.of(2017, 1, 1, 10, 10, 10, 0, ZoneOffset.ofHours(1)));
        String dateObjectString = marshaller.marshall((Object)dateObject);
        Assert.assertNotNull((Object)dateObjectString);
        Assert.assertEquals((Object)expectedString, (Object)dateObjectString);
    }

    @Test
    public void testUnmarshallDateObjectUnannotated() {
        String expectedString = "{\n  \"localDate\" : \"2017-01-01\",\n  \"localDateTime\" : \"2017-01-01T10:10:10\",\n  \"localTime\" : \"10:10:10\",\n  \"offsetDateTime\" : \"2017-01-01T10:10:10+0100\"\n}";
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        DateObjectUnannotated dateObject = (DateObjectUnannotated)marshaller.unmarshall(expectedString, DateObjectUnannotated.class);
        Assert.assertNotNull((Object)dateObject);
        Assert.assertEquals((Object)LocalDate.of(2017, 1, 1), (Object)dateObject.getLocalDate());
        Assert.assertEquals((Object)LocalDateTime.of(2017, 1, 1, 10, 10, 10), (Object)dateObject.getLocalDateTime());
        Assert.assertEquals((Object)LocalTime.of(10, 10, 10), (Object)dateObject.getLocalTime());
        Assert.assertEquals((Object)OffsetDateTime.of(2017, 1, 1, 10, 10, 10, 0, ZoneOffset.ofHours(1)), (Object)dateObject.getOffsetDateTime());
    }

    @Test
    public void testRecursiveMap() {
        HashMap outerMap = new HashMap();
        HashMap<String, Holder> innerMap = new HashMap<String, Holder>();
        Holder holder = new Holder();
        holder.setH("myValueInH");
        innerMap.put("level2", holder);
        outerMap.put("level1", innerMap);
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        Map mu_outerMap = (Map)marshaller.unmarshall(marshaller.marshall(outerMap), Map.class);
        Map mu_innerMap = (Map)marshaller.unmarshall(marshaller.marshall(innerMap), Map.class);
        Ref ref = new Ref();
        ref.setR(innerMap);
        Ref mu_ref = (Ref)marshaller.unmarshall(marshaller.marshall((Object)ref), Ref.class);
        Assert.assertEquals((String)"verify that Ref.r is not being serialized with JSONMarshaller.WrappingObjectSerializer, but with the specified one in @JsonSerialize", mu_innerMap.entrySet(), ((Map)mu_ref.getR()).entrySet());
    }

    @Test
    public void testMarshallFormatDateObject() throws ParseException {
        System.setProperty("org.kie.server.json.format.date", "true");
        Date date = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ").parse("2018-01-01T10:00:00.000+0100");
        String expectedString = "\"2018-01-01";
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        String dateObjectString = marshaller.marshall((Object)date);
        Assert.assertNotNull((Object)dateObjectString);
        Assert.assertTrue((boolean)dateObjectString.startsWith(expectedString));
    }

    @Test
    public void testMarshallQueryParam() {
        Marshaller marshaller = MarshallerFactory.getMarshaller(new HashSet(), (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        QueryParam subParam = new QueryParam("col2", "EQUALS_TO", Collections.singletonList("XXX"));
        QueryParam param = new QueryParam("hola", "OR", Collections.singletonList(subParam));
        String converted = marshaller.marshall((Object)param);
        QueryParam param2 = (QueryParam)marshaller.unmarshall(converted, QueryParam.class);
        Assert.assertTrue((boolean)(param2.getValue().get(0) instanceof QueryParam));
    }

    @Test
    public void testParam() throws Exception {
        Marshaller marshaller = MarshallerFactory.getMarshaller(new HashSet(), (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        URL url = Thread.currentThread().getContextClassLoader().getResource("marshaller.json");
        String input = Files.contentOf((File)new File(url.toURI()), (String)"UTF-8");
        QueryParam[] params = (QueryParam[])marshaller.unmarshall(input, QueryParam[].class);
        Assert.assertEquals((long)1L, (long)params.length);
        MatcherAssert.assertThat((Object)Arrays.asList((Object)params), (Matcher)CoreMatchers.everyItem((Matcher)CoreMatchers.instanceOf(QueryParam.class)));
    }

    @Test
    public void testCapitalizedFieldnames() throws Exception {
        JSONMarshaller marshaller = new JSONMarshaller(new HashSet(), this.getClass().getClassLoader(), false, true);
        Order order = new Order("all");
        String converted = marshaller.marshall((Object)order);
        String expectedMarshalled = "{\"ORDER_ID\" : \"all\"}";
        JSONAssert.assertEquals((String)expectedMarshalled, (String)converted, (JSONCompareMode)JSONCompareMode.STRICT);
        Order unconverted = (Order)marshaller.unmarshall(converted, Order.class);
        Assert.assertEquals((Object)"all", (Object)unconverted.getORDER_ID());
    }

    @Test
    public void testLegacyFieldnames() throws Exception {
        JSONMarshaller marshaller = new JSONMarshaller(new HashSet(), this.getClass().getClassLoader(), false, false);
        Order order = new Order("all");
        String converted = marshaller.marshall((Object)order);
        String expectedMarshalled = "{\"order_ID\" : \"all\"}";
        JSONAssert.assertEquals((String)expectedMarshalled, (String)converted, (JSONCompareMode)JSONCompareMode.STRICT);
        Order unconverted = (Order)marshaller.unmarshall(converted, Order.class);
        Assert.assertEquals((Object)"all", (Object)unconverted.getORDER_ID());
    }

    @Test
    public void testCapitalizedWrapObjectFieldnames() throws Exception {
        JSONMarshaller marshaller = new JSONMarshaller(new HashSet(), this.getClass().getClassLoader(), false, true);
        BatchExecutionCommandImpl batch = new BatchExecutionCommandImpl();
        batch.addCommand((Command)new InsertObjectCommand((Object)new Order("all")));
        String converted = marshaller.marshall((Object)batch);
        String expectedMarshalled = "{ \"lookup\" : null, \"commands\" : [ { \"insert\" : { \"object\" : {\"org.kie.server.api.marshalling.JSONMarshallerTest$Order\":{ \"ORDER_ID\" : \"all\" }}, \"out-identifier\" : null, \"return-object\" : true, \"entry-point\" : \"DEFAULT\", \"disconnected\" : false } } ] }";
        JSONAssert.assertEquals((String)expectedMarshalled, (String)converted, (JSONCompareMode)JSONCompareMode.STRICT);
        BatchExecutionCommandImpl unconverted = (BatchExecutionCommandImpl)marshaller.unmarshall(converted, BatchExecutionCommandImpl.class);
        Assert.assertEquals((Object)"all", (Object)((Order)((InsertObjectCommand)unconverted.getCommands().get(0)).getObject()).getORDER_ID());
    }

    @Test
    public void testLegalizeWrapObjectFieldnames() throws Exception {
        JSONMarshaller marshaller = new JSONMarshaller(new HashSet(), this.getClass().getClassLoader(), false, false);
        BatchExecutionCommandImpl batch = new BatchExecutionCommandImpl();
        batch.addCommand((Command)new InsertObjectCommand((Object)new Order("all")));
        String converted = marshaller.marshall((Object)batch);
        String expectedMarshalled = "{ \"lookup\" : null, \"commands\" : [ { \"insert\" : { \"object\" : {\"org.kie.server.api.marshalling.JSONMarshallerTest$Order\":{ \"order_ID\" : \"all\" }}, \"out-identifier\" : null, \"return-object\" : true, \"entry-point\" : \"DEFAULT\", \"disconnected\" : false } } ] }";
        JSONAssert.assertEquals((String)expectedMarshalled, (String)converted, (JSONCompareMode)JSONCompareMode.STRICT);
        BatchExecutionCommandImpl unconverted = (BatchExecutionCommandImpl)marshaller.unmarshall(converted, BatchExecutionCommandImpl.class);
        Assert.assertEquals((Object)"all", (Object)((Order)((InsertObjectCommand)unconverted.getCommands().get(0)).getObject()).getORDER_ID());
    }

    @Test
    public void testLocalDateTimeWithClasses() throws Exception {
        HashSet<Class> hs = new HashSet<Class>();
        hs.add(Person.class);
        hs.add(SupportedlDate.class);
        JSONMarshaller marshaller = new JSONMarshaller(hs, this.getClass().getClassLoader(), false, false);
        String wrapLocalDateTimeWithType = "{\"person\":{\"org.kie.server.api.marshalling.Person\":{\"fullname\":\"123\",\"dateBirth\":{\"java.time.LocalDateTime\":\"2022-05-19T00:00\"},\"age\":\"21\"}}}";
        Map converted = (Map)marshaller.unmarshall(wrapLocalDateTimeWithType, Map.class);
        Assert.assertEquals(Person.class, converted.get("person").getClass());
        Assert.assertEquals(LocalDateTime.class, ((Person)converted.get("person")).getDateBirth().getClass());
        String wrapLocalDateTimeWithoutType = "{\"person\":{\"org.kie.server.api.marshalling.Person\":{\"fullname\":\"123\",\"dateBirth\":\"2022-05-19T00:00\",\"age\":\"21\"}}}";
        Map converted1 = (Map)marshaller.unmarshall(wrapLocalDateTimeWithoutType, Map.class);
        Assert.assertEquals(Person.class, converted1.get("person").getClass());
        Assert.assertEquals(LocalDateTime.class, ((Person)converted1.get("person")).getDateBirth().getClass());
        String localDateTimeStringWithType = "{\n    \"bdate\":{\"java.time.LocalDateTime\":\"2022-05-17T14:54\"},\n      \"name\":\"123\",\n       \"bbdate\":{\"java.time.LocalDateTime\":\"2022-05-18T00:00\"}\n}";
        Map converted2 = (Map)marshaller.unmarshall(localDateTimeStringWithType, Map.class);
        Assert.assertEquals(LocalDateTime.class, converted2.get("bdate").getClass());
        String localDateTimeStringWithoutType = "{\n    \"bdate\":\"2022-05-17T14:54\",\n      \"name\":\"123\",\n       \"bbdate\":\"2022-05-18T00:00\"}\n}";
        Map converted3 = (Map)marshaller.unmarshall(localDateTimeStringWithoutType, Map.class);
        Assert.assertEquals(String.class, converted3.get("bdate").getClass());
        Map convertedSupportedDateType = (Map)marshaller.unmarshall(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/supportedDateType.json")), Map.class);
        Assert.assertEquals(LocalDateTime.class, convertedSupportedDateType.get("bdate").getClass());
        Assert.assertEquals(LocalDateTime.class, convertedSupportedDateType.get("bbdate").getClass());
        Assert.assertEquals(LocalDate.class, convertedSupportedDateType.get("localdate").getClass());
        Assert.assertEquals(LocalTime.class, convertedSupportedDateType.get("localtime").getClass());
        Assert.assertEquals(OffsetDateTime.class, convertedSupportedDateType.get("offsetDateTime").getClass());
        Assert.assertEquals(Date.class, convertedSupportedDateType.get("utildate").getClass());
        Assert.assertEquals(SupportedlDate.class, convertedSupportedDateType.get("sqldate").getClass());
        SupportedlDate supportedDate = (SupportedlDate)convertedSupportedDateType.get("sqldate");
        Assert.assertEquals(Date.class, supportedDate.getUtildate().getClass());
        Assert.assertEquals(LocalDateTime.class, supportedDate.getLocalDateTime().getClass());
        Assert.assertEquals(LocalDate.class, supportedDate.getLocalDate().getClass());
        Assert.assertEquals(LocalTime.class, supportedDate.getLocalTime().getClass());
        Assert.assertEquals(OffsetDateTime.class, supportedDate.getOffsetDateTime().getClass());
    }

    public static class Order {
        private String ORDER_ID;

        public Order() {
        }

        public Order(String o) {
            this.ORDER_ID = o;
        }

        public String getORDER_ID() {
            return this.ORDER_ID;
        }

        public void setORDER_ID(String o) {
            this.ORDER_ID = o;
        }
    }

    public static class Ref {
        @XmlJavaTypeAdapter(value=JaxbUnknownAdapter.class)
        @JsonSerialize(using=JSONMarshaller.PassThruSerializer.class)
        private Object r;

        public Object getR() {
            return this.r;
        }

        public void setR(Object r) {
            this.r = r;
        }
    }

    public static class Holder {
        private String h;

        public String getH() {
            return this.h;
        }

        public void setH(String h) {
            this.h = h;
        }
    }
}

