/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.objects.DateObjectUnannotated;
import org.kie.server.api.model.instance.SolverInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class SolutionMarshallingTest {
    private static final Logger logger = LoggerFactory.getLogger(SolutionMarshallingTest.class);
    @Parameterized.Parameter
    public MarshallingFormat marshallingFormat;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        return new ArrayList<Object[]>(Arrays.asList({MarshallingFormat.JSON}, {MarshallingFormat.XSTREAM}));
    }

    @Test
    public void testMarshallHardSoftScore() {
        SolverInstance solverInstance = new SolverInstance();
        DateObjectUnannotated dateObject = new DateObjectUnannotated();
        dateObject.setLocalDate(LocalDate.of(2018, 8, 18));
        dateObject.setLocalDateTime(LocalDateTime.of(2017, 7, 17, 17, 17, 17));
        dateObject.setLocalTime(LocalTime.of(12, 34, 56));
        dateObject.setOffsetDateTime(OffsetDateTime.of(2019, 2, 4, 20, 57, 11, 0, ZoneOffset.ofHours(1)));
        solverInstance.setBestSolution((Object)dateObject);
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)this.marshallingFormat, (ClassLoader)Thread.currentThread().getContextClassLoader());
        String marshalledSolverInstance = marshaller.marshall((Object)solverInstance);
        logger.debug("Marshalled SolverInstance ({}): {}", (Object)this.marshallingFormat, (Object)marshalledSolverInstance);
        ((AbstractStringAssert)Assertions.assertThat((String)marshalledSolverInstance).as("Dates should be formatted", new Object[0])).contains(new CharSequence[]{"2018-08-18", "2017-07-17T17:17:17", "12:34:56", "2019-02-04T20:57:11+01"});
        SolverInstance unmarshalledSolverInstance = (SolverInstance)marshaller.unmarshall(marshalledSolverInstance, SolverInstance.class);
        DateObjectUnannotated bestSolution = (DateObjectUnannotated)unmarshalledSolverInstance.getBestSolution();
        Assertions.assertThat((LocalDate)bestSolution.getLocalDate()).isEqualTo((Object)dateObject.getLocalDate());
        Assertions.assertThat((LocalDateTime)bestSolution.getLocalDateTime()).isEqualTo((Object)dateObject.getLocalDateTime());
        Assertions.assertThat((LocalTime)bestSolution.getLocalTime()).isEqualTo((Object)dateObject.getLocalTime());
        Assertions.assertThat((OffsetDateTime)bestSolution.getOffsetDateTime()).isEqualTo((Object)dateObject.getOffsetDateTime());
    }
}

