/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.json;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.objects.CustomPerson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONMarshallerExtensionTest {
    private static final Logger logger = LoggerFactory.getLogger(JSONMarshallerExtensionTest.class);
    private static final DateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    @Test
    public void testCustomExtensionMarshaller() {
        HashSet extraClasses = new HashSet();
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        Calendar calendar = GregorianCalendar.getInstance();
        String marshall = marshaller.marshall((Object)calendar);
        Assert.assertEquals((Object)marshall, (Object)("\"" + FORMATTER.format(calendar.getTime()) + "\""));
        GregorianCalendar unmarshall = (GregorianCalendar)marshaller.unmarshall(marshall, GregorianCalendar.class);
        Assert.assertEquals((Object)unmarshall, (Object)calendar);
        PMMLRequestData request = new PMMLRequestData("123", "SimpleScorecard");
        request.addRequestParam("param1", (Object)10.0);
        request.addRequestParam("param2", (Object)15.0);
        String mshl = marshaller.marshall((Object)request);
        PMMLRequestData rd = (PMMLRequestData)marshaller.unmarshall(mshl, PMMLRequestData.class);
        Assert.assertEquals((Object)rd, (Object)request);
        logger.info(rd.toString());
    }

    @Test
    public void testObjectInsideCommand() {
        HashSet<Class<CustomPerson>> extraClasses = new HashSet<Class<CustomPerson>>();
        extraClasses.add(CustomPerson.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        CustomPerson john = new CustomPerson("John", 20);
        InsertObjectCommand command = new InsertObjectCommand((Object)john);
        String marshall = marshaller.marshall((Object)command);
        Assertions.assertThat((String)marshall).contains(new CharSequence[]{"John is CustomPerson"});
        InsertObjectCommand unmarshall = (InsertObjectCommand)marshaller.unmarshall(marshall, InsertObjectCommand.class);
        CustomPerson result = (CustomPerson)unmarshall.getObject();
        Assert.assertEquals((long)50L, (long)result.getAge());
    }
}

