/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.json.extension;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.kie.server.api.marshalling.json.JSONMarshaller;
import org.kie.server.api.marshalling.json.JSONMarshallerExtension;
import org.kie.server.api.marshalling.objects.CustomPerson;

public class JSONMarshallerExtensionCustomPerson
implements JSONMarshallerExtension {
    private static final CustomPersonDeser DESERIALIZER = new CustomPersonDeser();
    private static final CustomPersonSer SERIALIZER = new CustomPersonSer();

    public void extend(JSONMarshaller marshaller, ObjectMapper serializer, ObjectMapper deserializer) {
        this.registerModule(serializer);
        this.registerModule(deserializer);
    }

    private void registerModule(ObjectMapper objectMapper) {
        SimpleModule CustomPersonModule = new SimpleModule("custom-person-module", Version.unknownVersion());
        CustomPersonModule.addDeserializer(CustomPerson.class, (JsonDeserializer)DESERIALIZER);
        CustomPersonModule.addSerializer(CustomPerson.class, (JsonSerializer)SERIALIZER);
        objectMapper.registerModule((Module)CustomPersonModule);
    }

    private static class CustomPersonSer
    extends JsonSerializer<CustomPerson> {
        private CustomPersonSer() {
        }

        public void serialize(CustomPerson value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeRaw("{ \"name\" : \"John is CustomPerson\",  \"age\" : 20 }");
        }
    }

    private static class CustomPersonDeser
    extends JsonDeserializer<CustomPerson> {
        private CustomPersonDeser() {
        }

        public CustomPerson deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            CustomPerson customPerson = new CustomPerson("John", 50);
            return customPerson;
        }
    }
}

