/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.objects.Pojo1;
import org.kie.server.api.marshalling.objects.Pojo2;
import org.kie.server.api.marshalling.objects.Pojo3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarshallingRoundTripNestedClassesTest {
    private static final Logger logger = LoggerFactory.getLogger(MarshallingRoundTripNestedClassesTest.class);

    private static Pojo1 createTestObject() {
        Pojo3 pojo3 = new Pojo3("A");
        Pojo2 pojo2 = new Pojo2("B", true, pojo3);
        Pojo1 pojo1 = new Pojo1("C", pojo2);
        return pojo1;
    }

    private Set<Class<?>> getCustomClasses() {
        HashSet classes = new HashSet();
        classes.add(Pojo1.class);
        classes.add(Pojo2.class);
        classes.add(Pojo3.class);
        return classes;
    }

    @Test
    public void testJaxb() {
        Marshaller marshaller = MarshallerFactory.getMarshaller(this.getCustomClasses(), (MarshallingFormat)MarshallingFormat.JAXB, (ClassLoader)this.getClass().getClassLoader());
        this.verifyMarshallingRoundTrip(marshaller, MarshallingRoundTripNestedClassesTest.createTestObject());
    }

    @Test
    public void testXStream() {
        Marshaller marshaller = MarshallerFactory.getMarshaller(this.getCustomClasses(), (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        this.verifyMarshallingRoundTrip(marshaller, MarshallingRoundTripNestedClassesTest.createTestObject());
    }

    @Test
    public void testJSON() {
        Marshaller marshaller = MarshallerFactory.getMarshaller(this.getCustomClasses(), (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        this.verifyMarshallingRoundTrip(marshaller, MarshallingRoundTripNestedClassesTest.createTestObject());
    }

    private void verifyMarshallingRoundTrip(Marshaller marshaller, Object inputObject) {
        String rawContent = marshaller.marshall(inputObject);
        logger.debug(rawContent);
        Object testObjectAfterMarshallingTurnAround = marshaller.unmarshall(rawContent, inputObject.getClass());
        Assertions.assertThat((Object)testObjectAfterMarshallingTurnAround).isEqualTo(inputObject);
    }
}

