/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.BaseKieServicesClientTest;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesException;
import org.kie.server.client.impl.KieServicesClientImpl;

public class KieServicesClientErrorHandlingTest
extends BaseKieServicesClientTest {
    private static BaseMatcher<MarshallingException> serializationExceptionMatcher = new BaseMatcher<MarshallingException>(){

        public boolean matches(Object o) {
            return o instanceof MarshallingException;
        }

        public void describeTo(Description description) {
            description.appendText("SerializationException");
        }
    };
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void testError404Handling() {
        this.expectedEx.expect(KieServicesException.class);
        this.expectedEx.expectMessage("Error code: 404");
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(404).withBody("Resource not found!")));
        KieServicesClientImpl client = new KieServicesClientImpl(this.config);
        client.listContainers();
    }

    @Test
    public void testError500Handling() {
        this.expectedEx.expect(KieServicesException.class);
        this.expectedEx.expectMessage("Error code: 500");
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(500).withBody("Internal server error!")));
        KieServicesClientImpl client = new KieServicesClientImpl(this.config);
        client.listContainers();
    }

    @Test
    public void testXmlDeserializationErrorHandling() {
        this.expectedEx.expect(KieServicesException.class);
        this.expectedEx.expectCause(serializationExceptionMatcher);
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("Some gibberish that can't be parsed by client!")));
        KieServicesClientImpl client = new KieServicesClientImpl(this.config);
        client.listContainers();
    }

    @Test
    public void testJsonDeserializationErrorHandling() {
        this.expectedEx.expect(KieServicesException.class);
        this.expectedEx.expectCause(serializationExceptionMatcher);
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/json")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("Some gibberish that can't be parsed by client!")));
        KieServicesConfiguration configJSON = this.config.clone();
        configJSON.setMarshallingFormat(MarshallingFormat.JSON);
        KieServicesClientImpl client = new KieServicesClientImpl(configJSON);
        client.listContainers();
    }
}

