/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.instance.SolverInstance;
import org.kie.server.api.model.instance.SolverInstanceList;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.SolverServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class SolverServicesClientImpl
extends AbstractKieServicesClientImpl
implements SolverServicesClient {
    public SolverServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public SolverServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public ServiceResponse<SolverInstanceList> getSolvers(String containerId) {
        this.checkMandatoryParameter("ContainerID", containerId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId);
            return this.makeHttpGetRequestAndCreateServiceResponse(uri, SolverInstanceList.class);
        }
        throw new UnsupportedOperationException("JMS is not supported at the moment.");
    }

    @Override
    public ServiceResponse<SolverInstance> createSolver(String containerId, String solverId, SolverInstance instance) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId);
            return this.makeHttpPutRequestAndCreateServiceResponse(uri, instance, SolverInstance.class);
        }
        throw new UnsupportedOperationException("JMS is not supported at the moment.");
    }

    @Override
    public ServiceResponse<SolverInstance> getSolverState(String containerId, String solverId) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId);
            return this.makeHttpGetRequestAndCreateServiceResponse(uri, SolverInstance.class);
        }
        throw new UnsupportedOperationException("JMS is not supported at the moment.");
    }

    @Override
    public ServiceResponse<SolverInstance> getSolverBestSolution(String containerId, String solverId) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId) + "/bestsolution";
            return this.makeHttpGetRequestAndCreateServiceResponse(uri, SolverInstance.class);
        }
        throw new UnsupportedOperationException("JMS is not supported at the moment.");
    }

    @Override
    public ServiceResponse<SolverInstance> updateSolverState(String containerId, String solverId, SolverInstance instance) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId);
            return this.makeHttpPostRequestAndCreateServiceResponse(uri, instance, SolverInstance.class, this.getHeaders(instance));
        }
        throw new UnsupportedOperationException("JMS is not supported at the moment.");
    }

    @Override
    public ServiceResponse<Void> disposeSolver(String containerId, String solverId) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId);
            return this.makeHttpDeleteRequestAndCreateServiceResponse(uri, Void.class);
        }
        throw new UnsupportedOperationException("JMS is not supported at the moment.");
    }

    private String getURI(String containerId) {
        return (this.baseURI + "/" + "containers/{id}/solvers").replace("{id}", containerId);
    }

    private String getURI(String containerId, String solverId) {
        return (this.baseURI + "/" + "containers/{id}/solvers" + "/{solverId}").replace("{id}", containerId).replace("{solverId}", solverId);
    }

    private void checkMandatoryParameter(String parameterName, String parameter) {
        if (parameter == null || parameter.isEmpty()) {
            throw new IllegalArgumentException(parameterName + " can not be null or empty.");
        }
    }
}

