/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.balancer.impl;

import java.util.ArrayDeque;
import java.util.Collection;
import org.kie.server.client.balancer.impl.AbstractBalancerStrategy;

public class RoundRobinBalancerStrategy
extends AbstractBalancerStrategy {
    private ArrayDeque<String> availableEndpoints;

    public RoundRobinBalancerStrategy(ArrayDeque<String> availableEndpoints) {
        this.availableEndpoints = availableEndpoints;
    }

    public RoundRobinBalancerStrategy(Collection<String> availableEndpoints) {
        this.availableEndpoints = new ArrayDeque<String>(availableEndpoints);
    }

    @Override
    public String next() {
        this.checkEmpty(this.availableEndpoints);
        if (this.availableEndpoints.size() == 1) {
            return this.availableEndpoints.peekFirst();
        }
        return this.roundRobin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsOffline(String url) {
        ArrayDeque<String> arrayDeque = this.availableEndpoints;
        synchronized (arrayDeque) {
            this.availableEndpoints.remove(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsOnline(String url) {
        ArrayDeque<String> arrayDeque = this.availableEndpoints;
        synchronized (arrayDeque) {
            this.availableEndpoints.addLast(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String roundRobin() {
        ArrayDeque<String> arrayDeque = this.availableEndpoints;
        synchronized (arrayDeque) {
            String selected = this.availableEndpoints.pollFirst();
            this.availableEndpoints.addLast(selected);
            return selected;
        }
    }

    public String toString() {
        return "RoundRobinBalancerStrategy{availableEndpoints=" + this.availableEndpoints + '}';
    }
}

