/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.internal.process.CorrelationKey;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ItemList;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Wrapped;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.definition.QueryDefinition;
import org.kie.server.api.model.definition.QueryDefinitionList;
import org.kie.server.api.model.definition.QueryFilterSpec;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.model.instance.TaskInstanceList;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.api.model.instance.VariableInstance;
import org.kie.server.api.model.instance.VariableInstanceList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class QueryServicesClientImpl
extends AbstractKieServicesClientImpl
implements QueryServicesClient {
    public QueryServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public QueryServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public List<ProcessDefinition> findProcessesById(String processId) {
        ProcessDefinitionList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("pId", processId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/definitions/{pId}", valuesMap), ProcessDefinitionList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessesById", new Object[]{processId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessDefinitionList)response.getResult();
        }
        if (result != null && result.getProcesses() != null) {
            return Arrays.asList(result.getProcesses());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessDefinition> findProcesses(Integer page, Integer pageSize) {
        return this.findProcesses(page, pageSize, "", true);
    }

    @Override
    public List<ProcessDefinition> findProcesses(String filter, Integer page, Integer pageSize) {
        return this.findProcesses(filter, page, pageSize, "", true);
    }

    @Override
    public List<ProcessDefinition> findProcessesByContainerId(String containerId, Integer page, Integer pageSize) {
        return this.findProcessesByContainerId(containerId, page, pageSize, "", true);
    }

    @Override
    public ProcessDefinition findProcessByContainerIdProcessId(String containerId, String processId) {
        ProcessDefinition result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/containers/{id}/processes/definitions/{pId}", valuesMap), ProcessDefinition.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessesByDeploymentIdProcessId", new Object[]{containerId, processId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessDefinition)response.getResult();
        }
        return result;
    }

    @Override
    public List<ProcessDefinition> findProcesses(Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessDefinitionList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("?sort=" + sort + "&sortOrder=" + sortOrder, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/definitions", valuesMap) + queryString, ProcessDefinitionList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessesByFilter", new Object[]{"", page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessDefinitionList)response.getResult();
        }
        if (result != null && result.getProcesses() != null) {
            return Arrays.asList(result.getProcesses());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessDefinition> findProcesses(String filter, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessDefinitionList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("?filter=" + filter + "&sort=" + sort + "&sortOrder=" + sortOrder, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/definitions", valuesMap) + queryString, ProcessDefinitionList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessesByFilter", new Object[]{filter, page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessDefinitionList)response.getResult();
        }
        if (result != null && result.getProcesses() != null) {
            return Arrays.asList(result.getProcesses());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessDefinition> findProcessesByContainerId(String containerId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessDefinitionList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            String queryString = this.getPagingQueryString("?sort=" + sort + "&sortOrder=" + sortOrder, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/containers/{id}/processes/definitions", valuesMap) + queryString, ProcessDefinitionList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessesByDeploymentId", new Object[]{containerId, page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessDefinitionList)response.getResult();
        }
        if (result != null && result.getProcesses() != null) {
            return Arrays.asList(result.getProcesses());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstances(Integer page, Integer pageSize) {
        return this.findProcessInstances(page, pageSize, "", true);
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByCorrelationKey(CorrelationKey correlationKey, Integer page, Integer pageSize) {
        return this.findProcessInstancesByCorrelationKey(correlationKey, page, pageSize, "", true);
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByProcessId(String processId, List<Integer> status, Integer page, Integer pageSize) {
        return this.findProcessInstancesByProcessId(processId, status, page, pageSize, "", true);
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByProcessName(String processName, List<Integer> status, Integer page, Integer pageSize) {
        return this.findProcessInstancesByProcessName(processName, status, page, pageSize, "", true);
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByContainerId(String containerId, List<Integer> status, Integer page, Integer pageSize) {
        return this.findProcessInstancesByContainerId(containerId, status, page, pageSize, "", true);
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByStatus(List<Integer> status, Integer page, Integer pageSize) {
        return this.findProcessInstancesByStatus(status, page, pageSize, "", true);
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByInitiator(String initiator, List<Integer> status, Integer page, Integer pageSize) {
        return this.findProcessInstancesByInitiator(initiator, status, page, pageSize, "", true);
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByVariable(String variableName, List<Integer> status, Integer page, Integer pageSize) {
        return this.findProcessInstancesByVariable(variableName, status, page, pageSize, "", true);
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByVariableAndValue(String variableName, String variableValue, List<Integer> status, Integer page, Integer pageSize) {
        return this.findProcessInstancesByVariableAndValue(variableName, variableValue, status, page, pageSize, "", true);
    }

    @Override
    public List<ProcessInstance> findProcessInstances(Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("?sort=" + sort + "&sortOrder=" + sortOrder, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstances", new Object[]{new ArrayList(), "", "", page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByCorrelationKey(CorrelationKey correlationKey, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("correlationKey", correlationKey.toExternalForm());
            String queryString = this.getPagingQueryString("?sort=" + sort + "&sortOrder=" + sortOrder, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances/correlation/{correlationKey}", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstancesByCorrelationKey", new Object[]{correlationKey.toExternalForm(), page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByProcessId(String processId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("pId", processId);
            String statusQueryString = this.getAdditionalParams("?sort=" + sort + "&sortOrder=" + sortOrder, "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/{pId}/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstancesByProcessId", new Object[]{processId, this.safeList(status), "", page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByProcessName(String processName, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String statusQueryString = this.getAdditionalParams("?processName=" + processName + "&sort=" + sort + "&sortOrder=" + sortOrder, "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstances", new Object[]{this.safeList(status), "", processName, page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByContainerId(String containerId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            String statusQueryString = this.getAdditionalParams("?sort=" + sort + "&sortOrder=" + sortOrder, "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/containers/{id}/process/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstancesByDeploymentId", new Object[]{containerId, this.safeList(status), page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByStatus(List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String statusQueryString = this.getAdditionalParams("?sort=" + sort + "&sortOrder=" + sortOrder, "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstances", new Object[]{this.safeList(status), "", "", page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByInitiator(String initiator, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String statusQueryString = this.getAdditionalParams("?initiator=" + initiator + "&sort=" + sort + "&sortOrder=" + sortOrder, "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstances", new Object[]{this.safeList(status), initiator, "", page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByVariable(String variableName, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("varName", variableName);
            String statusQueryString = this.getAdditionalParams("?sort=" + sort + "&sortOrder=" + sortOrder, "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances/variables/{varName}", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceByVariables", new Object[]{variableName, "", this.safeList(status), page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByVariableAndValue(String variableName, String variableValue, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ProcessInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("varName", variableName);
            String statusQueryString = this.getAdditionalParams("?varValue=" + variableValue + "&sort=" + sort + "&sortOrder=" + sortOrder, "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances/variables/{varName}", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceByVariables", new Object[]{variableName, variableValue, this.safeList(status), page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstanceList)response.getResult();
        }
        if (result != null && result.getProcessInstances() != null) {
            return Arrays.asList(result.getProcessInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public ProcessInstance findProcessInstanceById(Long processInstanceId) {
        ProcessInstance result = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances/{pInstanceId}", valuesMap), ProcessInstance.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceById", new Object[]{processInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstance)response.getResult();
        }
        return result;
    }

    @Override
    public ProcessInstance findProcessInstanceById(Long processInstanceId, boolean withVars) {
        ProcessInstance result = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances/{pInstanceId}", valuesMap) + "?withVars=" + withVars, ProcessInstance.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceById", new Object[]{processInstanceId, withVars})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (ProcessInstance)response.getResult();
        }
        return result;
    }

    @Override
    public ProcessInstance findProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
        ProcessInstance result = null;
        if (!this.config.isRest()) {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceByCorrelationKey", new Object[]{correlationKey.toExternalForm()})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            return (ProcessInstance)response.getResult();
        }
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("correlationKey", correlationKey.toExternalForm());
        result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instance/correlation/{correlationKey}", valuesMap), ProcessInstance.class);
        return result;
    }

    @Override
    public NodeInstance findNodeInstanceByWorkItemId(Long processInstanceId, Long workItemId) {
        NodeInstance result = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            valuesMap.put("workItemId", workItemId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances/{pInstanceId}/wi-nodes/instances/{workItemId}", valuesMap), NodeInstance.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getNodeInstanceForWorkItem", new Object[]{processInstanceId, workItemId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (NodeInstance)response.getResult();
        }
        return result;
    }

    @Override
    public List<NodeInstance> findActiveNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
        NodeInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            String queryString = this.getPagingQueryString("?activeOnly=true", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances/{pInstanceId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceHistory", new Object[]{processInstanceId, true, false, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (NodeInstanceList)response.getResult();
        }
        if (result != null && result.getNodeInstances() != null) {
            return Arrays.asList(result.getNodeInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<NodeInstance> findCompletedNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
        NodeInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            String queryString = this.getPagingQueryString("?completedOnly=true", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances/{pInstanceId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceHistory", new Object[]{processInstanceId, false, true, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (NodeInstanceList)response.getResult();
        }
        if (result != null && result.getNodeInstances() != null) {
            return Arrays.asList(result.getNodeInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<NodeInstance> findNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
        NodeInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            String queryString = this.getPagingQueryString("", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances/{pInstanceId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getProcessInstanceHistory", new Object[]{processInstanceId, true, true, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (NodeInstanceList)response.getResult();
        }
        if (result != null && result.getNodeInstances() != null) {
            return Arrays.asList(result.getNodeInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<VariableInstance> findVariablesCurrentState(Long processInstanceId) {
        VariableInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances/{pInstanceId}/variables/instances", valuesMap), VariableInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getVariablesCurrentState", new Object[]{processInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (VariableInstanceList)response.getResult();
        }
        if (result != null && result.getVariableInstances() != null) {
            return Arrays.asList(result.getVariableInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public List<VariableInstance> findVariableHistory(Long processInstanceId, String variableName, Integer page, Integer pageSize) {
        VariableInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("pInstanceId", processInstanceId);
            valuesMap.put("varName", variableName);
            String queryString = this.getPagingQueryString("", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/processes/instances/{pInstanceId}/variables/instances/{varName}", valuesMap) + queryString, VariableInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryService", "getVariableHistory", new Object[]{processInstanceId, variableName, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (VariableInstanceList)response.getResult();
        }
        if (result != null && result.getVariableInstances() != null) {
            return Arrays.asList(result.getVariableInstances());
        }
        return Collections.emptyList();
    }

    @Override
    public void registerQuery(QueryDefinition queryDefinition) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("queryName", queryDefinition.getName());
            this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/definitions/{queryName}", valuesMap), queryDefinition, Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryDataService", "registerQuery", this.serialize(queryDefinition), this.marshaller.getFormat().getType(), new Object[]{queryDefinition.getName()})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void replaceQuery(QueryDefinition queryDefinition) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("queryName", queryDefinition.getName());
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/definitions/{queryName}", valuesMap), queryDefinition, Object.class, new HashMap<String, String>());
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryDataService", "replaceQuery", this.serialize(queryDefinition), this.marshaller.getFormat().getType(), new Object[]{queryDefinition.getName()})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void unregisterQuery(String queryName) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("queryName", queryName);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/definitions/{queryName}", valuesMap), null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryDataService", "unregisterQuery", new Object[]{queryName})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public QueryDefinition getQuery(String queryName) {
        QueryDefinition result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("queryName", queryName);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/definitions/{queryName}", valuesMap), QueryDefinition.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryDataService", "getQuery", new Object[]{queryName})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (QueryDefinition)response.getResult();
        }
        return result;
    }

    @Override
    public List<QueryDefinition> getQueries(Integer page, Integer pageSize) {
        QueryDefinitionList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/definitions", valuesMap) + queryString, QueryDefinitionList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryDataService", "getQueries", new Object[]{page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = (QueryDefinitionList)response.getResult();
        }
        if (result != null && result.getQueries() != null) {
            return Arrays.asList(result.getQueries());
        }
        return Collections.emptyList();
    }

    @Override
    public <T> List<T> query(String queryName, String mapper, String orderBy, Integer page, Integer pageSize, Class<T> resultType) {
        Object result = null;
        Class<?> resultTypeList = this.getResultTypeList(resultType);
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("queryName", queryName);
            String queryString = this.getPagingQueryString("?mapper=" + mapper + "&orderBy=" + orderBy, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/definitions/{queryName}/data", valuesMap) + queryString, resultTypeList);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryDataService", "query", new Object[]{queryName, mapper, orderBy, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = response.getResult();
        }
        if (result != null) {
            if (result instanceof ItemList) {
                return ((ItemList)result).getItems();
            }
            if (result instanceof List) {
                return (List)result;
            }
            if (result instanceof Wrapped) {
                return (List)((Wrapped)result).unwrap();
            }
        }
        return null;
    }

    @Override
    public <T> List<T> query(String queryName, String mapper, Integer page, Integer pageSize, Class<T> resultType) {
        return this.query(queryName, mapper, "", page, pageSize, resultType);
    }

    @Override
    public <T> List<T> query(String queryName, String mapper, QueryFilterSpec filterSpec, Integer page, Integer pageSize, Class<T> resultType) {
        Object result = null;
        Class<?> resultTypeList = this.getResultTypeList(resultType);
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("queryName", queryName);
            String queryString = this.getPagingQueryString("?mapper=" + mapper, page, pageSize);
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/definitions/{queryName}/filtered-data", valuesMap) + queryString, filterSpec, resultTypeList);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryDataService", "queryFiltered", this.serialize(filterSpec), this.marshaller.getFormat().getType(), new Object[]{queryName, mapper, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = response.getResult();
        }
        if (result != null) {
            if (result instanceof ItemList) {
                return ((ItemList)result).getItems();
            }
            if (result instanceof List) {
                return (List)result;
            }
            if (result instanceof Wrapped) {
                return (List)((Wrapped)result).unwrap();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public <T> List<T> query(String queryName, String mapper, String builder, Map<String, Object> parameters, Integer page, Integer pageSize, Class<T> resultType) {
        Object result = null;
        Class<?> resultTypeList = this.getResultTypeList(resultType);
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("queryName", queryName);
            String queryString = this.getPagingQueryString("?mapper=" + mapper + "&builder=" + builder, page, pageSize);
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/definitions/{queryName}/filtered-data", valuesMap) + queryString, parameters, resultTypeList);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("QueryDataService", "queryFilteredWithBuilder", this.serialize(this.safeMap(parameters)), this.marshaller.getFormat().getType(), new Object[]{queryName, mapper, builder, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            result = response.getResult();
        }
        if (result != null) {
            if (result instanceof ItemList) {
                return ((ItemList)result).getItems();
            }
            if (result instanceof List) {
                return (List)result;
            }
            if (result instanceof Wrapped) {
                return (List)((Wrapped)result).unwrap();
            }
        }
        return Collections.emptyList();
    }

    protected Class<?> getResultTypeList(Class<?> resultType) {
        if (TaskSummary.class.isAssignableFrom(resultType)) {
            return TaskSummaryList.class;
        }
        if (ProcessInstance.class.isAssignableFrom(resultType)) {
            return ProcessInstanceList.class;
        }
        if (TaskInstance.class.isAssignableFrom(resultType)) {
            return TaskInstanceList.class;
        }
        return Object.class;
    }
}

