/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.Collections;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.server.api.commands.CallContainerCommand;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.RuleServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleServicesClientImpl
extends AbstractKieServicesClientImpl
implements RuleServicesClient {
    private static final Logger logger = LoggerFactory.getLogger(RuleServicesClientImpl.class);

    public RuleServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public RuleServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public ServiceResponse<ExecutionResults> executeCommandsWithResults(String id, String payload) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.loadBalancer.getUrl() + "/containers/instances/" + id, payload, ExecutionResultImpl.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CallContainerCommand(id, payload)));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, null, null, id).getResponses().get(0);
        if (response.getResult() instanceof String) {
            response.setResult((Object)this.deserialize((String)response.getResult(), ExecutionResultImpl.class));
        }
        return response;
    }

    @Override
    public ServiceResponse<ExecutionResults> executeCommandsWithResults(String id, Command<?> cmd) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.loadBalancer.getUrl() + "/containers/instances/" + id, cmd, ExecutionResultImpl.class, this.getHeaders(cmd));
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CallContainerCommand(id, this.serialize(cmd))));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, cmd.getClass().getName(), null, id).getResponses().get(0);
        if (response.getResult() instanceof String) {
            response.setResult((Object)this.deserialize((String)response.getResult(), ExecutionResultImpl.class));
        }
        return response;
    }

    @Override
    @Deprecated
    public ServiceResponse<String> executeCommands(String id, String payload) {
        if (this.config.isRest()) {
            return this.makeBackwardCompatibleHttpPostRequestAndCreateServiceResponse(this.loadBalancer.getUrl() + "/containers/instances/" + id, payload, String.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CallContainerCommand(id, payload)));
        return (ServiceResponse)this.executeJmsCommand(script, null, null, id).getResponses().get(0);
    }

    @Override
    @Deprecated
    public ServiceResponse<String> executeCommands(String id, Command<?> cmd) {
        if (this.config.isRest()) {
            return this.makeBackwardCompatibleHttpPostRequestAndCreateServiceResponse(this.loadBalancer.getUrl() + "/containers/instances/" + id, cmd, String.class, this.getHeaders(cmd));
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CallContainerCommand(id, this.serialize(cmd))));
        return (ServiceResponse)this.executeJmsCommand(script, cmd.getClass().getName(), null, id).getResponses().get(0);
    }
}

