/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.Collections;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.optaplanner.CreateSolverCommand;
import org.kie.server.api.commands.optaplanner.DisposeSolverCommand;
import org.kie.server.api.commands.optaplanner.GetBestSolutionCommand;
import org.kie.server.api.commands.optaplanner.GetSolverStateCommand;
import org.kie.server.api.commands.optaplanner.GetSolversCommand;
import org.kie.server.api.commands.optaplanner.UpdateSolverStateCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.instance.SolverInstance;
import org.kie.server.api.model.instance.SolverInstanceList;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesException;
import org.kie.server.client.SolverServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class SolverServicesClientImpl
extends AbstractKieServicesClientImpl
implements SolverServicesClient {
    public SolverServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public SolverServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public ServiceResponse<SolverInstanceList> getSolvers(String containerId) {
        this.checkMandatoryParameter("ContainerID", containerId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId);
            return this.makeHttpGetRequestAndCreateServiceResponse(uri, SolverInstanceList.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetSolversCommand(containerId)));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, GetSolversCommand.class.getName(), "BRP", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        return response;
    }

    @Override
    public ServiceResponse<SolverInstance> createSolver(String containerId, String solverId, String configFile) {
        this.checkMandatoryParameter("ContainerId", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        this.checkMandatoryParameter("ConfigFile", configFile);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId);
            SolverInstance instance = new SolverInstance();
            instance.setSolverConfigFile(configFile);
            instance.setContainerId(containerId);
            instance.setSolverId(solverId);
            return this.makeHttpPutRequestAndCreateServiceResponse(uri, instance, SolverInstance.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CreateSolverCommand(containerId, solverId, configFile)));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, CreateSolverCommand.class.getName(), "BRP", containerId).getResponses().get(0);
        return response;
    }

    @Override
    public ServiceResponse<SolverInstance> getSolverState(String containerId, String solverId) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId);
            return this.makeHttpGetRequestAndCreateServiceResponse(uri, SolverInstance.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetSolverStateCommand(containerId, solverId)));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, GetSolverStateCommand.class.getName(), "BRP", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        return response;
    }

    @Override
    public ServiceResponse<SolverInstance> getSolverBestSolution(String containerId, String solverId) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId) + "/bestsolution";
            return this.makeHttpGetRequestAndCreateServiceResponse(uri, SolverInstance.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetBestSolutionCommand(containerId, solverId)));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, GetBestSolutionCommand.class.getName(), "BRP", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        return response;
    }

    @Override
    public ServiceResponse<SolverInstance> updateSolverState(String containerId, String solverId, SolverInstance instance) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        this.checkMandatoryParameter("instance", instance);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId);
            return this.makeHttpPostRequestAndCreateServiceResponse(uri, instance, SolverInstance.class, this.getHeaders(instance));
        }
        instance.setContainerId(containerId);
        instance.setSolverId(solverId);
        CommandScript script = new CommandScript(Collections.singletonList(new UpdateSolverStateCommand(containerId, solverId, this.serialize(instance))));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, UpdateSolverStateCommand.class.getName(), "BRP", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        return response;
    }

    @Override
    public ServiceResponse<Void> disposeSolver(String containerId, String solverId) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId);
            return this.makeHttpDeleteRequestAndCreateCustomResponse(uri, ServiceResponse.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DisposeSolverCommand(containerId, solverId)));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DisposeSolverCommand.class.getName(), "BRP", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        return response;
    }

    private String getURI(String containerId) {
        return (this.loadBalancer.getUrl() + "/" + "containers/{id}/solvers").replace("{id}", containerId);
    }

    private String getURI(String containerId, String solverId) {
        return (this.loadBalancer.getUrl() + "/" + "containers/{id}/solvers" + "/{solverId}").replace("{id}", containerId).replace("{solverId}", solverId);
    }

    private void checkMandatoryParameter(String parameterName, Object parameter) {
        if (parameter == null || parameter instanceof String && ((String)parameter).isEmpty()) {
            throw new IllegalArgumentException(parameterName + " can not be null or empty.");
        }
    }

    @Override
    protected void throwExceptionOnFailure(ServiceResponse<?> serviceResponse) {
        if (serviceResponse != null && ServiceResponse.ResponseType.FAILURE.equals((Object)serviceResponse.getType())) {
            throw new KieServicesException(serviceResponse.getMsg());
        }
    }
}

