/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.Collections;
import java.util.HashMap;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.UIServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class UIServicesClientImpl
extends AbstractKieServicesClientImpl
implements UIServicesClient {
    public UIServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public UIServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public String getProcessForm(String containerId, String processId, String language) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/forms/processes/{pId}", valuesMap) + "?lang=" + language + "&filter=true");
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("FormService", "getFormDisplayProcess", new Object[]{containerId, processId, language, true})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        return (String)response.getResult();
    }

    @Override
    public String getProcessForm(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/forms/processes/{pId}", valuesMap) + "?filter=false");
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("FormService", "getFormDisplayProcess", new Object[]{containerId, processId, "", false})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        return (String)response.getResult();
    }

    @Override
    public String getTaskForm(String containerId, Long taskId, String language) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/forms/tasks/{tInstanceId}", valuesMap) + "?lang=" + language + "&filter=true");
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("FormService", "getFormDisplayTask", new Object[]{taskId, language, true})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        return (String)response.getResult();
    }

    @Override
    public String getTaskForm(String containerId, Long taskId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/forms/tasks/{tInstanceId}", valuesMap) + "?filter=false");
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("FormService", "getFormDisplayTask", new Object[]{taskId, "", false})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        return (String)response.getResult();
    }

    @Override
    public String getProcessImage(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/svg+xml");
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/images/processes/{pId}", valuesMap), headers);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ImageService", "getProcessImage", new Object[]{containerId, processId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        return (String)response.getResult();
    }

    @Override
    public String getProcessInstanceImage(String containerId, Long processInstanceId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("pInstanceId", processInstanceId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/svg+xml");
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/images/processes/instances/{pInstanceId}", valuesMap), headers);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ImageService", "getActiveProcessImage", new Object[]{containerId, processInstanceId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        return (String)response.getResult();
    }
}

