/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.BaseKieServicesClientTest;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.balancer.BalancerStrategy;
import org.kie.server.client.balancer.LoadBalancer;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;
import org.kie.server.common.rest.KieServerHttpRequestException;

public class LoadBalancerClientTest {
    private String mockServerBaseUri1;
    private String mockServerBaseUri2;
    private String mockServerBaseUri3;
    private WireMockServer wireMockServer1;
    private WireMockServer wireMockServer2;
    private WireMockServer wireMockServer3;
    private KieServicesConfiguration config;

    protected WireMockServer createMockServer(String version, int port) {
        WireMockServer wireMockServer = new WireMockServer(port);
        wireMockServer.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>" + version + "</version>\n  </kie-server-info>\n</response>")));
        return wireMockServer;
    }

    @Before
    public void startServers() {
        int port1 = BaseKieServicesClientTest.findFreePort();
        this.wireMockServer1 = this.createMockServer("1", port1);
        this.wireMockServer1.start();
        int port2 = BaseKieServicesClientTest.findFreePort();
        this.wireMockServer2 = this.createMockServer("2", port2);
        this.wireMockServer2.start();
        int port3 = BaseKieServicesClientTest.findFreePort();
        this.wireMockServer3 = this.createMockServer("3", port3);
        this.wireMockServer3.start();
        this.mockServerBaseUri1 = "http://localhost:" + port1;
        this.mockServerBaseUri2 = "http://localhost:" + port2;
        this.mockServerBaseUri3 = "http://localhost:" + port3;
        String mockServerBaseUri3Duplicated = "http://localhost:" + port3;
        this.config = KieServicesFactory.newRestConfiguration((String)(this.mockServerBaseUri1 + "|" + this.mockServerBaseUri2 + "|" + this.mockServerBaseUri3 + "|" + mockServerBaseUri3Duplicated), null, null);
        this.config.setCapabilities(Arrays.asList("KieServer"));
    }

    @After
    public void stopServers() {
        this.wireMockServer1.stop();
        this.wireMockServer2.stop();
        this.wireMockServer3.stop();
    }

    @Test
    public void testCloneConfigurationWithLoadBalancer() {
        KieServicesConfiguration cloned = this.config.clone();
        Assert.assertNotNull((Object)cloned);
        Assert.assertNull((Object)cloned.getLoadBalancer());
        cloned.setLoadBalancer(LoadBalancer.getDefault((String)"test url"));
        KieServicesConfiguration cloneOfCloned = cloned.clone();
        Assert.assertNotNull((Object)cloned);
        Assert.assertNotNull((Object)cloned.getLoadBalancer());
        Assert.assertEquals((Object)cloned.getLoadBalancer(), (Object)cloneOfCloned.getLoadBalancer());
    }

    @Test
    public void testDefaultLoadBalancer() {
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        List available = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getAvailableEndpoints();
        Assert.assertNotNull((Object)available);
        Assert.assertEquals((long)3L, (long)available.size());
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"1", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"2", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"3", (Object)((KieServerInfo)response.getResult()).getVersion());
    }

    @Test
    public void testRandomLoadBalancer() {
        this.config.setLoadBalancer(LoadBalancer.forStrategy((String)this.config.getServerUrl(), (BalancerStrategy.Type)BalancerStrategy.Type.RANDOM_STRATEGY));
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        List available = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getAvailableEndpoints();
        Assert.assertNotNull((Object)available);
        Assert.assertEquals((long)3L, (long)available.size());
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        response = client.getServerInfo();
        this.assertSuccess(response);
        response = client.getServerInfo();
        this.assertSuccess(response);
    }

    @Test
    public void testDefaultLoadBalancerUnavailableServer() throws Exception {
        this.wireMockServer1.stop();
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"2", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"3", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"2", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"3", (Object)((KieServerInfo)response.getResult()).getVersion());
        List available = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getAvailableEndpoints();
        Assert.assertNotNull((Object)available);
        Assert.assertEquals((long)2L, (long)available.size());
        this.wireMockServer1.start();
        Future waitForResult = ((AbstractKieServicesClientImpl)client).getLoadBalancer().checkFailedEndpoints();
        waitForResult.get(5L, TimeUnit.SECONDS);
        available = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getAvailableEndpoints();
        Assert.assertNotNull((Object)available);
        Assert.assertEquals((long)3L, (long)available.size());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"2", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"3", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"1", (Object)((KieServerInfo)response.getResult()).getVersion());
    }

    @Test
    public void testDefaultLoadBalancerNoServersAvailable() throws Exception {
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"1", (Object)((KieServerInfo)response.getResult()).getVersion());
        this.wireMockServer1.stop();
        this.wireMockServer2.stop();
        this.wireMockServer3.stop();
        try {
            client.getServerInfo();
            Assert.fail((String)"No servers available as all of them were stopped");
        }
        catch (KieServerHttpRequestException e) {
            Assert.assertEquals((Object)"No available endpoints found", (Object)e.getMessage());
        }
        this.wireMockServer1.start();
        try {
            client.getServerInfo();
            Assert.fail((String)"No servers available even though one was started as load balancer was not refreshed");
        }
        catch (KieServerHttpRequestException e) {
            Assert.assertEquals((Object)"No available endpoints found", (Object)e.getMessage());
        }
        Future waitForResult = ((AbstractKieServicesClientImpl)client).getLoadBalancer().checkFailedEndpoints();
        waitForResult.get(5L, TimeUnit.SECONDS);
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"1", (Object)((KieServerInfo)response.getResult()).getVersion());
    }

    @Test
    public void testDefaultLoadBalancerNotValidHost() throws Exception {
        this.config = KieServicesFactory.newRestConfiguration((String)"http://not-existing-host.com:8080/server", null, null);
        this.config.setCapabilities(Arrays.asList("KieServer"));
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        try {
            client.getServerInfo();
            Assert.fail((String)"There is no valid kie server url");
        }
        catch (KieServerHttpRequestException kieServerHttpRequestException) {
            // empty catch block
        }
        List failed = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getFailedEndpoints();
        Assert.assertEquals((long)1L, (long)failed.size());
        ((AbstractKieServicesClientImpl)client).getLoadBalancer().activate(this.mockServerBaseUri1);
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"1", (Object)((KieServerInfo)response.getResult()).getVersion());
    }

    private void assertSuccess(ServiceResponse<?> response) {
        Assert.assertEquals((String)"Response type", (Object)ServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
    }
}

