/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerStateInfo;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.BaseKieServicesClientTest;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.balancer.BalancerStrategy;
import org.kie.server.client.balancer.LoadBalancer;
import org.kie.server.client.balancer.impl.RoundRobinBalancerStrategy;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;
import org.kie.server.common.rest.KieServerHttpRequestException;
import org.kie.server.common.rest.NoEndpointFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerClientTest {
    private String mockServerBaseUri1;
    private String mockServerBaseUri2;
    private String mockServerBaseUri3;
    private WireMockServer wireMockServer1;
    private WireMockServer wireMockServer2;
    private WireMockServer wireMockServer3;
    private KieServicesConfiguration config;
    private static final Logger logger = LoggerFactory.getLogger(LoadBalancerClientTest.class);

    protected WireMockServer createMockServer(String version, int port) {
        WireMockServer wireMockServer = new WireMockServer(port);
        wireMockServer.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>" + version + "</version>\n  </kie-server-info>\n</response>")));
        wireMockServer.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/state")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server state\">\n  <kie-server-state-info>\n    <version>" + version + "</version>\n  </kie-server-state-info>\n</response>")));
        return wireMockServer;
    }

    @Before
    public void startServers() {
        int port1 = BaseKieServicesClientTest.findFreePort();
        this.wireMockServer1 = this.createMockServer("1", port1);
        this.wireMockServer1.start();
        int port2 = BaseKieServicesClientTest.findFreePort();
        this.wireMockServer2 = this.createMockServer("2", port2);
        this.wireMockServer2.start();
        int port3 = BaseKieServicesClientTest.findFreePort();
        this.wireMockServer3 = this.createMockServer("3", port3);
        this.wireMockServer3.start();
        this.mockServerBaseUri1 = "http://localhost:" + port1;
        this.mockServerBaseUri2 = "http://localhost:" + port2;
        this.mockServerBaseUri3 = "http://localhost:" + port3;
        String mockServerBaseUri3Duplicated = "http://localhost:" + port3;
        this.config = KieServicesFactory.newRestConfiguration((String)(this.mockServerBaseUri1 + "|" + this.mockServerBaseUri2 + "|" + this.mockServerBaseUri3 + "|" + mockServerBaseUri3Duplicated), null, null);
        this.config.setCapabilities(Arrays.asList("KieServer"));
    }

    @After
    public void stopServers() {
        this.wireMockServer1.stop();
        this.wireMockServer2.stop();
        this.wireMockServer3.stop();
    }

    @Test
    public void testCloneConfigurationWithLoadBalancer() {
        KieServicesConfiguration cloned = this.config.clone();
        Assert.assertNotNull((Object)cloned);
        Assert.assertNull((Object)cloned.getLoadBalancer());
        cloned.setLoadBalancer(LoadBalancer.getDefault((String)"test url"));
        KieServicesConfiguration cloneOfCloned = cloned.clone();
        Assert.assertNotNull((Object)cloned);
        Assert.assertNotNull((Object)cloned.getLoadBalancer());
        Assert.assertEquals((Object)cloned.getLoadBalancer(), (Object)cloneOfCloned.getLoadBalancer());
    }

    @Test
    public void testDefaultLoadBalancer() {
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        List available = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getAvailableEndpoints();
        Assert.assertNotNull((Object)available);
        Assert.assertEquals((long)3L, (long)available.size());
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"1", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"2", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"3", (Object)((KieServerInfo)response.getResult()).getVersion());
    }

    @Test
    public void testRandomLoadBalancer() {
        this.config.setLoadBalancer(LoadBalancer.forStrategy((String)this.config.getServerUrl(), (BalancerStrategy.Type)BalancerStrategy.Type.RANDOM_STRATEGY));
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        List available = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getAvailableEndpoints();
        Assert.assertNotNull((Object)available);
        Assert.assertEquals((long)3L, (long)available.size());
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        response = client.getServerInfo();
        this.assertSuccess(response);
        response = client.getServerInfo();
        this.assertSuccess(response);
    }

    @Test
    public void testDefaultLoadBalancerUnavailableServer() throws Exception {
        this.wireMockServer1.stop();
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"2", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"3", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"2", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"3", (Object)((KieServerInfo)response.getResult()).getVersion());
        List available = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getAvailableEndpoints();
        Assert.assertNotNull((Object)available);
        Assert.assertEquals((long)2L, (long)available.size());
        this.wireMockServer1.start();
        Future waitForResult = ((AbstractKieServicesClientImpl)client).getLoadBalancer().checkFailedEndpoints();
        waitForResult.get(5L, TimeUnit.SECONDS);
        available = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getAvailableEndpoints();
        Assert.assertNotNull((Object)available);
        Assert.assertEquals((long)3L, (long)available.size());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"2", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"3", (Object)((KieServerInfo)response.getResult()).getVersion());
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"1", (Object)((KieServerInfo)response.getResult()).getVersion());
    }

    @Test
    public void testDefaultLoadBalancerNoServersAvailable() throws Exception {
        final ArrayList checkFailedEndpointsJob = new ArrayList();
        this.config.setLoadBalancer(new LoadBalancer((BalancerStrategy)new RoundRobinBalancerStrategy(Arrays.asList(this.config.getServerUrl().split("\\|")))){

            public Future<?> checkFailedEndpoints() {
                Future future = super.checkFailedEndpoints();
                checkFailedEndpointsJob.add(future);
                return future;
            }
        });
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"1", (Object)((KieServerInfo)response.getResult()).getVersion());
        this.wireMockServer1.stop();
        this.wireMockServer2.stop();
        this.wireMockServer3.stop();
        try {
            client.getServerInfo();
            Assert.fail((String)"No servers available as all of them were stopped");
        }
        catch (KieServerHttpRequestException e) {
            Assert.assertEquals((Object)"No available endpoints found", (Object)e.getMessage());
        }
        this.wireMockServer1.start();
        try {
            client.getServerInfo();
            Assert.fail((String)"No servers available even though one was started as load balancer was not refreshed");
        }
        catch (KieServerHttpRequestException e) {
            Assert.assertEquals((Object)"No available endpoints found", (Object)e.getMessage());
        }
        Assert.assertEquals((long)2L, (long)checkFailedEndpointsJob.size());
        Future waitingForJobsToComplete = (Future)checkFailedEndpointsJob.get(1);
        waitingForJobsToComplete.get(5L, TimeUnit.SECONDS);
        response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"1", (Object)((KieServerInfo)response.getResult()).getVersion());
    }

    @Test
    public void testDefaultLoadBalancerNotValidHost() throws Exception {
        this.config = KieServicesFactory.newRestConfiguration((String)"http://not-existing-host.com:8080/server", null, null);
        this.config.setCapabilities(Arrays.asList("KieServer"));
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        try {
            client.getServerInfo();
            Assert.fail((String)"There is no valid kie server url");
        }
        catch (KieServerHttpRequestException kieServerHttpRequestException) {
            // empty catch block
        }
        List failed = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getFailedEndpoints();
        Assert.assertEquals((long)1L, (long)failed.size());
        ((AbstractKieServicesClientImpl)client).getLoadBalancer().activate(this.mockServerBaseUri1);
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)"1", (Object)((KieServerInfo)response.getResult()).getVersion());
    }

    @Test
    public void testMultipleConcurrentFailRequestsForLoadBalancerWithSingleServer() throws Exception {
        this.config = KieServicesFactory.newRestConfiguration((String)this.mockServerBaseUri1, null, null);
        this.config.setCapabilities(Arrays.asList("KieServer"));
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        ServiceResponse response = client.getServerState();
        this.assertSuccess(response);
        Assertions.assertThat((Iterable)((KieServerStateInfo)response.getResult()).getContainers()).isEmpty();
        this.wireMockServer1.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/state")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).inScenario("Timeout Fails followed by Scan Success").whenScenarioStateIs("Started").willReturn(WireMock.aResponse().withFixedDelay(Integer.valueOf(5100)).withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server state\">\n  <kie-server-state-info>\n    <version>1a</version>\n  </kie-server-state-info>\n</response>")).willSetStateTo("Req Timeout 1"));
        this.wireMockServer1.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/state")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).inScenario("Timeout Fails followed by Scan Success").whenScenarioStateIs("Req Timeout 1").willReturn(WireMock.aResponse().withFixedDelay(Integer.valueOf(5100)).withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server state\">\n  <kie-server-state-info>\n    <version>1b</version>\n  </kie-server-state-info>\n</response>")).willSetStateTo("Req Timeout 2"));
        this.wireMockServer1.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).inScenario("Timeout Fails followed by Scan Success").whenScenarioStateIs("Req Timeout 2").willReturn(WireMock.aResponse().withFixedDelay(Integer.valueOf(500)).withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>background scan</version>\n  </kie-server-info>\n</response>")).willSetStateTo("Good Req 1"));
        this.wireMockServer1.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/state")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).inScenario("Timeout Fails followed by Scan Success").whenScenarioStateIs("Good Req 1").willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server state\">\n  <kie-server-state-info>\n    <version>1c</version>\n  </kie-server-state-info>\n</response>")).willSetStateTo("Good Req 2"));
        int threadCount = 2;
        logger.debug("Starting 2 Threads");
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch stopLatch = new CountDownLatch(threadCount);
        for (int i = 1; i <= threadCount; ++i) {
            class SendKieRequestThread
            extends Thread {
                CountDownLatch startLatch;
                CountDownLatch stopLatch;
                int threadNo;
                KieServicesClient kieClient;

                SendKieRequestThread(int threadNo, CountDownLatch startLatch, CountDownLatch stopLatch, KieServicesClient client) {
                    this.startLatch = startLatch;
                    this.stopLatch = stopLatch;
                    this.threadNo = threadNo;
                    this.kieClient = client;
                }

                @Override
                public void run() {
                    try {
                        this.startLatch.await();
                        logger.debug("Th#" + this.threadNo + " Calling Kie Server ");
                        Thread.sleep(20 * this.threadNo);
                        try {
                            ServiceResponse response = this.kieClient.getServerState();
                            Assert.fail((String)"Unexpected successful request");
                        }
                        catch (NoEndpointFoundException response) {
                            // empty catch block
                        }
                    }
                    catch (Exception e) {
                        logger.debug("Exception while calling kie Server: " + e);
                    }
                    finally {
                        logger.debug("Th#" + this.threadNo + " Done.");
                        this.stopLatch.countDown();
                    }
                }
            }
            new SendKieRequestThread(i, startLatch, stopLatch, client).start();
        }
        startLatch.countDown();
        stopLatch.await(7L, TimeUnit.SECONDS);
        logger.debug("\nEnd of Threads - ");
        logger.debug("\nSleeping for 3 seconds - ");
        Thread.sleep(3000L);
        List availableList = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getAvailableEndpoints();
        availableList.forEach(item -> logger.debug("Available Endpoint : [" + item + "]"));
        List failedList = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getFailedEndpoints();
        failedList.forEach(item -> logger.debug("Failed Endpoint : [" + item + "]"));
        this.wireMockServer1.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/state")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).inScenario("Brief Timeout Fails followed by Scan Success").willReturn(WireMock.aResponse().withFixedDelay(Integer.valueOf(5100)).withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server state\">\n  <kie-server-state-info>\n    <version>1d</version>\n  </kie-server-state-info>\n</response>")).willSetStateTo("After Failed Req"));
        this.wireMockServer1.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/state")).inScenario("Brief Timeout Fails followed by Scan Success").whenScenarioStateIs("After Failed Req").willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server state\">\n  <kie-server-state-info>\n    <version>1e</version>\n  </kie-server-state-info>\n</response>")).willSetStateTo("After success 1"));
        this.wireMockServer1.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).inScenario("Brief Timeout Fails followed by Scan Success").whenScenarioStateIs("After success 1").willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>background scan</version>\n  </kie-server-info>\n</response>")).willSetStateTo("After success 2"));
        logger.debug(" Current wireMockServer1 stub count =" + this.wireMockServer1.listAllStubMappings().getMappings().size());
        try {
            response = client.getServerState();
            Assert.fail((String)"Unexpected successful request");
        }
        catch (NoEndpointFoundException noEndpointFoundException) {
            // empty catch block
        }
        availableList = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getAvailableEndpoints();
        availableList.forEach(item -> logger.debug("Available Endpoint : [" + item + "]"));
        failedList = ((AbstractKieServicesClientImpl)client).getLoadBalancer().getFailedEndpoints();
        if (failedList.isEmpty()) {
            logger.debug("Failed Endpoint : []");
        } else {
            failedList.forEach(item -> logger.debug("Failed Endpoint : [" + item + "]"));
        }
        Thread.sleep(1000L);
        this.wireMockServer1.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/state")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server state\">\n  <kie-server-state-info>\n    <version>1b</version>\n  </kie-server-state-info>\n</response>")));
        response = client.getServerState();
        this.assertSuccess(response);
        Assertions.assertThat((Iterable)((KieServerStateInfo)response.getResult()).getContainers()).isEmpty();
    }

    @Test
    public void testDefaultLoadBalancerFirstServerNotAvailable() throws Exception {
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        this.wireMockServer1.stop();
        ServiceResponse response = client.getServerState();
        this.assertSuccess(response);
        Assertions.assertThat((Iterable)((KieServerStateInfo)response.getResult()).getContainers()).isEmpty();
    }

    private void assertSuccess(ServiceResponse<?> response) {
        Assert.assertEquals((String)"Response type", (Object)KieServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
    }
}

