/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.optaplanner.AddProblemFactChangeCommand;
import org.kie.server.api.commands.optaplanner.AddProblemFactChangesCommand;
import org.kie.server.api.commands.optaplanner.CreateSolverCommand;
import org.kie.server.api.commands.optaplanner.DisposeSolverCommand;
import org.kie.server.api.commands.optaplanner.GetSolverCommand;
import org.kie.server.api.commands.optaplanner.GetSolverWithBestSolutionCommand;
import org.kie.server.api.commands.optaplanner.GetSolversCommand;
import org.kie.server.api.commands.optaplanner.IsEveryProblemFactChangeProcessedCommand;
import org.kie.server.api.commands.optaplanner.SolvePlanningProblemCommand;
import org.kie.server.api.commands.optaplanner.TerminateSolverEarlyCommand;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.instance.SolverInstance;
import org.kie.server.api.model.instance.SolverInstanceList;
import org.kie.server.api.model.type.JaxbBoolean;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.SolverServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;
import org.optaplanner.core.impl.solver.ProblemFactChange;

public class SolverServicesClientImpl
extends AbstractKieServicesClientImpl
implements SolverServicesClient {
    public SolverServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public SolverServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public List<SolverInstance> getSolvers(String containerId) {
        SolverInstanceList solverInstanceList;
        this.checkMandatoryParameter("ContainerID", containerId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId);
            solverInstanceList = this.makeHttpGetRequestAndCreateCustomResponse(uri, SolverInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new GetSolversCommand(containerId)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, GetSolversCommand.class.getName(), "BRP", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            solverInstanceList = (SolverInstanceList)response.getResult();
        }
        if (solverInstanceList != null && solverInstanceList.getContainers() != null) {
            return new ArrayList<SolverInstance>(solverInstanceList.getContainers());
        }
        return Collections.emptyList();
    }

    @Override
    public SolverInstance createSolver(String containerId, String solverId, String configFile) {
        this.checkMandatoryParameter("ContainerId", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        this.checkMandatoryParameter("ConfigFile", configFile);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId);
            SolverInstance instance = new SolverInstance();
            instance.setSolverConfigFile(configFile);
            instance.setContainerId(containerId);
            instance.setSolverId(solverId);
            return this.makeHttpPutRequestAndCreateCustomResponse(uri, instance, SolverInstance.class, Collections.emptyMap());
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CreateSolverCommand(containerId, solverId, configFile)));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, CreateSolverCommand.class.getName(), "BRP", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (SolverInstance)response.getResult();
    }

    @Override
    public SolverInstance getSolver(String containerId, String solverId) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId);
            return this.makeHttpGetRequestAndCreateCustomResponse(uri, SolverInstance.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetSolverCommand(containerId, solverId)));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, GetSolverCommand.class.getName(), "BRP", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (SolverInstance)response.getResult();
    }

    @Override
    public SolverInstance getSolverWithBestSolution(String containerId, String solverId) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId) + "/" + "bestsolution";
            return this.makeHttpGetRequestAndCreateCustomResponse(uri, SolverInstance.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetSolverWithBestSolutionCommand(containerId, solverId)));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, GetSolverWithBestSolutionCommand.class.getName(), "BRP", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (SolverInstance)response.getResult();
    }

    @Override
    public void solvePlanningProblem(String containerId, String solverId, Object planningProblem) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        this.checkMandatoryParameter("planningSolution", planningProblem);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId) + "/" + "state/solving";
            this.makeHttpPostRequestAndCreateCustomResponse(uri, planningProblem, ServiceResponse.class, this.getHeaders(planningProblem));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new SolvePlanningProblemCommand(containerId, solverId, this.serialize(planningProblem))));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, SolvePlanningProblemCommand.class.getName(), "BRP", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void terminateSolverEarly(String containerId, String solverId) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId) + "/" + "state/terminating-early";
            this.makeHttpPostRequestAndCreateCustomResponse(uri, "", ServiceResponse.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new TerminateSolverEarlyCommand(containerId, solverId)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, TerminateSolverEarlyCommand.class.getName(), "BRP", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void addProblemFactChange(String containerId, String solverId, ProblemFactChange problemFactChange) {
        this.checkMandatoryParameter("containerId", containerId);
        this.checkMandatoryParameter("solverId", solverId);
        this.checkMandatoryParameter("problemFactChange", problemFactChange);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId) + "/" + "problemfactchanges";
            this.makeHttpPostRequestAndCreateCustomResponse(uri, problemFactChange, ServiceResponse.class, this.getHeaders(problemFactChange));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new AddProblemFactChangeCommand(containerId, solverId, problemFactChange)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, AddProblemFactChangeCommand.class.getName(), "BRP", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void addProblemFactChanges(String containerId, String solverId, List<ProblemFactChange> problemFactChanges) {
        this.checkMandatoryParameter("containerId", containerId);
        this.checkMandatoryParameter("solverId", solverId);
        this.checkMandatoryParameter("problemFactChange", problemFactChanges);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId) + "/" + "problemfactchanges";
            this.makeHttpPostRequestAndCreateCustomResponse(uri, problemFactChanges, ServiceResponse.class, this.getHeaders(problemFactChanges));
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new AddProblemFactChangesCommand(containerId, solverId, problemFactChanges)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, AddProblemFactChangeCommand.class.getName(), "BRP", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public Boolean isEveryProblemFactChangeProcessed(String containerId, String solverId) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        Object result = null;
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId) + "/" + "problemfactchanges/processed";
            result = this.makeHttpGetRequestAndCreateCustomResponse(uri, Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new IsEveryProblemFactChangeProcessedCommand(containerId, solverId)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, IsEveryProblemFactChangeProcessedCommand.class.getName(), "BRP", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = response.getResult();
        }
        if (result instanceof JaxbBoolean) {
            return ((JaxbBoolean)result).unwrap();
        }
        return (Boolean)result;
    }

    @Override
    public void disposeSolver(String containerId, String solverId) {
        this.checkMandatoryParameter("ContainerID", containerId);
        this.checkMandatoryParameter("SolverId", solverId);
        if (this.config.isRest()) {
            String uri = this.getURI(containerId, solverId);
            this.makeHttpDeleteRequestAndCreateCustomResponse(uri, ServiceResponse.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DisposeSolverCommand(containerId, solverId)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DisposeSolverCommand.class.getName(), "BRP", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    private String getURI(String containerId) {
        return (this.loadBalancer.getUrl() + "/" + "containers/{id}/solvers").replace("{id}", containerId);
    }

    private String getURI(String containerId, String solverId) {
        return (this.loadBalancer.getUrl() + "/" + "containers/{id}/solvers" + "/" + "{solverId}").replace("{id}", containerId).replace("{solverId}", solverId);
    }

    private void checkMandatoryParameter(String parameterName, Object parameter) {
        if (parameter == null || parameter instanceof String && ((String)parameter).isEmpty()) {
            throw new IllegalArgumentException(parameterName + " can not be null or empty.");
        }
    }

    @Override
    protected void throwExceptionOnFailure(ServiceResponse<?> serviceResponse) {
        if (serviceResponse != null && ServiceResponse.ResponseType.FAILURE.equals((Object)serviceResponse.getType())) {
            throw new KieServicesException(serviceResponse.getMsg());
        }
    }
}

