/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.balancer.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kie.server.client.balancer.impl.AbstractBalancerStrategy;

public class RoundRobinBalancerStrategy
extends AbstractBalancerStrategy {
    private ArrayDeque<String> availableEndpoints = new ArrayDeque();

    public RoundRobinBalancerStrategy(ArrayDeque<String> availableEndpoints) {
        this.availableEndpoints = availableEndpoints;
    }

    public RoundRobinBalancerStrategy(Collection<String> availableEndpoints) {
        availableEndpoints.forEach(endpoint -> this.markAsOnline((String)endpoint));
    }

    @Override
    public String next() {
        this.checkEmpty(this.availableEndpoints);
        if (this.availableEndpoints.size() == 1) {
            return this.availableEndpoints.peekFirst();
        }
        return this.roundRobin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String markAsOffline(String url) {
        ArrayDeque<String> arrayDeque = this.availableEndpoints;
        synchronized (arrayDeque) {
            String baseUrl = this.locateUrl(this.availableEndpoints, url);
            this.availableEndpoints.remove(baseUrl);
            return baseUrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String markAsOnline(String url) {
        ArrayDeque<String> arrayDeque = this.availableEndpoints;
        synchronized (arrayDeque) {
            String baseUrl = this.locateUrl(this.availableEndpoints, url);
            if (!this.availableEndpoints.contains(baseUrl)) {
                this.availableEndpoints.addLast(baseUrl);
            }
            return baseUrl;
        }
    }

    @Override
    public List<String> getAvailableEndpoints() {
        return new ArrayList<String>((Collection<String>)this.availableEndpoints.clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String roundRobin() {
        ArrayDeque<String> arrayDeque = this.availableEndpoints;
        synchronized (arrayDeque) {
            String selected = this.availableEndpoints.pollFirst();
            this.availableEndpoints.addLast(selected);
            return selected;
        }
    }

    public String toString() {
        return "RoundRobinBalancerStrategy{availableEndpoints=" + this.availableEndpoints + '}';
    }
}

