/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import junit.framework.TestCase;
import org.junit.Test;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.TaskAssigningRuntimeClient;
import org.kie.server.client.TaskAssigningRuntimeClientFactory;
import org.kie.server.client.impl.TaskAssigningRuntimeClientImpl;

public class TaskAssigningRuntimeClientFactoryTest {
    private static final String ENDPOINT = "ENDPOINT";
    private static final String USER = "USER";
    private static final String PWD = "PWD";
    private static final long TIMEOUT = 1234L;

    @Test
    public void newRuntimeClient() {
        TaskAssigningRuntimeClient client = TaskAssigningRuntimeClientFactory.newRuntimeClient((String)ENDPOINT, (String)USER, (String)PWD, (long)1234L);
        TestCase.assertTrue((boolean)(client instanceof TaskAssigningRuntimeClientImpl));
        TaskAssigningRuntimeClientImpl clientImpl = (TaskAssigningRuntimeClientImpl)client;
        KieServicesConfiguration config = clientImpl.getConfig();
        TestCase.assertEquals((String)ENDPOINT, (String)config.getServerUrl());
        TestCase.assertEquals((String)USER, (String)config.getUserName());
        TestCase.assertEquals((String)PWD, (String)config.getPassword());
        TestCase.assertEquals((float)1234.0f, (float)config.getTimeout(), (float)0.0f);
        TestCase.assertEquals((String)"true", (String)System.getProperty("org.kie.server.bypass.auth.user"));
    }
}

