/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.taskassigning.PlanningExecutionResult;
import org.kie.server.api.model.taskassigning.PlanningItemList;
import org.kie.server.api.model.taskassigning.TaskDataList;
import org.kie.server.api.model.taskassigning.TaskInputVariablesReadMode;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.balancer.LoadBalancer;
import org.kie.server.client.impl.TaskAssigningRuntimeClientImpl;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskAssigningRuntimeClientImplTest {
    private static final String SERVER_URL = "SERVER_URL";
    private static final String USER_ID = "USER_ID";
    private static final Long FROM_TASK_ID = 1L;
    private static final List<String> STATUS = Arrays.asList("Reserved", "InProgress");
    private static final LocalDateTime FROM_LAST_MODIFICATION_DATE = LocalDateTime.now();
    private static final Integer PAGE = 1;
    private static final Integer PAGE_SIZE = 10;
    @Mock
    private KieServicesConfiguration config;
    @Mock
    private LoadBalancer loadBalancer;
    @Mock
    private ClassLoader classLoader;
    @Mock
    private PlanningExecutionResult planningExecutionResult;
    @Mock
    private PlanningItemList planningItemList;
    @Mock
    private TaskDataList taskDataList;
    private Map<String, Object> queryParams;
    private TaskAssigningRuntimeClientImpl runtimeClient;

    @Before
    public void setUp() {
        Mockito.when((Object)this.config.getMarshallingFormat()).thenReturn((Object)MarshallingFormat.XSTREAM);
        Mockito.when((Object)this.config.getLoadBalancer()).thenReturn((Object)this.loadBalancer);
        Mockito.when((Object)this.config.clone()).thenReturn((Object)this.config);
        Mockito.when((Object)this.loadBalancer.getUrl()).thenReturn((Object)SERVER_URL);
        this.runtimeClient = (TaskAssigningRuntimeClientImpl)Mockito.spy((Object)new TaskAssigningRuntimeClientImpl(this.config, this.classLoader));
    }

    @Test
    public void executePlanningRest() {
        Mockito.when((Object)this.config.isRest()).thenReturn((Object)true);
        String expectedUri = "SERVER_URL/taskassigning/runtime/executeplanning?user=USER_ID";
        ((TaskAssigningRuntimeClientImpl)Mockito.doReturn((Object)this.planningExecutionResult).when((Object)this.runtimeClient)).makeHttpPostRequestAndCreateCustomResponse((String)Matchers.eq((Object)expectedUri), Matchers.eq((Object)this.planningItemList), (Class)Matchers.eq(PlanningExecutionResult.class));
        PlanningExecutionResult result = this.runtimeClient.executePlanning(this.planningItemList, USER_ID);
        Assert.assertEquals((Object)this.planningExecutionResult, (Object)result);
    }

    @Test
    public void executePlanningJms() {
        Mockito.when((Object)this.config.isRest()).thenReturn((Object)false);
        Assertions.assertThatThrownBy(() -> this.runtimeClient.executePlanning(this.planningItemList, USER_ID)).hasMessage("JMS protocol is not implemented for this service.");
    }

    @Test
    public void findTasksWithReadModeRest() {
        Mockito.when((Object)this.config.isRest()).thenReturn((Object)true);
        this.findTasksRest(TaskInputVariablesReadMode.READ_FOR_ALL);
    }

    @Test
    public void findTasksWithoutReadModeRest() {
        Mockito.when((Object)this.config.isRest()).thenReturn((Object)true);
        this.findTasksRest(null);
    }

    @Test
    public void findTasksWithReadModeJms() {
        Mockito.when((Object)this.config.isRest()).thenReturn((Object)false);
        Assertions.assertThatThrownBy(() -> this.runtimeClient.findTasks(FROM_TASK_ID, STATUS, FROM_LAST_MODIFICATION_DATE, PAGE, PAGE_SIZE, TaskInputVariablesReadMode.READ_FOR_ALL)).hasMessage("JMS protocol is not implemented for this service.");
    }

    @Test
    public void findTasksWithoutReadModeJms() {
        Mockito.when((Object)this.config.isRest()).thenReturn((Object)false);
        Assertions.assertThatThrownBy(() -> this.runtimeClient.findTasks(FROM_TASK_ID, STATUS, FROM_LAST_MODIFICATION_DATE, PAGE, PAGE_SIZE)).hasMessage("JMS protocol is not implemented for this service.");
    }

    private void findTasksRest(TaskInputVariablesReadMode mode) {
        this.queryParams = TaskAssigningRuntimeClientImpl.TaskQueryParamsBuilder.builder().fromTaskId(FROM_TASK_ID).status(STATUS).fromLastModificationDate(FROM_LAST_MODIFICATION_DATE).page(PAGE).pageSize(PAGE_SIZE).build();
        if (mode == null) {
            this.queryParams.put("inputVariablesMode", TaskInputVariablesReadMode.DONT_READ.name());
        } else {
            this.queryParams.put("inputVariablesMode", mode.name());
        }
        Mockito.when((Object)this.config.isRest()).thenReturn((Object)true);
        String expectedUri = "SERVER_URL/taskassigning/runtime/queries/taskdata";
        ((TaskAssigningRuntimeClientImpl)Mockito.doReturn((Object)this.taskDataList).when((Object)this.runtimeClient)).makeHttpPostRequestAndCreateCustomResponse((String)Matchers.eq((Object)expectedUri), Matchers.eq(this.queryParams), (Class)Matchers.eq(TaskDataList.class));
        TaskDataList result = mode == null ? this.runtimeClient.findTasks(FROM_TASK_ID, STATUS, FROM_LAST_MODIFICATION_DATE, PAGE, PAGE_SIZE) : this.runtimeClient.findTasks(FROM_TASK_ID, STATUS, FROM_LAST_MODIFICATION_DATE, PAGE, PAGE_SIZE, mode);
        Assert.assertEquals((Object)this.taskDataList, (Object)result);
    }
}

