/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.util;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.model.taskassigning.OrganizationalEntity;
import org.kie.server.api.model.taskassigning.PlanningExecutionResult;
import org.kie.server.api.model.taskassigning.PlanningItemList;
import org.kie.server.api.model.taskassigning.TaskData;
import org.kie.server.api.model.taskassigning.TaskDataList;
import org.kie.server.api.model.taskassigning.TaskInputVariablesReadMode;
import org.kie.server.client.TaskAssigningRuntimeClient;
import org.kie.server.client.util.TaskDataReader;

@RunWith(value=Parameterized.class)
public class TaskDataReaderTest {
    private long TASK1 = 1L;
    private long TASK2 = 2L;
    private long TASK3 = 3L;
    private long TASK4 = 4L;
    private long TASK5 = 5L;
    private String PO1 = "PO1";
    private String PO2 = "PO2";
    private String PO3 = "PO3";
    private String PO4 = "PO4";
    private String PO5 = "PO5";
    private TaskAssigningRuntimeClient runtimeClient;
    private List<Pair<Long, String>> dataSet = new ArrayList<Pair<Long, String>>();
    private TaskDataReader reader;
    @Parameterized.Parameter
    public int pageSize;

    @Parameterized.Parameters(name="readTasks({0})")
    public static Object[] data() {
        return new Object[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};
    }

    @Before
    public void setUp() {
        this.runtimeClient = new TaskAssigningRuntimeClientMock();
        this.reader = TaskDataReader.from((TaskAssigningRuntimeClient)this.runtimeClient);
        this.dataSet = Arrays.asList(Pair.of((Object)this.TASK1, (Object)this.PO1), Pair.of((Object)this.TASK1, (Object)this.PO2), Pair.of((Object)this.TASK1, (Object)this.PO3), Pair.of((Object)this.TASK2, null), Pair.of((Object)this.TASK3, (Object)this.PO1), Pair.of((Object)this.TASK3, (Object)this.PO2), Pair.of((Object)this.TASK3, (Object)this.PO3), Pair.of((Object)this.TASK3, (Object)this.PO4), Pair.of((Object)this.TASK4, (Object)this.PO5), Pair.of((Object)this.TASK5, (Object)this.PO2), Pair.of((Object)this.TASK5, (Object)this.PO3), Pair.of((Object)this.TASK5, (Object)this.PO4), Pair.of((Object)this.TASK5, (Object)this.PO5));
    }

    @Test
    public void readTasks1() {
        TaskDataReader.Result result = this.reader.readTasks(0L, null, null, this.pageSize, null);
        this.verifyTasks(result.getTasks());
    }

    @Test
    public void readTasks2() {
        TaskDataReader.Result result = this.reader.readTasks(0L, null, null, this.pageSize);
        this.verifyTasks(result.getTasks());
    }

    private void verifyTasks(List<TaskData> taskDataList) {
        Assert.assertEquals((Object)this.mockTaskData(this.TASK1, this.PO1, this.PO2, this.PO3), (Object)taskDataList.get(0));
        Assert.assertEquals((Object)this.mockTaskData(this.TASK2, new String[0]), (Object)taskDataList.get(1));
        Assert.assertEquals((Object)this.mockTaskData(this.TASK3, this.PO1, this.PO2, this.PO3, this.PO4), (Object)taskDataList.get(2));
        Assert.assertEquals((Object)this.mockTaskData(this.TASK4, this.PO5), (Object)taskDataList.get(3));
        Assert.assertEquals((Object)this.mockTaskData(this.TASK5, this.PO2, this.PO3, this.PO4, this.PO5), (Object)taskDataList.get(4));
    }

    private TaskData mockTaskData(Long taskId, String ... potentialOwners) {
        Set potentialOwnersSet = Stream.of(potentialOwners).map(po -> OrganizationalEntity.builder().name(po).build()).collect(Collectors.toSet());
        return TaskData.builder().taskId(taskId).potentialOwners(potentialOwnersSet).build();
    }

    private class TaskAssigningRuntimeClientMock
    implements TaskAssigningRuntimeClient {
        private TaskAssigningRuntimeClientMock() {
        }

        public PlanningExecutionResult executePlanning(PlanningItemList planningItemList, String userId) {
            return null;
        }

        public TaskDataList findTasks(Long fromTaskId, List<String> status, LocalDateTime fromLastModificationDate, Integer page, Integer pageSize) {
            return this.findTasks(fromTaskId, status, fromLastModificationDate, page, pageSize);
        }

        public TaskDataList findTasks(Long fromTaskId, List<String> status, LocalDateTime fromLastModificationDate, Integer page, Integer pageSize, TaskInputVariablesReadMode taskInputVariablesReadMode) {
            int offset = page * pageSize;
            long previousTaskId = -1L;
            ArrayList<TaskData> result = new ArrayList<TaskData>();
            TaskData taskData = null;
            List filteredDataSet = TaskDataReaderTest.this.dataSet.stream().filter(row -> (Long)row.getLeft() >= fromTaskId).collect(Collectors.toList());
            for (int count = 0; offset < filteredDataSet.size() && count < pageSize; ++count, ++offset) {
                String potentialOwnerId;
                long taskId = (Long)((Pair)filteredDataSet.get(offset)).getLeft();
                if (previousTaskId != taskId) {
                    previousTaskId = taskId;
                    taskData = TaskData.builder().taskId(Long.valueOf(taskId)).potentialOwners(new HashSet()).build();
                    result.add(taskData);
                }
                if (StringUtils.isEmpty((CharSequence)(potentialOwnerId = (String)((Pair)filteredDataSet.get(offset)).getRight()))) continue;
                taskData.getPotentialOwners().add(OrganizationalEntity.builder().name(potentialOwnerId).build());
            }
            return new TaskDataList(result);
        }
    }
}

