/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import com.github.tomakehurst.wiremock.junit.WireMockRule;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collections;
import org.junit.Rule;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseKieServicesClientTest {
    private static Logger logger = LoggerFactory.getLogger(BaseKieServicesClientTest.class);
    private final int port = BaseKieServicesClientTest.findFreePort();
    protected final String mockServerBaseUri = "http://localhost:" + this.port;
    protected final KieServicesConfiguration config;
    @Rule
    public WireMockRule wireMockRule = new WireMockRule(this.port);

    public BaseKieServicesClientTest() {
        try {
            this.config = KieServicesFactory.newRestConfiguration((String)this.mockServerBaseUri, null, null);
            this.config.setCapabilities(Collections.emptyList());
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating configuration", e);
        }
    }

    public static int findFreePort() {
        int port = 0;
        try {
            ServerSocket server = new ServerSocket(0);
            port = server.getLocalPort();
            server.close();
        }
        catch (IOException e) {
            port = 9789;
        }
        logger.debug("Allocating port: " + port);
        return port;
    }
}

